<?php

/**
 * Custom template tags for this theme
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package neeha
 */

/**
 *
 * neeha header
 */

function neeha_check_header()
{
    $neeha_header_style = function_exists('get_field') ? get_field('header_style') : NULL;
    $neeha_default_header_style = get_theme_mod('choose_default_header', 'header-style-1');

    if ($neeha_header_style == 'header-style-1') {
        neeha_header_style_1();
    } elseif ($neeha_header_style == 'header-style-2') {
        neeha_header_style_2();
    } elseif ($neeha_header_style == 'header-style-3') {
        neeha_header_style_3();
    } elseif ($neeha_header_style == 'header-style-4') {
        neeha_header_style_4();
    } elseif ($neeha_header_style == 'header-style-5') {
        neeha_header_style_5();
    } elseif ($neeha_header_style == 'header-style-6') {
        neeha_header_style_6();
    } else {

        /** default header style **/
        if ($neeha_default_header_style == 'header-style-2') {
            neeha_header_style_2();
        } elseif ($neeha_default_header_style == 'header-style-3') {
            neeha_header_style_3();
        } elseif ($neeha_default_header_style == 'header-style-4') {
            neeha_header_style_4();
        } elseif ($neeha_default_header_style == 'header-style-5') {
            neeha_header_style_5();
        } elseif ($neeha_default_header_style == 'header-style-6') {
            neeha_header_style_6();
        } else {
            neeha_header_style_1();
        }
    }
}
add_action('neeha_header_style', 'neeha_check_header', 10);

/**
 * header style 1 + default
 */

function neeha_header_style_1()
{

    $header_phone = get_theme_mod('neeha_header_phone', __('Help Line : +123(456)789', 'neeha'));
    $header_mail = get_theme_mod('neeha_header_mail', __('support@gmail.com', 'neeha'));
    $header_address = get_theme_mod('neeha_header_address', __('257 New Road, New York', 'neeha'));
    $neeha_header_right = get_theme_mod('neeha_header_right', false);
    $neeha_topbar_switch = get_theme_mod('neeha_topbar_switch', false);

?>

    <!-- Header style 1 -->
    <div class="header p-0">
        <?php if (!empty($neeha_topbar_switch)): ?>
            <div class="header__top grey-bg">
                <div class="container">
                    <div class="row align-items-center">
                        <div class="col-lg-7 col-md-6 d-none d-md-block">
                            <div class="header__meta header__meta--ex">
                                <ul>
                                    <?php if (!empty($header_phone)) : ?>
                                        <li>
                                            <i class="fal fa-phone"></i>
                                            <span><?php print esc_html($header_phone); ?></span>
                                        </li>
                                    <?php endif; ?>

                                    <?php if (!empty($header_mail)) : ?>
                                        <li>
                                            <i class="fal fa-envelope-open"></i>
                                            <span><?php print esc_html($header_mail); ?></span>
                                        </li>
                                    <?php endif; ?>

                                    <?php if (!empty($header_address)) : ?>
                                        <li>
                                            <i class="fal fa-map-marked-alt"></i>
                                            <span><?php print esc_html($header_address); ?></span>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </div>
                        <div class="col-lg-5 col-md-6">
                            <div class="header__top--right">
                                <div class="header__top--lang header__top--lang--ex">
                                    <?php neeha_header_lang_defualt(); ?>
                                </div>
                                <div class="header__top--social header__top--social--ex">
                                    <?php neeha_header_social_profiles(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif;  ?>
        <div class="header__bottom header__bottom--padding">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-xl-12 col-lg-12 col-md-12">
                        <div class="row align-items-center">
                            <div class="col-lg-3 col-md-6 col-8">
                                <div class="header--logo">
                                    <?php neeha_header_logo(); ?>
                                </div>
                            </div>
                            <div class="col-lg-9 col-md-4 d-none d-md-block">
                                <div class="header--menu text-right">
                                    <div class="header--menu__main header--menu__main--h4">
                                        <nav id="mobile-menu">
                                            <?php neeha_header_menu(); ?>
                                        </nav>
                                        <?php if (!empty($neeha_header_right)): ?>
                                            <div class="header__burger d-none d-lg-block">
                                                <ul>
                                                    <li><a class="header__search nav-search search-trigger" href="#"><i class="fal fa-search"></i></a></li>
                                                    <li><a class="header__burger--menu bar" href="#"><i class="fal fa-bars"></i></a>
                                                    </li>
                                                </ul>
                                            </div>
                                        <?php endif;  ?>
                                    </div>
                                </div>
                            </div>
                            <div class="d-block d-lg-none col-md-2 col-4 text-right">
                                <div class="open-mobile-menu">
                                    <a href="javascript:void(0);">
                                        <i class="far fa-bars"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <aside class="sidebar-menu">
        <div class="close-mobile-menu">
            <a href="javascript:void(0);"><i class="far fa-times"></i></a>
        </div>
        <div class="mobile-menu"></div>
    </aside>
    <div class="body-overlay"></div>

    <!-- side-bar start -->
    <?php neeha_extra_info(); ?>
    <!-- side-bar end -->
<?php
}

/**
 * header style 2 
 */
function neeha_header_style_2()
{
    // top left
    $neeha_phone_label = get_theme_mod('neeha_phone_label', __('Phone Number', 'neeha'));
    $neeha_phone = get_theme_mod('neeha_phone', __('+812 (345) 6789', 'neeha'));

?>
    <!-- Header style 2 -->
    <div class="header position-relative header-style-2">
        <div class="header__shape">
            <img class="shape--img" src="<?php echo get_template_directory_uri(); ?>/assets/images/shape/dot-line-shape.png" alt="img">
        </div>
        <div class="container-fluid">
            <div class="header--box">
                <div class="row align-items-center">
                    <div class="col-lg-9 col-8 col-md-6">
                        <div class="row align-items-center">
                            <div class="col-lg-2">
                                <div class="header--logo">
                                    <?php neeha_header_logo(); ?>
                                </div>
                            </div>
                            <div class="col-lg-10">
                                <div class="header--menu">
                                    <div class="header--menu__main">
                                        <nav id="mobile-menu">
                                            <?php neeha_header_menu(); ?>
                                        </nav>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 d-none d-lg-block">
                        <div class="header__right d-flex align-items-center justify-content-end">
                            <div class="header-lang d-lp-none">
                                <?php neeha_header_lang_img_defualt(); ?>
                            </div>
                            <div class="header--contacts d-flex align-items-center ml-20">
                                <div class="header--contacts-icon">
                                    <i class="fal fa-phone"></i>
                                </div>
                                <div class="header--contacts-number pl-10">
                                    <h6><?php print esc_html($neeha_phone_label); ?></h6>
                                    <span class="fw-500 white-color"><?php print esc_html($neeha_phone); ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="d-block d-lg-none col-md-6 col-4 text-right">
                        <div class="open-mobile-menu">
                            <a href="javascript:void(0);">
                                <i class="fas fa-bars"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <aside class="sidebar-menu">
        <div class="close-mobile-menu">
            <a href="javascript:void(0);"><i class="far fa-times"></i></a>
        </div>
        <div class="mobile-menu"></div>
    </aside>
    <div class="body-overlay"></div>

<?php
}

/**
 * header style 3
 */
function neeha_header_style_3()
{
    $neeha_phone_label = get_theme_mod('neeha_phone_label', __('Phone Number', 'neeha'));
    $neeha_phone = get_theme_mod('neeha_phone', __('+812 (345) 6789', 'neeha'));

?>

    <!-- Header style 3 -->
    <div class="header position-relative header-style-3">
        <div class="header__shape header__shape--h2 d-lg-none d-xl-block">
            <img class="shape--img" src="<?php echo get_template_directory_uri(); ?>/assets/images/shape/dot-line-shape.png" alt="img">
        </div>
        <div class="container-fluid">
            <div class="header--box header--box--h2">
                <div class="row align-items-center">
                    <div class="col-xl-8 col-lg-12 col-md-8 col-8">
                        <div class="row align-items-center">
                            <div class="col-xl-2 col-lg-3 col-md-8">
                                <div class="header--logo">
                                    <?php neeha_header_logo(); ?>
                                </div>
                            </div>
                            <div class="col-xl-10 col-lg-9 col-md-4">
                                <div class="header--menu header--menu--h2 d-flex align-items-center justify-content-lg-around">
                                    <div class="header--menu__main">
                                        <nav id="mobile-menu">
                                            <?php neeha_header_menu(); ?>
                                        </nav>
                                    </div>
                                    <div class="header-lang header-lang--h2">
                                        <?php neeha_header_lang_img_defualt(); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-4 d-none d-xl-block">
                        <div class="header__right header__right--h2 d-flex align-items-center justify-content-end">
                            <div class="header--social d-none d-xl-block">
                                <?php neeha_header_social_profiles(); ?>
                            </div>
                            <div class="header--contacts header--contacts--h2 d-flex align-items-center ml-10">
                                <div class="header--contacts-icon">
                                    <i class="fal fa-phone"></i>
                                </div>
                                <div class="header--contacts-number pl-10">
                                    <h6><?php print esc_html($neeha_phone_label); ?></h6>
                                    <span class="fw-500 white-color"><?php print esc_html($neeha_phone); ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="d-block d-lg-none col-md-4 col-4 text-right">
                        <div class="open-mobile-menu">
                            <a href="javascript:void(0);">
                                <i class="fas fa-bars"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <aside class="sidebar-menu">
        <div class="close-mobile-menu">
            <a href="javascript:void(0);"><i class="far fa-times"></i></a>
        </div>
        <div class="mobile-menu"></div>
    </aside>
    <div class="body-overlay"></div>

<?php
}

/**
 * header style 4
 */
function neeha_header_style_4()
{

    $btn_text = get_theme_mod('neeha_button_text', __('Get A Quote', 'neeha'));
    $btn_link = get_theme_mod('neeha_button_link', __('#', 'neeha'));


?>

    <!-- Header style 4 -->
    <div class="header header--trans header-style-4">
        <div class="container-fluid">
            <div class="header--box header--box--h2">
                <div class="row align-items-center">
                    <div class="col-xl-10 col-lg-9 col-8">
                        <div class="row align-items-center">
                            <div class="col-lg-2">
                                <div class="header--logo">
                                    <?php neeha_header_logo(); ?>
                                </div>
                            </div>
                            <div class="col-lg-10">
                                <div class="header--menu header--menu--h3 text-center">
                                    <div class="header--menu__main">
                                        <nav id="mobile-menu">
                                            <?php neeha_header_menu(); ?>
                                        </nav>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-2 col-lg-3 d-none d-lg-block">
                        <?php if (!empty($btn_link)) : ?>
                            <div class="header__right d-flex align-items-center justify-content-end">
                                <div class="header__btn">
                                    <a href="<?php print esc_url($btn_link); ?>" class="btn btn--icon btn--white theme-color"><?php print esc_html($btn_text); ?></a>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="col-md-4 col-4 d-block d-lg-none text-right">
                        <div class="open-mobile-menu">
                            <a href="javascript:void(0);">
                                <i class="fas fa-bars"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <aside class="sidebar-menu">
        <div class="close-mobile-menu">
            <a href="javascript:void(0);"><i class="far fa-times"></i></a>
        </div>
        <div class="mobile-menu"></div>
    </aside>
    <div class="body-overlay"></div>

<?php
}

/**
 * header style 5
 */
function neeha_header_style_5()
{
    $neeha_topbar_switch = get_theme_mod('neeha_topbar_switch', false);
    $header_phone = get_theme_mod('neeha_header_phone', __('Help Line : +123(456)789', 'neeha'));
    $header_mail = get_theme_mod('neeha_header_mail', __('support@gmail.com', 'neeha'));
    $header_address = get_theme_mod('neeha_header_address', __('257 New Road, New York', 'neeha'));

?>

    <!-- Header style 5 -->
    <div class="header p-0 header-style-5">
        <?php if (!empty($neeha_topbar_switch)): ?>
            <div class="header__top theme-bg">
                <div class="container">
                    <div class="row align-items-center">
                        <div class="col-lg-7 col-md-6 d-none d-md-block">
                            <div class="header__meta">
                                <ul>
                                    <?php if (!empty($header_phone)) : ?>
                                        <li>
                                            <i class="fal fa-phone"></i>
                                            <span><?php print esc_html($header_phone); ?></span>
                                        </li>
                                    <?php endif; ?>

                                    <?php if (!empty($header_mail)) : ?>
                                        <li>
                                            <i class="fal fa-envelope-open"></i>
                                            <span><?php print esc_html($header_mail); ?></span>
                                        </li>
                                    <?php endif; ?>

                                    <?php if (!empty($header_address)) : ?>
                                        <li>
                                            <i class="fal fa-map-marked-alt"></i>
                                            <span><?php print esc_html($header_address); ?></span>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </div>
                        <div class="col-lg-5 col-md-6">
                            <div class="header__top--right">
                                <div class="header__top--lang">
                                    <?php neeha_header_lang_defualt(); ?>
                                </div>
                                <div class="header__top--social">
                                    <?php neeha_header_social_profiles(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
        <div class="header__bottom header__bottom--padding">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-xl-12 col-lg-12 col-md-12">
                        <div class="row align-items-center">
                            <div class="col-lg-3 col-md-6 col-8">
                                <div class="header--logo">
                                    <?php neeha_header_logo(); ?>
                                </div>
                            </div>
                            <div class="col-lg-9 col-md-4 d-none d-lg-block">
                                <div class="header--menu text-right">
                                    <div class="header--menu__main header--menu__main--h4">
                                        <nav id="mobile-menu">
                                            <?php neeha_header_menu(); ?>
                                        </nav>
                                        <div class="header__burger d-none d-md-block">
                                            <ul>
                                                <li><a class="header__search nav-search search-trigger" href="#"><i class="fal fa-search"></i></a></li>
                                                <li><a class="header__burger--menu bar" href="javascript:void(0);"><i class="fal fa-bars"></i></a>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="d-block d-lg-none col-md-2 col-4 text-right">
                                <div class="open-mobile-menu">
                                    <a href="javascript:void(0);">
                                        <i class="far fa-bars"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <aside class="sidebar-menu">
        <div class="close-mobile-menu">
            <a href="javascript:void(0);"><i class="far fa-times"></i></a>
        </div>
        <div class="mobile-menu"></div>
    </aside>
    <div class="body-overlay"></div>

    <!-- side-bar start -->
    <?php neeha_extra_info(); ?>
    <!-- side-bar end -->


<?php
}

/**
 * header style 6
 */
function neeha_header_style_6()
{
    $neeha_topbar_switch = get_theme_mod('neeha_topbar_switch', false);

    // top left
    $header_phone = get_theme_mod('neeha_header_phone', __('Help Line : +123(456)789', 'neeha'));
    $header_mail = get_theme_mod('neeha_header_mail', __('support@gmail.com', 'neeha'));
    $header_address = get_theme_mod('neeha_header_address', __('257 New Road, New York', 'neeha'));

    $btn_text = get_theme_mod('neeha_button_text', __('Get A Quote', 'neeha'));
    $btn_link = get_theme_mod('neeha_button_link', __('#', 'neeha'));

?>

    <!-- Header style 6 -->
    <div class="header p-0 theme-bg header-style-6">
        <?php if (!empty($neeha_topbar_switch)): ?>
            <div class="header__top header__top--h5 header__padding--h5 d-none d-lg-block">
                <div class="container-fluid">
                    <div class="row align-items-center">
                        <div class="col-lg-7 col-md-6 d-none d-lg-block">
                            <div class="header__meta header__meta--h5">
                                <ul>
                                    <?php if (!empty($header_phone)) : ?>
                                        <li>
                                            <i class="fal fa-phone"></i>
                                            <span><?php print esc_html($header_phone); ?></span>
                                        </li>
                                    <?php endif; ?>

                                    <?php if (!empty($header_mail)) : ?>
                                        <li>
                                            <i class="fal fa-envelope-open"></i>
                                            <span><?php print esc_html($header_mail); ?></span>
                                        </li>
                                    <?php endif; ?>

                                    <?php if (!empty($header_address)) : ?>
                                        <li>
                                            <i class="fal fa-map-marked-alt"></i>
                                            <span><?php print esc_html($header_address); ?></span>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </div>
                        <div class="col-lg-5 col-md-6">
                            <div class="header__top--right">
                                <div class="header__top--lang header__lang header__lang--h5">
                                    <?php neeha_header_lang_defualt(); ?>
                                </div>
                                <div class="header__top--social header__top--social--h5">
                                    <?php neeha_header_social_profiles(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
        <div class="header__bottom header__padding--h5">
            <div class="container-fluid">
                <div class="row align-items-center">
                    <div class="col-xl-12">
                        <div class="row align-items-center">
                            <div class="col-lg-2 col-md-4 col-8">
                                <div class="header--logo header__logo--h5">
                                    <?php neeha_header_logo(); ?>
                                </div>
                            </div>
                            <div class="col-lg-10 col-md-8 d-none d-lg-block">
                                <div class="header--menu text-right d-flex align-items-center justify-content-end">
                                    <div class="header--menu__main header--menu--h5">
                                        <nav id="mobile-menu">
                                            <?php neeha_header_menu(); ?>
                                        </nav>
                                    </div>
                                    <?php if (!empty($btn_link)) : ?>
                                        <div class="header__button--h5 d-none d-lg-block">
                                            <a href="<?php print esc_url($btn_link); ?>" class="btn btn--blue btn--icon btn--border--round btn--border--h5 white-color" data-animation="fadeInLeft" data-delay=".6s"><?php print esc_html($btn_text); ?></a>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="d-block d-lg-none col-md-8 col-4 text-right">
                                <div class="open-mobile-menu">
                                    <a href="javascript:void(0);">
                                        <i class="far fa-bars"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Header End /-->

    <aside class="sidebar-menu">
        <div class="close-mobile-menu">
            <a href="javascript:void(0);"><i class="far fa-times"></i></a>
        </div>
        <div class="mobile-menu"></div>
    </aside>
    <div class="body-overlay"></div>
<?php
}


/** 
 * [neeha_extra_info description]
 * @return [type] [description]
 */
function neeha_extra_info()
{
    $side_logo   = get_theme_mod('side_logo', get_template_directory_uri() . '/assets/images/logo/white-logo.png');

    // about title
    $neeha_side_office     = get_theme_mod('neeha_side_office');
    $neeha_side_phone     = get_theme_mod('neeha_side_phone');
    $neeha_side_email     = get_theme_mod('neeha_side_email');

    $neeha_side_fb_url             = get_theme_mod('neeha_side_fb_url', __('#', 'neeha'));
    $neeha_side_twitter_url       = get_theme_mod('neeha_side_twitter_url', __('#', 'neeha'));
    $neeha_side_instagram_url      = get_theme_mod('neeha_side_instagram_url', __('#', 'neeha'));
    $neeha_side_linkedin_url      = get_theme_mod('neeha_side_linkedin_url', __('#', 'neeha'));
    $neeha_side_youtube_url        = get_theme_mod('neeha_side_youtube_url', __('#', 'neeha'));

?>

    <div class="btn-menu-main">
        <div class="logo-side mb-30">
            <?php if (!empty($side_logo)) : ?>
                <a href="<?php print home_url(); ?>">
                    <img src="<?php print esc_url($side_logo); ?>" alt="<?php esc_attr('Logo', 'neeha'); ?>" />
                </a>
            <?php endif; ?>
            <i class="fas fa-times crose"></i>
        </div>

        <div class="side-info mb-30">
            <div class="contact-list mb-30">
                <?php print wp_kses_post($neeha_side_office); ?>
            </div>
            <div class="contact-list mb-30">
                <?php print wp_kses_post($neeha_side_phone); ?>
            </div>
            <div class="contact-list mb-30">
                <?php print wp_kses_post($neeha_side_email); ?>
            </div>
        </div>

        <div class="side-widget">
            <?php
            if (is_active_sidebar('offset-sidebar')) {
                dynamic_sidebar('offset-sidebar');
            }
            ?>
        </div>

        <div class="instagram">
            <?php
            $q = new WP_Query(array(
                'post_type'     => 'bdevs-portfolio',
                'posts_per_page' => '6',
                'order'         => 'DESC'
            ));

            if ($q->have_posts()):
                while ($q->have_posts()): $q->the_post();
            ?>
                    <a href="<?php the_permalink(); ?>">
                        <?php the_post_thumbnail('medium', array('class' => 'img-responsive')); ?>
                    </a>
            <?php
                endwhile;
                wp_reset_query();
            endif;
            ?>
        </div>

        <div class="social-icon-right mt-20">
            <?php if (!empty($neeha_side_fb_url)): ?>
                <a href="<?php print esc_url($neeha_side_fb_url); ?>"><i class="fab fa-facebook-f"></i></a>
            <?php endif; ?>

            <?php if (!empty($neeha_side_twitter_url)): ?>
                <a href="<?php print esc_url($neeha_side_twitter_url); ?>"><i class="fab fa-twitter"></i></a>
            <?php endif; ?>

            <?php if (!empty($neeha_side_instagram_url)): ?>
                <a href="<?php print esc_url($neeha_side_instagram_url); ?>"><i class="fab fa-instagram"></i></a>
            <?php endif; ?>

            <?php if (!empty($neeha_side_linkedin_url)): ?>
                <a href="<?php print esc_url($neeha_side_linkedin_url); ?>"><i class="fab fa-linkedin"></i></a>
            <?php endif; ?>

            <?php if (!empty($neeha_side_youtube_url)): ?>
                <a href="<?php print esc_url($neeha_side_youtube_url); ?>"><i class="fab fa-youtube"></i></a>
            <?php endif; ?>
        </div>

    </div>

    <?php }

/** 
 * [neeha_header_lang img description]
 * @return [type] [description]
 */
function neeha_header_lang_img_defualt()
{
    $neeha_header_lang  = get_theme_mod('neeha_header_lang', false);
    if (!empty($neeha_header_lang)): ?>
        <ul>
            <li><a href="#0" class="lang__btn"><img src="<?php echo get_template_directory_uri(); ?>/assets/images/icon/flag.png" alt="img" class="lang-flag"></a>
                <?php do_action('neeha_img_language'); ?>
            </li>
        </ul>
    <?php endif; ?>
    <?php
}


/** 
 * [neeha_language_list description]
 * @return [type] [description]
 */
function _neeha_img_language($mar)
{
    return $mar;
}
function neeha_language_img_list()
{

    $mar = '';
    $languages = apply_filters('wpml_active_languages', NULL, 'orderby=id&order=desc');
    if (!empty($languages)) {
        $mar = '<ul class="langu-list">';
        foreach ($languages as $lan) {
            $active = $lan['active'] == 1 ? 'active' : '';
            $mar .= '<li class="' . $active . '"><a href="' . $lan['url'] . '">' . $lan['translated_name'] . '</a></li>';
        }
        $mar .= '</ul>';
    } else {
        //remove this code when send themeforest reviewer team
        $mar .= '<ul class="langu-list">';
        $mar .= '<li><a href="#">' . esc_html__('English', 'neeha') . '</a></li>';
        $mar .= '<li><a href="#">' . esc_html__('Arabic', 'neeha') . '</a></li>';
        $mar .= '<li><a href="#">' . esc_html__('France', 'neeha') . '</a></li>';
        $mar .= '<li><a href="#">' . esc_html__('Bangla', 'neeha') . '</a></li>';
        $mar .= ' </ul>';
    }
    print _neeha_img_language($mar);
}
add_action('neeha_img_language', 'neeha_language_img_list');



/** 
 * [neeha_header_lang description]
 * @return [type] [description]
 */
function neeha_header_lang_defualt()
{
    $neeha_header_lang            = get_theme_mod('neeha_header_lang', false);
    if ($neeha_header_lang): ?>

        <ul>
            <li><a href="#0" class="lang__btn"><i class="fal fa-flag"></i><?php print esc_html__('English', 'neeha'); ?></a>
                <?php do_action('neeha_language'); ?>
            </li>
        </ul>

    <?php endif; ?>
<?php
}


/** 
 * [neeha_language_list description]
 * @return [type] [description]
 */
function _neeha_language($mar)
{
    return $mar;
}
function neeha_language_list()
{

    $mar = '';
    $languages = apply_filters('wpml_active_languages', NULL, 'orderby=id&order=desc');
    if (!empty($languages)) {
        $mar = '<ul class="langu-list">';
        foreach ($languages as $lan) {
            $active = $lan['active'] == 1 ? 'active' : '';
            $mar .= '<li class="' . $active . '"><a href="' . $lan['url'] . '">' . $lan['translated_name'] . '</a></li>';
        }
        $mar .= '</ul>';
    } else {
        //remove this code when send themeforest reviewer team
        $mar .= '<ul class="langu-list">';
        $mar .= '<li><a href="#">' . esc_html__('English', 'neeha') . '</a></li>';
        $mar .= '<li><a href="#">' . esc_html__('Arabic', 'neeha') . '</a></li>';
        $mar .= '<li><a href="#">' . esc_html__('France', 'neeha') . '</a></li>';
        $mar .= '<li><a href="#">' . esc_html__('Bangla', 'neeha') . '</a></li>';
        $mar .= ' </ul>';
    }
    print _neeha_language($mar);
}
add_action('neeha_language', 'neeha_language_list');


// header logo
function neeha_header_logo()
{
?>
    <?php
    $neeha_logo = get_template_directory_uri() . '/assets/images/logo/logo.png';
    $neeha_site_logo = get_theme_mod('logo', $neeha_logo);
    $header_page_logo = function_exists('get_field') ? get_field('header_page_logo') : NULL;
    $neeha_site_logo = $header_page_logo ? $header_page_logo['url'] : $neeha_site_logo;
    ?>

    <?php
    if (has_custom_logo()) {
        the_custom_logo();
    } else {
    ?>
        <a class="standard-logo" href="<?php print esc_url(home_url('/')); ?>">
            <img src="<?php print esc_url($neeha_site_logo); ?>" alt="<?php print esc_attr('logo', 'neeha'); ?>" />
        </a>
    <?php

    }
    ?>
<?php
}


/** 
 * [neeha_header_social_profiles description]
 * @return [type] [description]
 */
function neeha_header_social_profiles()
{
    $neeha_topbar_fb_url             = get_theme_mod('neeha_topbar_fb_url', __('#', 'neeha'));
    $neeha_topbar_twitter_url       = get_theme_mod('neeha_topbar_twitter_url', __('#', 'neeha'));
    $neeha_topbar_instagram_url      = get_theme_mod('neeha_topbar_instagram_url', __('#', 'neeha'));
    $neeha_topbar_linkedin_url      = get_theme_mod('neeha_topbar_linkedin_url', __('#', 'neeha'));
    $neeha_topbar_youtube_url        = get_theme_mod('neeha_topbar_youtube_url', __('#', 'neeha'));
?>
    <ul>
        <?php if (!empty($neeha_topbar_fb_url)): ?>
            <li><a href="<?php print esc_url($neeha_topbar_fb_url); ?>"><i class="fab fa-facebook-f"></i></a></li>
        <?php endif; ?>

        <?php if (!empty($neeha_topbar_twitter_url)): ?>
            <li><a href="<?php print esc_url($neeha_topbar_twitter_url); ?>"><i class="fab fa-twitter"></i></a></li>
        <?php endif; ?>

        <?php if (!empty($neeha_topbar_instagram_url)): ?>
            <li><a href="<?php print esc_url($neeha_topbar_instagram_url); ?>"><i class="fab fa-instagram"></i></a></li>
        <?php endif; ?>

        <?php if (!empty($neeha_topbar_linkedin_url)): ?>
            <li><a href="<?php print esc_url($neeha_topbar_linkedin_url); ?>"><i class="fab fa-linkedin"></i></a></li>
        <?php endif; ?>

        <?php if (!empty($neeha_topbar_youtube_url)): ?>
            <li><a href="<?php print esc_url($neeha_topbar_youtube_url); ?>"><i class="fab fa-youtube"></i></a></li>
        <?php endif; ?>
    </ul>
<?php
}


function neeha_footer_social_profiles()
{
    $neeha_footer_fb_url             = get_theme_mod('neeha_footer_fb_url', __('#', 'neeha'));
    $neeha_footer_twitter_url       = get_theme_mod('neeha_footer_twitter_url', __('#', 'neeha'));
    $neeha_footer_vine_url      = get_theme_mod('neeha_footer_vine_url', __('#', 'neeha'));
    $neeha_footer_weebly_url        = get_theme_mod('neeha_footer_weebly_url', __('#', 'neeha'));
    $neeha_footer_vuejs_url        = get_theme_mod('neeha_footer_vuejs_url', __('#', 'neeha'));
?>
    <ul class="mb-0">
        <?php if ($neeha_footer_fb_url): ?>
            <li><a href="<?php print esc_url($neeha_footer_fb_url); ?>"><i class="fab fa-facebook-f"></i></a></li>
        <?php endif; ?>

        <?php if ($neeha_footer_twitter_url): ?>
            <li><a href="<?php print esc_url($neeha_footer_twitter_url); ?>"><i class="fab fa-twitter"></i></a></li>
        <?php endif; ?>

        <?php if ($neeha_footer_vine_url): ?>
            <li><a href="<?php print esc_url($neeha_footer_vine_url); ?>"><i class="fab fa-vine"></i></a></li>
        <?php endif; ?>

        <?php if ($neeha_footer_weebly_url): ?>
            <li><a href="<?php print esc_url($neeha_footer_weebly_url); ?>"><i class="fab fa-weebly"></i></a></li>
        <?php endif; ?>

        <?php if ($neeha_footer_vuejs_url): ?>
            <li><a href="<?php print esc_url($neeha_footer_vuejs_url); ?>"><i class="fab fa-vuejs"></i></a></li>
        <?php endif; ?>
    </ul>
<?php
}

/** 
 * [neeha_header_menu description]
 * @return [type] [description]
 */
function neeha_header_menu()
{ ?>
    <?php
    wp_nav_menu(array(
        'theme_location'    => 'main-menu',
        'menu_class'        => '',
        'container'         => '',
        'fallback_cb'       => 'Navwalker_Class::fallback',
        'walker'            => new Navwalker_Class
    ));
    ?>
<?php
}

/**
 *
 * neeha footer
 */
add_action('neeha_footer_style', 'neeha_check_footer', 10);

function neeha_check_footer()
{
    $neeha_footer_style = function_exists('get_field') ? get_field('footer_style') : NULL;
    $neeha_default_footer_style = get_theme_mod('choose_default_footer', 'footer-style-1');


    if ($neeha_footer_style == 'footer-style-1') {
        neeha_footer_style_1();
    } elseif ($neeha_footer_style == 'footer-style-2') {
        neeha_footer_style_2();
    } elseif ($neeha_footer_style == 'footer-style-3') {
        neeha_footer_style_3();
    } else {

        /** default footer style **/
        if ($neeha_default_footer_style == 'footer-style-2') {
            neeha_footer_style_2();
        } elseif ($neeha_default_footer_style == 'footer-style-3') {
            neeha_footer_style_3();
        } else {
            neeha_footer_style_1();
        }
    }
}

/**
 * footer  style_defaut
 */
function neeha_footer_style_1()
{

    // footer_columns
    $footer_columns = 0;
    $footer_widgets = get_theme_mod('footer_widget_number', 4);

    for ($num = 1; $num <= $footer_widgets; $num++) {
        if (is_active_sidebar('footer-' . $num)) {
            $footer_columns++;
        }
    }

    switch ($footer_columns) {
        case '1':
            $footer_class[1] = 'col-lg-12';
            break;
        case '2':
            $footer_class[1] = 'col-lg-6 col-md-6';
            $footer_class[2] = 'col-lg-6 col-md-6';
            break;
        case '3':
            $footer_class[1] = 'col-xl-4 col-lg-6 col-md-5';
            $footer_class[2] = 'col-xl-4 col-lg-6 col-md-7';
            $footer_class[3] = 'col-xl-4 col-lg-6';
            break;
        case '4':
            $footer_class[1] = 'col-lg-3 col-md-6 footer-col-1';
            $footer_class[2] = 'col-lg-3 col-md-6 footer-col-2';
            $footer_class[3] = 'col-lg-3 col-md-6 footer-col-3';
            $footer_class[4] = 'col-lg-3 col-md-6 footer-col-4';
            break;
        default:
            $footer_class = 'col-xl-4 col-lg-4 col-md-6';
            break;
    }

?>

    <!-- Footer  style 1 -->
    <footer class="footer footer-style-1 grey-bg">
        <?php if (is_active_sidebar('footer-1') or is_active_sidebar('footer-2') or is_active_sidebar('footer-3') or is_active_sidebar('footer-4')): ?>
            <div class="footer__top pt-80 pb-30">
                <div class="container">
                    <div class="row">
                        <?php
                        if ($footer_columns < 4) {
                            print '<div class="col-lg-3 col-md-6">';
                            dynamic_sidebar('footer-1');
                            print '</div>';

                            print '<div class="col-lg-3 col-md-6">';
                            dynamic_sidebar('footer-2');
                            print '</div>';

                            print '<div class="col-lg-3 col-md-6">';
                            dynamic_sidebar('footer-3');
                            print '</div>';

                            print '<div class="col-lg-3 col-md-6">';
                            dynamic_sidebar('footer-4');
                            print '</div>';
                        } else {
                            for ($num = 1; $num <= $footer_columns; $num++) {
                                if (!is_active_sidebar('footer-' . $num)) continue;
                                print '<div class="' . esc_attr($footer_class[$num]) . '">';
                                dynamic_sidebar('footer-' . $num);
                                print '</div>';
                            }
                        }

                        ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>
        <div class="footer__bottom">
            <div class="container">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="footer__copyright text-center">
                            <p class="m-0"><?php print neeha_copyright_text(); ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>
    <!-- Footer end -->
<?php
}

/**
 * footer  style 2
 */
function neeha_footer_style_2()
{

    $footer_logo = get_theme_mod('footer_logo');
    $neeha_copyright_center = $footer_logo ? 'col-lg-4 offset-lg-4 col-md-6 text-right' : 'col-lg-12 text-center';

    $footer_columns = 0;
    $footer_widgets = get_theme_mod('footer_widget_number', 4);

    for ($num = 1; $num <= $footer_widgets; $num++) {
        if (is_active_sidebar('footer-2-' . $num)) {
            $footer_columns++;
        }
    }

    switch ($footer_columns) {
        case '1':
            $footer_class[1] = 'col-lg-12';
            break;
        case '2':
            $footer_class[1] = 'col-lg-6 col-md-6';
            $footer_class[2] = 'col-lg-6 col-md-6';
            break;
        case '3':
            $footer_class[1] = 'col-xl-4 col-lg-6 col-md-5';
            $footer_class[2] = 'col-xl-4 col-lg-6 col-md-7';
            $footer_class[3] = 'col-xl-4 col-lg-6';
            break;
        case '4':
            $footer_class[1] = 'col-md-6 col-lg-3';
            $footer_class[2] = 'col-md-6 col-lg-3';
            $footer_class[3] = 'col-md-6 col-lg-3';
            $footer_class[4] = 'col-md-6 col-lg-3';
            break;
        default:
            $footer_class = 'col-xl-4 col-lg-4 col-md-6';
            break;
    }

?>

    <!-- footer style 2 -->
    <footer class="footer1 footer-style-2">
        <?php if (is_active_sidebar('footer-2-1') or is_active_sidebar('footer-2-2') or is_active_sidebar('footer-2-3') or is_active_sidebar('footer-2-4')): ?>
            <div class="footer1__padding1">
                <div class="container">
                    <div class="row footer-border">
                        <?php
                        if ($footer_columns < 4) {
                            print '<div class="col-md-6 col-lg-3">';
                            dynamic_sidebar('footer-2-1');
                            print '</div>';

                            print '<div class="col-md-6 col-lg-3">';
                            dynamic_sidebar('footer-2-2');
                            print '</div>';

                            print '<div class="col-md-6 col-lg-3">';
                            dynamic_sidebar('footer-2-3');
                            print '</div>';

                            print '<div class="col-md-6 col-lg-3">';
                            dynamic_sidebar('footer-2-4');
                            print '</div>';
                        } else {
                            for ($num = 1; $num <= $footer_columns; $num++) {
                                if (!is_active_sidebar('footer-2-' . $num)) continue;
                                print '<div class="' . esc_attr($footer_class[$num]) . '">';
                                dynamic_sidebar('footer-2-' . $num);
                                print '</div>';
                            }
                        }

                        ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>
        <div class="footer1__copyright">
            <div class="container">
                <div class="row align-items-center">
                    <?php if (!empty($footer_logo)) : ?>
                        <div class="col-lg-4 col-md-6 d-flex justify-content-center justify-content-md-start">
                            <div class="footer1__copyright--thumb">
                                <a href="<?php print esc_url(home_url('/')); ?>">
                                    <img src="<?php print esc_url($footer_logo); ?>" alt="Logo Image">
                                </a>
                            </div>
                        </div>
                    <?php endif; ?>
                    <div class="<?php print esc_attr($neeha_copyright_center); ?>">
                        <div class="footer1__copyright--text">
                            <p class="m-0"><?php print neeha_copyright_text(); ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>

<?php
}


/**
 * footer  3
 */
function neeha_footer_style_3()
{

    $footer_columns = 0;

    $footer_widgets = get_theme_mod('footer_widget_number', 3);

    for ($num = 1; $num <= $footer_widgets + 1; $num++) {
        if (is_active_sidebar('footer-3-' . $num)) {
            $footer_columns++;
        }
    }

    switch ($footer_columns) {
        case '1':
            $footer_class[1] = 'col-lg-12';
            break;
        case '2':
            $footer_class[1] = 'col-lg-6 col-md-6';
            $footer_class[2] = 'col-lg-6 col-md-6';
            break;
        case '3':
            $footer_class[1] = 'col-xl-4 col-lg-6 col-md-12';
            $footer_class[2] = 'col-xl-4 col-lg-6 col-sm-6 col-6';
            $footer_class[3] = 'col-xl-4 col-lg-6';
        case '4':
            $footer_class[1] = 'col-xl-4 col-lg-6 col-md-12';
            $footer_class[2] = 'col-xl-2 col-lg-6 col-sm-6 col-6';
            $footer_class[3] = 'col-xl-2 col-lg-6 col-sm-6 col-6';
            $footer_class[4] = 'col-xl-4 col-lg-6';
            break;
        default:
            $footer_class = 'col-xl-4 col-lg-4 col-md-6';
            break;
    }

?>

    <!-- footer area start 3 -->
    <footer class="site-footer footer-style-3 theme-bg pt-100">
        <div class="container">
            <div class="row">
                <?php

                if ($footer_columns < 4) {
                    print '<div class="col-xl-4 col-lg-6 col-md-12">';
                    dynamic_sidebar('footer-3-1');
                    print '</div>';

                    print '<div class="col-xl-2 col-lg-6 col-sm-6 col-6">';
                    dynamic_sidebar('footer-3-2');
                    print '</div>';

                    print '<div class="col-xl-2 col-lg-6 col-sm-6 col-6 mt-30">';
                    dynamic_sidebar('footer-3-3');
                    print '</div>';

                    print '<div class="col-xl-4 col-lg-6">';
                    dynamic_sidebar('footer-3-4');
                    print '</div>';
                } else {
                    for ($num = 1; $num <= $footer_columns; $num++) {
                        if (!is_active_sidebar('footer-3-' . $num)) continue;
                        print '<div class="' . esc_attr($footer_class[$num]) . '">';
                        dynamic_sidebar('footer-3-' . $num);
                        print '</div>';
                    }
                }
                ?>

            </div>
        </div>
        </div>
        <div class="container">
            <div class="row">
                <div class="col-xl-12">
                    <div class="copyright-text mt-60">
                        <div class="row">
                            <div class="col-xl-12 text-center">
                                <p><?php print neeha_copyright_text(); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>
    <!-- footer area end -->

    <?php
}

function neeha_copyright_text()
{
    print get_theme_mod('neeha_copyright', esc_html__('Copyright ©2020 Bdevs. All Rights Reserved', 'neeha'));
}

/** 
 * [neeha_breadcrumb_func description]
 * @return [type] [description]
 */
function neeha_breadcrumb_func()
{

    $breadcrumb_class = '';
    $breadcrumb_show = 1;

    if (is_front_page() && is_home()) {
        $title = esc_html__('Blog', 'neeha');
        $breadcrumb_class = 'home_front_page';
    } elseif (is_front_page()) {
        $title = esc_html__('Blog', 'neeha');
        $breadcrumb_show = 0;
    } elseif (is_home()) {
        if (get_option('page_for_posts')) {
            $title = get_the_title(get_option('page_for_posts'));
        }
    } elseif (is_single() && 'post' == get_post_type()) {
        $title = get_the_title();
    } elseif (is_single() && 'product' == get_post_type()) {
        $title = get_the_title();
    } elseif (is_single() && 'bdevs-services' == get_post_type()) {
        $title = get_the_title();
    } elseif (is_single() && 'bdevs-doctor' == get_post_type()) {
        $title = get_the_title();
    } elseif (is_single() && 'bdevs-case_study' == get_post_type()) {
        $title = get_the_title();
    } elseif (is_search()) {
        $title = esc_html__('Search Results for : ', 'neeha') . get_search_query();
    } elseif (is_404()) {
        $title = esc_html__('Page not Found', 'neeha');
    } elseif (is_archive()) {
        $title = get_the_archive_title();
    } else {
        $title = get_the_title();
    }

    $is_breadcrumb = function_exists('get_field') ? get_field('is_it_invisible_breadcrumb') : '';


    if (empty($is_breadcrumb) && $breadcrumb_show == 1) {

        $bg_img_from_page = function_exists('get_field') ? get_field('breadcrumb_background_image') : '';
        $hide_bg_img = function_exists('get_field') ? get_field('hide_breadcrumb_background_image') : '';

        // get_theme_mod
        $bg_img = get_theme_mod('breadcrumb_bg_img');
        $ptitle_tag = get_theme_mod('ptitle_tag', 'h1');
        $pheader_align = get_theme_mod('pheader_align', 'text-center');

        if ($hide_bg_img) {
            $bg_img = '';
        } else {
            $bg_img = !empty($bg_img_from_page) ? $bg_img_from_page['url'] : $bg_img;
        } ?>

        <div class="page-title-area page-title-padding pos-relative bg_img breadcrumb-spacings <?php print esc_attr($breadcrumb_class); ?>" data-overlay="theme" data-opacity="7" data-background="<?php print esc_attr($bg_img); ?>">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-xl-12">
                        <div class="page-inner <?php print esc_attr($pheader_align); ?>">
                            <<?php print esc_attr($ptitle_tag); ?> class="white-color page-title">
                                <?php echo wp_kses_post($title); ?>
                            </<?php print esc_attr($ptitle_tag); ?>>
                            <div class="breadcrumb-list">
                                <?php if (function_exists('bcn_display')) {
                                    bcn_display();
                                } ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php
    }
}
add_action('neeha_before_main_content', 'neeha_breadcrumb_func');


// gru_search_form
function neeha_search_form()
{ ?>
    <div class="search-wrap">
        <div class="search-inner">
            <i class="fas fa-times search-close" id="search-close"></i>
            <div class="search-cell">
                <form method="get" action="<?php print esc_url(home_url('/')); ?>">
                    <div class="search-field-holder">
                        <input type="search" name="s" class="main-search-input" value="<?php print esc_attr(get_search_query()) ?>" placeholder="<?php print esc_attr__('Search Your Keyword...', 'neeha'); ?>">
                    </div>
                </form>
            </div>
        </div>
    </div>


<?php
}

add_action('neeha_before_main_content', 'neeha_search_form');

/**
 *
 * pagination
 */
if (!function_exists('neeha_pagination')) {

    function _neeha_pagi_callback($pagination)
    {
        return $pagination;
    }

    //page navegation
    function neeha_pagination($prev, $next, $pages, $args)
    {
        global $wp_query, $wp_rewrite;
        $menu = '';
        $wp_query->query_vars['paged'] > 1 ? $current = $wp_query->query_vars['paged'] : $current = 1;

        if ($pages == '') {
            global $wp_query;
            $pages = $wp_query->max_num_pages;

            if (!$pages)
                $pages = 1;
        }

        $pagination = array(
            'base' => add_query_arg('paged', '%#%'),
            'format' => '',
            'total' => $pages,
            'current' => $current,
            'prev_text' => $prev,
            'next_text' => $next,
            'type' => 'array'
        );

        //rewrite permalinks
        if ($wp_rewrite->using_permalinks())
            $pagination['base'] = user_trailingslashit(trailingslashit(remove_query_arg('s', get_pagenum_link(1))) . 'page/%#%/', 'paged');

        if (!empty($wp_query->query_vars['s']))
            $pagination['add_args'] = array('s' => get_query_var('s'));

        $pagi = '';
        if (paginate_links($pagination) != '') {
            $paginations = paginate_links($pagination);
            $pagi .= '<ul>';
            foreach ($paginations as $key => $pg) {
                $pagi .= '<li>' . $pg . '</li>';
            }
            $pagi .= '</ul>';
        }

        print _neeha_pagi_callback($pagi);
    }
}


// scrollup
function neeha_scrollup_switch()
{
    $scrollup_switch = get_theme_mod('neeha_scrollup_switch', true);
    wp_enqueue_style('neeha-scrollup-switch', NEEHA_THEME_CSS_DIR . 'neeha-custom.css', array());
    if ($scrollup_switch) {
        $custom_css = '';
        $custom_css .= "#scrollUp{ display: none !important;}";

        wp_add_inline_style('neeha-scrollup-switch', $custom_css);
    }
}
add_action('wp_enqueue_scripts', 'neeha_scrollup_switch');


// theme color
function neeha_custom_color()
{
    $color_code = get_theme_mod('neeha_color_option', '#221f3c');
    wp_enqueue_style('neeha-custom', NEEHA_THEME_CSS_DIR . 'neeha-custom.css', array());
    if ($color_code != '') {
        $custom_css = '';
        $custom_css .= ".header__shape,.btn--blue,.feature__list:hover .feature__list--icon i,.slick-arrow:hover,.history__left--thumb a:hover,.blog--img a:hover i,.btn--border--round:hover,.feature__block:hover,.btn--play:hover,.pricing-tabs ul li a.nav-link.active,.price__special,.btn.btn--grey:hover,.about-service:hover .about-service--content::before,.securiy-services:hover,.work__block > .icon span,.service__block--h3:hover,.case__tabs ul li a::before,.header__top--social--ex ul li a:hover,.faq-wrapper .card-header h5 a,.careers__icon,.careers__content--apply h3 span,.careers__content--apply a:hover,.history-col--left .history-single::before, .history-col--left .history-single::after,.history-col--right .history-single::before, .history-col--right .history-single::after,.price__block--border:hover,.widget .widget-title::after,.sidebar-search-form button,#wp-calendar tbody td#today,.basic-pagination-2 ul li span:hover, .basic-pagination ul li span.current,.basic-pagination-2 ul li a:hover, .basic-pagination-2 ul li.active a,.blog-post-tag a:hover{ background: " . $color_code . "}";

        $custom_css .= ".header--menu__main nav ul li a:hover,.header--menu__main nav ul li ul.sub-menu li:hover > a,.feature__list--icon i,.link-more:hover,.review__arrow:hover,a:focus, a:hover,.footer__widget ul li a:hover,.footer__social ul li a:hover,.price__header i,.case__tabs ul li:hover a,.case__tabs ul li:hover a,.nav-tabs .nav-item.show .nav-link, .nav-tabs .nav-link.active,.careers__content a:hover,.widget li a:hover,.post-meta span i{ color: " . $color_code . "}";

        $custom_css .= ".header--menu__main nav ul li ul.sub-menu,.feature__list--icon i,.btn--border--round:hover,.review__active--h2 .slick-dots .slick-active button,.price__block:hover,.about-service:hover .about-service--content::before,.history-col--left .history-single::before, .history-col--left .history-single::after,.history-col--right .history-single::before, .history-col--right .history-single::after,.basic-pagination-2 ul li span:hover, .basic-pagination ul li span.current,.basic-pagination-2 ul li a:hover, .basic-pagination-2 ul li.active a{ border-color: " . $color_code . "}";
        wp_add_inline_style('neeha-custom', $custom_css);
    }
}
add_action('wp_enqueue_scripts', 'neeha_custom_color');

function neeha_kses_intermediate($string = '')
{
    return wp_kses($string, neeha_get_allowed_html_tags('intermediate'));
}


function neeha_get_allowed_html_tags($level = 'basic')
{
    $allowed_html = [
        'b' => [],
        'i' => [],
        'u' => [],
        'em' => [],
        'br' => [],
        'abbr' => [
            'title' => [],
        ],
        'span' => [
            'class' => [],
        ],
        'strong' => [],
        'a' => [
            'href' => [],
            'title' => [],
            'class' => [],
            'id' => []
        ]
    ];

    return $allowed_html;
}
