<?php

/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package neeha
 */

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function neeha_body_classes($classes)
{
	// Adds a class of hfeed to non-singular pages.
	if (! is_singular()) {
		$classes[] = 'hfeed';
	}
	// Adds a class of no-sidebar when there is no sidebar present.
	if (! is_active_sidebar('sidebar-1')) {
		$classes[] = 'no-sidebar';
	}
	return $classes;
}
add_filter('body_class', 'neeha_body_classes');

/**
 * Get tags.
 */
function neeha_get_tag()
{
	$html = '';
	if (has_tag()) {
		$html .= '<div class="blog-post-tag"><span>' . esc_html__('Post Tags', 'neeha') . '</span>';
		$html .= get_the_tag_list('', ' ', '');
		$html .= '</div>';
	}
	return $html;
}


/**
 * Get categories.
 */
function neeha_get_category()
{

	$categories = get_the_category(get_the_ID());
	$x = 0;
	foreach ($categories as $category) {

		if ($x == 2) {
			break;
		}
		$x++;
		print '<a class="news-tag" href="' . get_category_link($category->term_id) . '">'  . $category->cat_name . '</a>';
	}
}


/** img alt-text **/
function neeha_img_alt_text($img_er_id = null)
{
	$image_id = $img_er_id;
	$image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', false);
	$image_title = get_the_title($image_id);

	if (!empty($image_id)) {
		if ($image_alt) {
			$alt_text = get_post_meta($image_id, '_wp_attachment_image_alt', false);
		} else {
			$alt_text = get_the_title($image_id);
		}
	} else {
		$alt_text = esc_html__('Image Alt Text', 'neeha');
	}

	return $alt_text;
}

/**
 * Google Analytics
 */
if (! function_exists('neeha_hook_javascript')) {
	function neeha_hook_javascript()
	{
		if (get_theme_mod('js_code') != '') {
			echo get_theme_mod('js_code');
		}
	}
}
add_action('wp_head', 'neeha_hook_javascript');

function neeha_archive_title_modify($title)
{
	if (is_category()) {
		$title = single_cat_title('', false);
	} elseif (is_tag()) {
		$title = single_tag_title('', false);
	} elseif (is_author()) {
		$title = '<span class="vcard">' . get_the_author() . '</span>';
	} elseif (is_tax()) { //for custom post types
		$title = sprintf(__('%1$s'), single_term_title('', false));
	} elseif (is_post_type_archive()) {
		$title = post_type_archive_title('', false);
	}
	return $title;
}
add_filter('get_the_archive_title', 'neeha_archive_title_modify');
