<?php

/**
 * Theme customizer
 *
 * @package neeha
 */

// Exit if accessed directly
if (! defined('ABSPATH')) {
    exit;
}

class Neeha_Customizer
{
    /**
     * Customize settings
     *
     * @var array
     */
    protected $config = array();

    /**
     * The class constructor
     *
     * @param array $config
     */
    public function __construct($config)
    {
        $this->config = $config;
        if (! class_exists('Kirki')) {
            return;
        }
        $this->register();
    }

    /**
     * Register settings
     */
    public function register()
    {
        /**
         * Add the theme configuration
         */
        if (! empty($this->config['theme'])) {
            Kirki::add_config(
                $this->config['theme'],
                array(
                    'capability'  => 'edit_theme_options',
                    'option_type' => 'theme_mod',
                )
            );
        }

        /**
         * Add panels
         */
        if (! empty($this->config['panels'])) {
            foreach ($this->config['panels'] as $panel => $settings) {
                Kirki::add_panel($panel, $settings);
            }
        }

        /**
         * Add sections
         */
        if (! empty($this->config['sections'])) {
            foreach ($this->config['sections'] as $section => $settings) {
                Kirki::add_section($section, $settings);
            }
        }

        /**
         * Add fields
         */
        if (! empty($this->config['theme']) && ! empty($this->config['fields'])) {
            foreach ($this->config['fields'] as $name => $settings) {
                if (! isset($settings['settings'])) {
                    $settings['settings'] = $name;
                }
                Kirki::add_field($this->config['theme'], $settings);
            }
        }
    }

    /**
     * Get config ID
     *
     * @return string
     */
    public function get_theme()
    {
        return $this->config['theme'];
    }

    /**
     * Get customize setting value
     *
     * @param string $name
     *
     * @return bool|string
     */
    public function get_option($name)
    {
        $default = $this->get_option_default($name);
        return neeha_get_option($name, $default);
    }

    /**
     * Get default option values
     *
     * @param $name
     *
     * @return mixed
     */
    public function get_option_default($name)
    {
        if (! isset($this->config['fields'][$name])) {
            return false;
        }
        return isset($this->config['fields'][$name]['default']) ? $this->config['fields'][$name]['default'] : false;
    }
}

/**
 * This is a short hand function for getting setting value from customizer
 *
 * @param string $name
 *
 * @return bool|string
 */
function neeha_get_option($name)
{
    global $neeha_customize;
    $value = false;
    if (class_exists('Kirki')) {
        $value = Kirki::get_option('neeha', $name);
    } elseif (! empty($neeha_customize)) {
        $value = $neeha_customize->get_option($name);
    }
    return apply_filters('neeha_get_option', $value, $name);
}

/**
 * Get default option values
 *
 * @param $name
 *
 * @return mixed
 */
function neeha_get_option_default($name)
{
    global $neeha_customize;
    if (empty($neeha_customize)) {
        return false;
    }
    return $neeha_customize->get_option_default($name);
}

/**
 * Move some default sections to `general` panel that registered by theme
 *
 * @param object $wp_customize
 */
function neeha_customize_modify($wp_customize)
{
    $wp_customize->get_section('title_tagline')->panel     = 'general';
    $wp_customize->get_section('static_front_page')->panel = 'general';
}

add_action('customize_register', 'neeha_customize_modify');


/**
 * Get customize settings
 *
 * Priority (Order) WordPress Live Customizer default: 
 * @link https://developer.wordpress.org/themes/customize-api/customizer-objects/
 *
 * @return array
 */
function neeha_customize_settings()
{
    /**
     * Customizer configuration
     */

    $settings = array(
        'theme' => 'neeha',
    );

    $panels = array(
        'general'     => array(
            'priority' => 5,
            'title'    => esc_html__('General', 'neeha'),
        ),
        /* Neeha Customizer */
        'neeha_customizer'       => array(
            'title'       => esc_html__('Neeha Customizer', 'neeha'),
            'priority'        => 10,
        ),
    );

    $sections = array(
        'topbar_setting' => array(
            'title'       => esc_html__('Header Topbar Setting', 'neeha'),
            'description' => '',
            'priority'    => 11,
            'panel'       => 'neeha_customizer',
            'capability'  => 'edit_theme_options',
        ),
        'hsocial_setting'   => array(
            'title'       => esc_html__('Social Profiles', 'neeha'),
            'description' => '',
            'priority'    => 12,
            'panel'       => 'neeha_customizer',
            'capability'  => 'edit_theme_options',
        ),
        'header_setting'  => array(
            'title'       => esc_html__('Header Settings', 'neeha'),
            'priority'    => 13,
            'capability'  => 'edit_theme_options',
            'panel'       => 'neeha_customizer',
        ),
        'sidebar_setting'  => array(
            'title'       => esc_html__('Side Info Setting', 'neeha'),
            'priority'    => 14,
            'capability'  => 'edit_theme_options',
            'panel'       => 'neeha_customizer',
        ),
        'pheader_setting'     => array(
            'title'       => esc_attr__('Breadcrumb Settings', 'neeha'),
            'description' => '',
            'priority'    => 15,
            'capability'  => 'edit_theme_options',
            'panel'       => 'neeha_customizer',
        ),
        'blog_setting'     => array(
            'title'       => esc_attr__('Blog Settings', 'neeha'),
            'description' => '',
            'priority'    => 16,
            'capability'  => 'edit_theme_options',
            'panel'       => 'neeha_customizer',
        ),
        'footer_setting'     => array(
            'title'       => esc_attr__('Footer Settings', 'neeha'),
            'description' => '',
            'priority'    => 17,
            'capability'  => 'edit_theme_options',
            'panel'       => 'neeha_customizer',
        ),
        'typography'     => array(
            'title'       => esc_attr__('Typography Settings', 'neeha'),
            'description' => '',
            'priority'    => 18,
            'capability'  => 'edit_theme_options',
            'panel'       => 'neeha_customizer',
        ),
        'color_setting'     => array(
            'title'       => esc_attr__('Color Settings', 'neeha'),
            'description' => '',
            'priority'    => 19,
            'capability'  => 'edit_theme_options',
            'panel'       => 'neeha_customizer',
        ),
        /* 404 */
        '404_setting'       => array(
            'title'       => esc_html__('404 Page', 'neeha'),
            'description' => '',
            'priority'    => 20,
            'capability'  => 'edit_theme_options',
            'panel'       => 'neeha_customizer',
        ),
        'cpt_setting'       => array(
            'title'       => esc_html__('CPT Slug Setting', 'neeha'),
            'description' => '',
            'priority'    => 21,
            'capability'  => 'edit_theme_options',
            'panel'       => 'neeha_customizer',
        ),
        'script_code'   => array(
            'title'      => esc_html__('Google Analytics(Script Code)', 'neeha'),
            'priority'   => 22,
            'capability' => 'edit_theme_options',
            'panel'      => 'neeha_customizer',
        ),
        'header_style'   => array(
            'title'      => esc_html__('Header Style', 'neeha'),
            'priority'   => 23,
            'capability' => 'edit_theme_options',
            'panel'      => 'neeha_customizer',
        ),
        'topbar_style'   => array(
            'title'      => esc_html__('Header Topbar Style', 'neeha'),
            'priority'   => 24,
            'capability' => 'edit_theme_options',
            'panel'      => 'neeha_customizer',
        ),
        'mmenu_style'   => array(
            'title'      => esc_html__('Mobile Menu Style', 'neeha'),
            'priority'   => 25,
            'capability' => 'edit_theme_options',
            'panel'      => 'neeha_customizer',
        ),
        'footer_style'   => array(
            'title'      => esc_html__('Footer Style', 'neeha'),
            'priority'   => 26,
            'capability' => 'edit_theme_options',
            'panel'      => 'neeha_customizer',
        ),
    );

    $fields = array(
        /* Topbar setting */
        'neeha_topbar_switch' => array(
            'type'        => 'toggle',
            'label'       => esc_attr__('Topbar On/Off', 'neeha'),
            'section'     => 'topbar_setting',
            'default'     => false,
            'priority'    => 10,
        ),
        'neeha_header_lang' => array(
            'type'        => 'toggle',
            'label'       => esc_attr__('Language On/Off', 'neeha'),
            'section'     => 'topbar_setting',
            'default'     => false,
            'priority'    => 10,
        ),
        'neeha_header_right' => array(
            'type'        => 'toggle',
            'label'       => esc_attr__('Header Right On/Off', 'neeha'),
            'section'     => 'topbar_setting',
            'default'     => false,
            'priority'    => 10,
        ),
        'neeha_phone_label' => array(
            'type'        => 'text',
            'label'       => esc_attr__('Phone Label', 'neeha'),
            'section'     => 'topbar_setting',
            'default'     => esc_html__('Phone Number', 'neeha'),
            'priority'    => 10,
        ),
        'neeha_phone' => array(
            'type'            => 'text',
            'label'       => esc_attr__('Phone Number', 'neeha'),
            'section'     => 'topbar_setting',
            'default'     => esc_html__('+8 012 3456 7899', 'neeha'),
            'priority'    => 10,
        ),
        'neeha_header_phone' => array(
            'type'        => 'text',
            'label'       => esc_attr__('Phone', 'neeha'),
            'section'     => 'topbar_setting',
            'default'     => esc_html__('Help Line : +123(456)789', 'neeha'),
            'priority'    => 10,
        ),
        'neeha_header_mail' => array(
            'type'        => 'text',
            'label'       => esc_attr__('Email', 'neeha'),
            'section'     => 'topbar_setting',
            'default'     => esc_html__('support@gmail.com', 'neeha'),
            'priority'    => 10,
        ),
        'neeha_header_address' => array(
            'type'        => 'text',
            'label'       => esc_attr__('Address', 'neeha'),
            'section'     => 'topbar_setting',
            'default'     => esc_html__('257 New Road, New York', 'neeha'),
            'priority'    => 10,
        ),
        'neeha_button_text' => array(
            'type'        => 'text',
            'label'       => esc_attr__('Button Text', 'neeha'),
            'section'     => 'topbar_setting',
            'default'     => esc_html__('Contact Us', 'neeha'),
            'priority'    => 10,
        ),
        'neeha_button_link' => array(
            'type'        => 'text',
            'label'       => esc_attr__('Button URL', 'neeha'),
            'section'     => 'topbar_setting',
            'default'     => esc_html__('#', 'neeha'),
            'priority'    => 10,
        ),

        /* Social Profiles */
        'neeha_topbar_fb_url'   => array(
            'type'            => 'url',
            'label'           => esc_attr__('Facebook Url', 'neeha'),
            'section'         => 'hsocial_setting',
            'default'         => esc_html__('#', 'neeha'),
            'priority'        => 10,
        ),
        'neeha_topbar_twitter_url'   => array(
            'type'            => 'url',
            'label'           => esc_attr__('Twitter Url', 'neeha'),
            'section'         => 'hsocial_setting',
            'default'         => esc_html__('#', 'neeha'),
            'priority'        => 10,
        ),
        'neeha_topbar_instagram_url'   => array(
            'type'            => 'url',
            'label'           => esc_attr__('Instagram Url', 'neeha'),
            'section'         => 'hsocial_setting',
            'default'         => esc_html__('#', 'neeha'),
            'priority'        => 10,
        ),
        'neeha_topbar_youtube_url'   => array(
            'type'            => 'url',
            'label'           => esc_attr__('Youtube Url', 'neeha'),
            'section'         => 'hsocial_setting',
            'default'         => esc_html__('#', 'neeha'),
            'priority'        => 10,
        ),
        'neeha_topbar_linkedin_url'   => array(
            'type'            => 'url',
            'label'           => esc_attr__('Linedin Url', 'neeha'),
            'section'         => 'hsocial_setting',
            'default'         => esc_html__('#', 'neeha'),
            'priority'        => 10,
        ),

        /* Header settings */
        'choose_default_header' => array(
            'type'        => 'select',
            'label'       => esc_html__('Header Style', 'neeha'),
            'section'     => 'header_setting',
            'default'     => 'header-style-1',
            'priority'    => 10,
            'description' => esc_html__('Select header style for your website.', 'neeha'),
            'choices'     => array(
                'header-style-1' => esc_html__('Header Style 1', 'neeha'),
                'header-style-2' => esc_html__('Header Style 2', 'neeha'),
                'header-style-3' => esc_html__('Header Style 3', 'neeha'),
                'header-style-4' => esc_html__('Header Style 4', 'neeha'),
                'header-style-5' => esc_html__('Header Style 5', 'neeha'),
                'header-style-6' => esc_html__('Header Style 6', 'neeha'),
            ),
        ),
        'logo'   => array(
            'type'        => 'image',
            'label'       => esc_attr__('Logo', 'neeha'),
            'section'     => 'header_setting',
            'default'     => get_template_directory_uri() . '/assets/images/logo/logo.png',
            'priority'    => 10,
        ),
        'header_logo_size' => array(
            'type'     => 'number',
            'label'    => esc_html__('Logo Size', 'neeha'),
            'section'  => 'header_setting',
            'priority' => 10,
            'output'   => array(
                array(
                    'element'  => 'a.standard-logo img',
                    'property' => 'width',
                    'units'    => 'px'
                ),
            )
        ),

        /* Sidebar Settings */
        'side_logo'   => array(
            'type'        => 'image',
            'label'       => esc_attr__('Sidebar Logo', 'neeha'),
            'section'     => 'sidebar_setting',
            'default'     => get_template_directory_uri() . '/assets/images/logo/white-logo.png',
            'priority'    => 10,
        ),
        'neeha_side_office' => array(
            'type'        => 'textarea',
            'label'       => esc_attr__('Office Info', 'neeha'),
            'section'     => 'sidebar_setting',
            'default'     => esc_html__('', 'neeha'),
            'priority'    => 10,
        ),
        'neeha_side_phone' => array(
            'type'        => 'textarea',
            'label'       => esc_attr__('Phone Info', 'neeha'),
            'section'     => 'sidebar_setting',
            'default'     => esc_html__('', 'neeha'),
            'priority'    => 10,
        ),
        'neeha_side_email' => array(
            'type'        => 'textarea',
            'label'       => esc_attr__('Email Info', 'neeha'),
            'section'     => 'sidebar_setting',
            'default'     => esc_html__('', 'neeha'),
            'priority'    => 10,
        ),
        'neeha_side_fb_url' => array(
            'type'        => 'text',
            'label'       => esc_attr__('Facebook URL', 'neeha'),
            'section'     => 'sidebar_setting',
            'default'     => esc_html__('#', 'neeha'),
            'priority'    => 10,
        ),
        'neeha_side_twitter_url' => array(
            'type'        => 'text',
            'label'       => esc_attr__('Twitter URL', 'neeha'),
            'section'     => 'sidebar_setting',
            'default'     => esc_html__('#', 'neeha'),
            'priority'    => 10,
        ),
        'neeha_side_instagram_url' => array(
            'type'        => 'text',
            'label'       => esc_attr__('Instagram URL', 'neeha'),
            'section'     => 'sidebar_setting',
            'default'     => esc_html__('#', 'neeha'),
            'priority'    => 10,
        ),
        'neeha_side_linkedin_url' => array(
            'type'        => 'text',
            'label'       => esc_attr__('Linkedin URL', 'neeha'),
            'section'     => 'sidebar_setting',
            'default'     => esc_html__('#', 'neeha'),
            'priority'    => 10,
        ),
        'neeha_side_youtube_url' => array(
            'type'        => 'text',
            'label'       => esc_attr__('Youtube URL', 'neeha'),
            'section'     => 'sidebar_setting',
            'default'     => esc_html__('#', 'neeha'),
            'priority'    => 10,
        ),

        /* Breadcrumb Settings */
        'pheader_align'    => array(
            'type'        => 'select',
            'label'       => esc_html__('Text Align', 'neeha'),
            'section'     => 'pheader_setting',
            'default'     => 'text-center',
            'priority'    => 10,
            'choices'     => array(
                'text-center'   => esc_html__('Center', 'neeha'),
                'text-start'     => esc_html__('Left', 'neeha'),
                'text-end'    => esc_html__('Right', 'neeha'),
            ),
        ),
        'ptitle_tag'    => array(
            'type'      => 'select',
            'label'     => esc_html__('Title Tag', 'neeha'),
            'section'   => 'pheader_setting',
            'default'   => 'h1',
            'priority'        => 10,
            'choices'  => array(
                'h1'   => esc_html__('H1', 'neeha'),
                'h2'   => esc_html__('H2', 'neeha'),
                'h3'   => esc_html__('H3', 'neeha'),
                'h4'   => esc_html__('H4', 'neeha'),
                'h5'   => esc_html__('H5', 'neeha'),
                'h6'   => esc_html__('H6', 'neeha'),
            ),
        ),
        'breadcrumb_bg_img'  => array(
            'type'     => 'image',
            'label'    => esc_html__('Background Image', 'neeha'),
            'section'  => 'pheader_setting',
            'default'  => '',
            'priority'        => 10,
        ),
        'pheader_color'    => array(
            'type'     => 'color',
            'label'    => esc_html__('Background Color', 'neeha'),
            'section'  => 'pheader_setting',
            'priority' => 10,
            'output'   => array(
                array(
                    'element'  => '[data-overlay="theme"]::before',
                    'property' => 'background-color'
                ),
            ),
        ),
        'pheader_overlay' => array(
            'type'     => 'number',
            'label'    => esc_html__('Overlay Opacity', 'neeha'),
            'section'  => 'pheader_setting',
            'priority' => 10,
            'output'   => array(
                array(
                    'element'  => '[data-overlay="theme"]::before',
                    'property' => 'opacity',
                ),
            )
        ),
        'ptitle_color'    => array(
            'type'     => 'color',
            'label'    => esc_html__('Title Color', 'neeha'),
            'section'  => 'pheader_setting',
            'priority' => 10,
            'output'   => array(
                array(
                    'element'  => '.page-inner .page-title',
                    'property' => 'color'
                ),
            ),
        ),
        'bread_color'    => array(
            'type'     => 'color',
            'label'    => esc_html__('Breadcrumbs Color', 'neeha'),
            'section'  => 'pheader_setting',
            'priority' => 10,
            'output'   => array(
                array(
                    'element'  => '.breadcrumb-list span',
                    'property' => 'color'
                ),
            ),
        ),
        'pheader_height'  => array(
            'type'      => 'dimensions',
            'label'     => esc_html__('Page Header Height (Ex: 100px)', 'neeha'),
            'section'   => 'pheader_setting',
            'transport' => 'auto',
            'priority'  => 10,
            'choices'   => array(
                'desktop' => esc_attr__('Desktop', 'neeha'),
                'tablet'  => esc_attr__('Tablet', 'neeha'),
                'mobile'  => esc_attr__('Mobile', 'neeha'),
            ),
            'output'   => array(
                array(
                    'choice'      => 'mobile',
                    'element'     => '.page-title-area',
                    'property'    => 'padding-top',
                    'media_query' => '@media (max-width: 767px)',
                ),
                array(
                    'choice'      => 'mobile',
                    'element'     => '.page-title-area',
                    'property'    => 'padding-bottom',
                    'media_query' => '@media (max-width: 767px)',
                ),
                array(
                    'choice'      => 'tablet',
                    'element'     => '.page-title-area',
                    'property'    => 'padding-top',
                    'media_query' => '@media (min-width: 768px) and (max-width: 1024px)',
                ),
                array(
                    'choice'      => 'tablet',
                    'element'     => '.page-title-area',
                    'property'    => 'padding-bottom',
                    'media_query' => '@media (min-width: 768px) and (max-width: 1024px)',
                ),
                array(
                    'choice'      => 'desktop',
                    'element'     => '.page-title-area',
                    'property'    => 'padding-top',
                    'media_query' => '@media (min-width: 1024px)',
                ),
                array(
                    'choice'      => 'desktop',
                    'element'     => '.page-title-area',
                    'property'    => 'padding-bottom',
                    'media_query' => '@media (min-width: 1024px)',
                ),
            ),
            'default' => array(
                'desktop' => '',
                'tablet'  => '',
                'mobile'  => '',
            ),
        ),
        'head_size'  => array(
            'type'      => 'dimensions',
            'label'     => esc_html__('Page Title Size (Ex: 30px)', 'neeha'),
            'section'   => 'pheader_setting',
            'transport' => 'auto',
            'priority'  => 10,
            'choices'   => array(
                'desktop' => esc_attr__('Desktop', 'neeha'),
                'tablet'  => esc_attr__('Tablet', 'neeha'),
                'mobile'  => esc_attr__('Mobile', 'neeha'),
            ),
            'output'   => array(
                array(
                    'choice'      => 'mobile',
                    'element'     => '.page-inner .page-title',
                    'property'    => 'font-size',
                    'media_query' => '@media (max-width: 767px)',
                ),
                array(
                    'choice'      => 'tablet',
                    'element'     => '.page-inner .page-title',
                    'property'    => 'font-size',
                    'media_query' => '@media (min-width: 768px) and (max-width: 1024px)',
                ),
                array(
                    'choice'      => 'desktop',
                    'element'     => '.page-inner .page-title',
                    'property'    => 'font-size',
                    'media_query' => '@media (min-width: 1024px)',
                ),
            ),
            'default' => array(
                'desktop' => '',
                'tablet'  => '',
                'mobile'  => '',
            ),
        ),

        /* blog settings */
        'neeha_blog_btn_switch' => array(
            'type'        => 'toggle',
            'label'       => esc_attr__('Button On/Off', 'neeha'),
            'section'     => 'blog_setting',
            'default'     => true,
            'priority'    => 10,
        ),
        'neeha_blog_btn'  => array(
            'type'        => 'text',
            'label'       => esc_attr__('Button Text', 'neeha'),
            'section'     => 'blog_setting',
            'default'     => esc_html__('Read More', 'neeha'),
            'priority'    => 10,
        ),
        'neeha_blog_btn_rtl'  => array(
            'type'        => 'text',
            'label'       => esc_attr__('Button RTL Text', 'neeha'),
            'section'     => 'blog_setting',
            'default'     => esc_html__('Read More', 'neeha'),
            'priority'    => 10,
        ),
        /* footer settings */
        'choose_default_footer' => array(
            'type'        => 'select',
            'label'       => esc_html__('Footer Style', 'neeha'),
            'section'     => 'footer_setting',
            'default'     => 'footer-style-1',
            'priority'    => 10,
            'description' => esc_html__('Select footer style for your website.', 'neeha'),
            'choices'     => array(
                'footer-style-1' => esc_html__('Footer Style 1', 'neeha'),
                'footer-style-2' => esc_html__('Footer Style 2', 'neeha'),
                'footer-style-3' => esc_html__('Footer Style 3', 'neeha'),
            ),
        ),
        'footer_widget_number' => array(
            'type'        => 'select',
            'label'       => esc_html__('Widget Number', 'neeha'),
            'section'     => 'footer_setting',
            'default'     => '4',
            'priority'    => 10,
            'description' => esc_html__('Select footer style for your website.', 'neeha'),
            'choices'     => array(
                '4' => esc_html__('Widget Number 4', 'neeha'),
                '3' => esc_html__('Widget Number 3', 'neeha'),
                '2' => esc_html__('Widget Number 2', 'neeha'),
            ),
        ),
        'footer_logo' => array(
            'type'        => 'image',
            'label'       => esc_attr__('Footer 2 Logo', 'neeha'),
            'section'     => 'footer_setting',
            'default'     =>  '',
            'priority'    => 10,
        ),
        'neeha_copyright' => array(
            'type'        => 'textarea',
            'label'       => esc_attr__('Copy Right Text', 'neeha'),
            'section'     => 'footer_setting',
            'default'     => esc_html__('Copyright &copy;2024 BDevs. All Rights Reserved Copyright', 'neeha'),
            'priority'    => 10,
        ),
        'neeha_scrollup_switch'     => array(
            'type'        => 'toggle',
            'label'       => esc_attr__('Back To Top On/Off', 'neeha'),
            'section'     => 'footer_setting',
            'default'     => true,
            'priority'    => 10,
        ),
        'footer_style_2_switch'     => array(
            'type'        => 'toggle',
            'label'       => esc_attr__('Footer Style 2 On/Off', 'neeha'),
            'section'     => 'footer_setting',
            'default'     => false,
            'priority'    => 10,
        ),
        'footer_style_3_switch'     => array(
            'type'        => 'toggle',
            'label'       => esc_attr__('Footer Style 3 On/Off', 'neeha'),
            'section'     => 'footer_setting',
            'default'     => false,
            'priority'    => 10,
        ),

        /* typography */
        'typography_switch'     => array(
            'type'        => 'toggle',
            'label'       => esc_attr__('Typography Customize?', 'neeha'),
            'section'     => 'typography',
            'default'     => true,
            'priority'    => 10,
        ),
        'body_typo'    => array(
            'type'     => 'typography',
            'label'    => esc_html__('Body Font', 'neeha'),
            'section'  => 'typography',
            'priority' => 10,
            'default'  => array(
                'font-family'    => '',
                'variant'        => '',
                'font-size'      => '',
                'line-height'    => '',
                'letter-spacing' => '0',
                'color'          => '',
                'text-transform' => '',
            ),
            'output'      => array(
                array(
                    'element' => 'body, p, a, span, ul li, button, input, div.elementor-widget-container p, div.elementor-widget-container span, div.elementor-widget-container a, div.elementor-widget-container ul li, .main-menu nav > ul > li > a',
                ),
            ),
            'active_callback' => array(
                array(
                    'setting'  => 'typography_switch',
                    'operator' => '==',
                    'value'    => 1,
                ),
            ),
        ),
        'heading1_typo' => array(
            'type'     => 'typography',
            'label'    => esc_html__('Heading H1 Font', 'neeha'),
            'section'  => 'typography',
            'priority' => 10,
            'default'  => array(
                'font-family'    => '',
                'variant'        => '',
                'font-size'      => '',
                'line-height'    => '',
                'letter-spacing' => '0',
                'color'          => '',
                'text-transform' => '',
            ),
            'output'      => array(
                array(
                    'element' => 'div.elementor-widget-container h1, div.elementor-widget-container .h1, .elementor-widget-heading h1.elementor-heading-title',
                ),
            ),
            'active_callback' => array(
                array(
                    'setting'  => 'typography_switch',
                    'operator' => '==',
                    'value'    => 1,
                ),
            ),
        ),
        'heading2_typo' => array(
            'type'     => 'typography',
            'label'    => esc_html__('Heading H2 Font', 'neeha'),
            'section'  => 'typography',
            'priority' => 10,
            'default'  => array(
                'font-family'    => '',
                'variant'        => '',
                'font-size'      => '',
                'line-height'    => '',
                'letter-spacing' => '0',
                'color'          => '',
                'text-transform' => '',
            ),
            'output'      => array(
                array(
                    'element' => 'div.elementor-widget-container h2, div.elementor-widget-container .h2, .elementor-widget-heading h2.elementor-heading-title',
                ),
            ),
            'active_callback' => array(
                array(
                    'setting'  => 'typography_switch',
                    'operator' => '==',
                    'value'    => 1,
                ),
            ),
        ),
        'heading3_typo' => array(
            'type'     => 'typography',
            'label'    => esc_html__('Heading H3 Font', 'neeha'),
            'section'  => 'typography',
            'priority' => 10,
            'default'  => array(
                'font-family'    => '',
                'variant'        => '',
                'font-size'      => '',
                'line-height'    => '',
                'letter-spacing' => '0',
                'color'          => '',
                'text-transform' => '',
            ),
            'output'      => array(
                array(
                    'element' => 'div.elementor-widget-container h3, div.elementor-widget-container .h3, .elementor-widget-heading h3.elementor-heading-title',
                ),
            ),
            'active_callback' => array(
                array(
                    'setting'  => 'typography_switch',
                    'operator' => '==',
                    'value'    => 1,
                ),
            ),
        ),
        'heading4_typo' => array(
            'type'     => 'typography',
            'label'    => esc_html__('Heading H4 Font', 'neeha'),
            'section'  => 'typography',
            'priority' => 10,
            'default'  => array(
                'font-family'    => '',
                'variant'        => '',
                'font-size'      => '',
                'line-height'    => '',
                'letter-spacing' => '0',
                'color'          => '',
                'text-transform' => '',
            ),
            'output'      => array(
                array(
                    'element' => 'div.elementor-widget-container h4, div.elementor-widget-container .h4, .elementor-widget-heading h4.elementor-heading-title',
                ),
            ),
            'active_callback' => array(
                array(
                    'setting'  => 'typography_switch',
                    'operator' => '==',
                    'value'    => 1,
                ),
            ),
        ),
        'heading5_typo' => array(
            'type'     => 'typography',
            'label'    => esc_html__('Heading H5 Font', 'neeha'),
            'section'  => 'typography',
            'priority' => 10,
            'default'  => array(
                'font-family'    => '',
                'variant'        => '',
                'font-size'      => '',
                'line-height'    => '',
                'letter-spacing' => '0',
                'color'          => '',
                'text-transform' => '',
            ),
            'output'      => array(
                array(
                    'element' => 'div.elementor-widget-container h5, div.elementor-widget-container .h5, .elementor-widget-heading h5.elementor-heading-title',
                ),
            ),
            'active_callback' => array(
                array(
                    'setting'  => 'typography_switch',
                    'operator' => '==',
                    'value'    => 1,
                ),
            ),
        ),
        'heading6_typo' => array(
            'type'     => 'typography',
            'label'    => esc_html__('Heading H6 Font', 'neeha'),
            'section'  => 'typography',
            'priority' => 10,
            'default'  => array(
                'font-family'    => '',
                'variant'        => '',
                'font-size'      => '',
                'line-height'    => '',
                'letter-spacing' => '0',
                'color'          => '',
                'text-transform' => '',
            ),
            'output'      => array(
                array(
                    'element' => 'div.elementor-widget-container h6, div.elementor-widget-container .h6, .elementor-widget-heading h6.elementor-heading-title',
                ),
            ),
            'active_callback' => array(
                array(
                    'setting'  => 'typography_switch',
                    'operator' => '==',
                    'value'    => 1,
                ),
            ),
        ),
        /* color setting */
        'bg_body'      => array(
            'type'     => 'color',
            'label'    => esc_html__('Body Background', 'neeha'),
            'section'  => 'color_setting',
            'default'  => '',
            'priority' => 10,
            'output'   => array(
                array(
                    'element'  => 'body, .site-content',
                    'property' => 'background-color',
                ),
            ),
        ),
        'neeha_color_option'   => array(
            'type'     => 'color',
            'label'    => esc_html__('Primary Color', 'neeha'),
            'section'  => 'color_setting',
            'default'  => '',
            'priority' => 10,
        ),
        'mtitle_color_option'   => array(
            'type'     => 'color',
            'label'    => esc_html__('Title Color', 'neeha'),
            'section'  => 'color_setting',
            'default'  => '',
            'priority' => 10,
            'output'   => array(
                array(
                    'element'  => '.elementor-widget-container h1, .elementor-widget-container h2, .elementor-widget-container h3, .elementor-widget-container h4, .elementor-widget-container h5, .elementor-widget-container h6',
                    'property' => 'color',
                ),
            ),
        ),
        'mbody_color_option'   => array(
            'type'     => 'color',
            'label'    => esc_html__('Text Color', 'neeha'),
            'section'  => 'color_setting',
            'default'  => '',
            'priority' => 10,
            'output'   => array(
                array(
                    'element'  => '.elementor-widget-container p, .elementor-widget-container span, p',
                    'property' => 'color',
                ),
            ),
        ),

        /* 404 */
        'neeha_error_404_text' => array(
            'type'        => 'text',
            'label'       => esc_attr__('404 Text', 'neeha'),
            'section'     => '404_setting',
            'default'     => esc_html__('404', 'neeha'),
            'priority'    => 10,
        ),
        'neeha_error_title' => array(
            'type'        => 'text',
            'label'       => esc_attr__('Title Text', 'neeha'),
            'section'     => '404_setting',
            'default'     => esc_html__('Page not found', 'neeha'),
            'priority'    => 10,
        ),
        'neeha_error_desc' => array(
            'type'        => 'text',
            'label'       => esc_attr__('Description Text', 'neeha'),
            'section'     => '404_setting',
            'default'     => esc_html__('Oops! The page you are looking for does not exist. It might have been moved or deleted', 'neeha'),
            'priority'    => 10,
        ),
        'neeha_error_link_text' => array(
            'type'        => 'text',
            'label'       => esc_attr__('Link Text', 'neeha'),
            'section'     => '404_setting',
            'default'     => esc_html__('Back To Home', 'neeha'),
            'priority'    => 10,
        ),

        /* CPT Slug Settings */
        'custom_ser_slug' => array(
            'type'        => 'text',
            'label'       => esc_attr__('Service Slug', 'neeha'),
            'section'     => 'cpt_setting',
            'default'     => esc_html__('service', 'neeha'),
            'priority'    => 10,
        ),
        'custom_case_slug' => array(
            'type'        => 'text',
            'label'       => esc_attr__('Portfolio Slug', 'neeha'),
            'section'     => 'cpt_setting',
            'default'     => esc_html__('portfolio', 'neeha'),
            'priority'    => 10,
        ),

        /*google atlantic*/
        'js_code'  => array(
            'type'        => 'code',
            'label'       => esc_html__('Code', 'neeha'),
            'section'     => 'script_code',
            'choices'     => [
                'language' => 'js',
            ],
            'priority'        => 10,
        ),

        /* Header Style */
        'separator_1'  => array(
            'type'        => 'custom',
            'label'       => esc_html__('Menu Style', 'neeha'),
            'section'     => 'header_style',
            'default'     => '<hr>',
            'priority'    => 10,
        ),
        'menu_color'    => array(
            'type'     => 'color',
            'label'    => esc_html__('Color', 'neeha'),
            'section'  => 'header_style',
            'priority' => 10,
            'output'   => array(
                array(
                    'element'  => '.header--menu__main nav ul li a, .header--menu--h3 nav > ul > li > a, .header--menu__main--h4 nav > ul > li > a, .header--menu--h5 nav ul li a',
                    'property' => 'color'
                ),
            )
        ),
        'menu_hcolor'    => array(
            'type'     => 'color',
            'label'    => esc_html__('Hover Color', 'neeha'),
            'section'  => 'header_style',
            'priority' => 10,
            'output'   => array(
                array(
                    'element'  => '.header--menu__main nav ul li a:hover, .header--menu--h3 nav > ul > li > a:hover, .header--menu__main--h4 nav > ul > li > a:hover, .header--menu--h5 nav ul li a:hover',
                    'property' => 'color'
                ),
            )
        ),
        'menu_padding'    => array(
            'type'     => 'dimensions',
            'label'    => esc_html__('Padding (ex:10px)', 'neeha'),
            'section'  => 'header_style',
            'priority' => 10,
            'default'  => array(
                'padding-top'   => '',
                'padding-bottom'  => '',
            ),
            'choices' => array(
                'labels' => array(
                    'padding-top' => esc_html__('Padding Top', 'neeha'),
                    'padding-bottom' => esc_html__('Padding Bottom', 'neeha'),
                )
            ),
            'output'   => array(
                array(
                    'element'  => '.header--menu__main nav ul li a, .header--menu__main--h4 nav > ul > li > a',
                ),
            )
        ),
        'menu_margin'    => array(
            'type'     => 'dimensions',
            'label'    => esc_html__('Margin (ex:10px)', 'neeha'),
            'section'  => 'header_style',
            'priority' => 10,
            'default'  => array(
                'margin-left'   => '',
                'margin-right'  => '',
            ),
            'choices' => array(
                'labels' => array(
                    'margin-left' => esc_html__('Margin Left', 'neeha'),
                    'margin-right' => esc_html__('Margin Right', 'neeha'),
                )
            ),
            'output'   => array(
                array(
                    'element'  => '.header--menu__main nav ul li',
                ),
            )
        ),
        'separator_2'  => array(
            'type'        => 'custom',
            'label'       => esc_html__('Sub Menu Style', 'neeha'),
            'section'     => 'header_style',
            'default'     => '<hr>',
            'priority'    => 10,
        ),
        'smenu_color'    => array(
            'type'     => 'color',
            'label'    => esc_html__('Color', 'neeha'),
            'section'  => 'header_style',
            'priority' => 10,
            'output'   => array(
                array(
                    'element'  => '.header--menu__main nav ul li ul.sub-menu li a',
                    'property' => 'color'
                ),
            )
        ),
        'smenu_hcolor'    => array(
            'type'     => 'color',
            'label'    => esc_html__('Hover Color', 'neeha'),
            'section'  => 'header_style',
            'priority' => 10,
            'output'   => array(
                array(
                    'element'  => '.header--menu__main nav ul li ul.sub-menu li:hover > a',
                    'property' => 'color'
                ),
            )
        ),
        'smenu_hbgcolor'    => array(
            'type'     => 'color',
            'label'    => esc_html__('Background Color', 'neeha'),
            'section'  => 'header_style',
            'priority' => 10,
            'output'   => array(
                array(
                    'element'  => '.header--menu__main nav ul li ul.sub-menu',
                    'property' => 'background'
                ),
            )
        ),
        'smenu_bor_color'    => array(
            'type'     => 'color',
            'label'    => esc_html__('Border Color', 'neeha'),
            'section'  => 'header_style',
            'priority' => 10,
            'output'   => array(
                array(
                    'element'  => '.header--menu__main nav ul li ul.sub-menu',
                    'property' => 'border-color'
                ),
            )
        ),
        'separator_3'  => array(
            'type'        => 'custom',
            'label'       => esc_html__('Header Panel', 'neeha'),
            'section'     => 'header_style',
            'default'     => '<hr>',
            'priority'    => 10,
        ),

        'header_bgcolor'    => array(
            'type'     => 'color',
            'label'    => esc_html__('Background Color', 'neeha'),
            'section'  => 'header_style',
            'priority' => 10,
            'output'   => array(
                array(
                    'element'  => 'div.header',
                    'property' => 'background'
                ),
            )
        ),

        /* Header Topbar Style */
        'topbar_bgcolor'    => array(
            'type'     => 'color',
            'label'    => esc_html__('Topbar Background Color', 'neeha'),
            'section'  => 'topbar_style',
            'priority' => 10,
            'output'   => array(
                array(
                    'element'  => '.header-style-5 .header__top.theme-bg, .header-style-6 .header__top--h5, .header__shape, .header__top.grey-bg',
                    'property' => 'background'
                ),
            )
        ),
        'ticon_color'    => array(
            'type'     => 'color',
            'label'    => esc_html__('Icon Color', 'neeha'),
            'section'  => 'topbar_style',
            'priority' => 10,
            'output'   => array(
                array(
                    'element'  => '.header__meta ul li i, .header__meta--h5 ul li i, .header__meta--ex ul li i, .header__top--lang--ex ul li a i, .header__top--lang ul li a i',
                    'property' => 'color'
                ),
            )
        ),
        'ticon_tcolor'    => array(
            'type'     => 'color',
            'label'    => esc_html__('Text Color', 'neeha'),
            'section'  => 'topbar_style',
            'priority' => 10,
            'output'   => array(
                array(
                    'element'  => '.header__meta ul li span, .header__top--lang ul li a, .header__meta--h5 ul li span, .header__meta--ex ul li span, .header__top--lang--ex ul li a',
                    'property' => 'color'
                ),
            )
        ),
        'separator_5'  => array(
            'type'        => 'custom',
            'label'       => esc_html__('Social Icon', 'neeha'),
            'section'     => 'topbar_style',
            'default'     => '<hr>',
            'priority'    => 10,
        ),
        'social_color'    => array(
            'type'     => 'color',
            'label'    => esc_html__('Color', 'neeha'),
            'section'  => 'topbar_style',
            'priority' => 10,
            'output'   => array(
                array(
                    'element'  => '.header__top--social ul li a, .header--social ul li a, .header__top--social--ex ul li a',
                    'property' => 'color'
                ),
            )
        ),
        'social_hcolor'    => array(
            'type'     => 'color',
            'label'    => esc_html__('Hover Color', 'neeha'),
            'section'  => 'topbar_style',
            'priority' => 10,
            'output'   => array(
                array(
                    'element'  => '.header__top--social ul li a:hover, .header--social ul li a:hover, .header__top--social--ex ul li a:hover',
                    'property' => 'color'
                ),
            )
        ),
        'social_bgcolor'    => array(
            'type'     => 'color',
            'label'    => esc_html__('Background Color', 'neeha'),
            'section'  => 'topbar_style',
            'priority' => 10,
            'output'   => array(
                array(
                    'element'  => '.header__top--social ul li a, .header--social ul li a, .header__top--social--ex ul li a',
                    'property' => 'background'
                ),
            )
        ),
        'social_bghcolor'    => array(
            'type'     => 'color',
            'label'    => esc_html__('Background Hover Color', 'neeha'),
            'section'  => 'topbar_style',
            'priority' => 10,
            'output'   => array(
                array(
                    'element'  => '.header__top--social ul li a:hover, .header--social ul li a:hover, .header__top--social--ex ul li a:hover',
                    'property' => 'background'
                ),
            )
        ),
        'social_borcolor'    => array(
            'type'     => 'color',
            'label'    => esc_html__('Border Color', 'neeha'),
            'section'  => 'topbar_style',
            'priority' => 10,
            'output'   => array(
                array(
                    'element'  => '.header__top--social ul li a, .header__top--social--ex ul li a',
                    'property' => 'border-color'
                ),
            )
        ),
        'social_borhcolor'    => array(
            'type'     => 'color',
            'label'    => esc_html__('Border Hover Color', 'neeha'),
            'section'  => 'topbar_style',
            'priority' => 10,
            'output'   => array(
                array(
                    'element'  => '.header__top--social ul li a:hover, .header__top--social--ex ul li a',
                    'property' => 'border-color'
                ),
            )
        ),

        /* Mobile menu style */
        'humberger_color'    => array(
            'type'     => 'color',
            'label'    => esc_html__('Hamburger Icon Color', 'neeha'),
            'section'  => 'mmenu_style',
            'priority' => 10,
            'output'   => array(
                array(
                    'element'  => '.open-mobile-menu a',
                    'property' => 'color'
                ),
            )
        ),
        'humberger_bgcolor'    => array(
            'type'     => 'color',
            'label'    => esc_html__('Hamburger BG Color', 'neeha'),
            'section'  => 'mmenu_style',
            'priority' => 10,
            'output'   => array(
                array(
                    'element'  => '.open-mobile-menu a',
                    'property' => 'background'
                ),
            )
        ),
        'separator_60'  => array(
            'type'        => 'custom',
            'label'       => esc_html__('Menu Style', 'neeha'),
            'section'     => 'mmenu_style',
            'default'     => '<hr>',
            'priority'    => 10,
        ),
        'mmenu_color'    => array(
            'type'     => 'color',
            'label'    => esc_html__('Text Color', 'neeha'),
            'section'  => 'mmenu_style',
            'priority' => 10,
            'output'   => array(
                array(
                    'element'  => 'div.mean-container .mean-nav ul li a',
                    'property' => 'color'
                ),
            )
        ),
        'mmenu_hcolor'    => array(
            'type'     => 'color',
            'label'    => esc_html__('Text Hover Color', 'neeha'),
            'section'  => 'mmenu_style',
            'priority' => 10,
            'output'   => array(
                array(
                    'element'  => 'div.mean-container .mean-nav ul li a:hover',
                    'property' => 'color'
                ),
            )
        ),
        'mmenu_borcolor'    => array(
            'type'     => 'color',
            'label'    => esc_html__('Border Color', 'neeha'),
            'section'  => 'mmenu_style',
            'priority' => 10,
            'output'   => array(
                array(
                    'element'  => 'div.mean-container .mean-nav ul li a, div.mean-container .mean-nav ul li ul li a',
                    'property' => 'border-color'
                ),
            )
        ),
        'separator_6'  => array(
            'type'        => 'custom',
            'label'       => esc_html__('Toggle Icon', 'neeha'),
            'section'     => 'mmenu_style',
            'default'     => '<hr>',
            'priority'    => 10,
        ),
        'mmenu_pcolor'    => array(
            'type'     => 'color',
            'label'    => esc_html__('Toggle Color', 'neeha'),
            'section'  => 'mmenu_style',
            'priority' => 10,
            'output'   => array(
                array(
                    'element'  => 'div.mean-container .mean-nav ul li a.mean-expand',
                    'property' => 'color'
                ),
            )
        ),
        'mmenu_phcolor'    => array(
            'type'     => 'color',
            'label'    => esc_html__('Toggle Hover Color', 'neeha'),
            'section'  => 'mmenu_style',
            'priority' => 10,
            'output'   => array(
                array(
                    'element'  => 'div.mean-container .mean-nav ul li a.mean-expand:hover',
                    'property' => 'color'
                ),
            )
        ),
        'mmenu_pbgcolor'    => array(
            'type'     => 'color',
            'label'    => esc_html__('Toggle BG Color', 'neeha'),
            'section'  => 'mmenu_style',
            'priority' => 10,
            'output'   => array(
                array(
                    'element'  => 'div.mean-container .mean-nav ul li a.mean-expand',
                    'property' => 'background'
                ),
            )
        ),
        'mmenu_pbghcolor'    => array(
            'type'     => 'color',
            'label'    => esc_html__('Toggle BG Hover Color', 'neeha'),
            'section'  => 'mmenu_style',
            'priority' => 10,
            'output'   => array(
                array(
                    'element'  => 'div.mean-container .mean-nav ul li a.mean-expand:hover',
                    'property' => 'background'
                ),
            )
        ),
        'mmenu_width'    => array(
            'type'     => 'number',
            'label'    => esc_html__('Sidebar Width', 'neeha'),
            'section'  => 'mmenu_style',
            'priority' => 10,
            'output'   => array(
                array(
                    'element'  => '.sidebar-menu',
                    'property' => 'width',
                    'units'    => 'px'
                ),
            )
        ),
        'mmenu_sbgcolor'    => array(
            'type'     => 'color',
            'label'    => esc_html__('Sidebar BG Color', 'neeha'),
            'section'  => 'mmenu_style',
            'priority' => 10,
            'output'   => array(
                array(
                    'element'  => '.sidebar-menu',
                    'property' => 'background'
                ),
            )
        ),
        'mmenu_close_color'    => array(
            'type'     => 'color',
            'label'    => esc_html__('Sidebar Close Icon Color', 'neeha'),
            'section'  => 'mmenu_style',
            'priority' => 10,
            'output'   => array(
                array(
                    'element'  => '.close-mobile-menu a',
                    'property' => 'color'
                ),
            )
        ),

        /* footer style */
        'separator_7'  => array(
            'type'        => 'custom',
            'label'       => esc_html__('Footer One Style', 'neeha'),
            'section'     => 'footer_style',
            'default'     => '<hr>',
            'priority'    => 10,
        ),
        'footer_1_tcolor'  => array(
            'type'     => 'color',
            'label'    => esc_html__('Title Color', 'neeha'),
            'section'  => 'footer_style',
            'priority' => 10,
            'output'   => array(
                array(
                    'element'  => '.footer-style-1 .footer__title h4, .footer-style-1  .footer__widget h4, .footer-style-1 .footer__social ul li, .footer-style-1  .footer__widget h5',
                    'property' => 'color'
                ),
            )
        ),
        'footer_1_ttcolor'  => array(
            'type'     => 'color',
            'label'    => esc_html__('Text Color', 'neeha'),
            'section'  => 'footer_style',
            'priority' => 10,
            'output'   => array(
                array(
                    'element'  => '.footer-style-1 .footer__widget p, .footer-style-1 .footer--contact-text span, .footer-style-1 .footer__widget ul li a, .footer-style-1 .footer__copyright p',
                    'property' => 'color'
                ),
            )
        ),
        'footer_1_tthcolor'  => array(
            'type'     => 'color',
            'label'    => esc_html__('Link Hover Color', 'neeha'),
            'section'  => 'footer_style',
            'priority' => 10,
            'output'   => array(
                array(
                    'element'  => '.footer-style-1 .footer__widget ul li a:hover',
                    'property' => 'color'
                ),
            )
        ),
        'footer_1_bgcolor'  => array(
            'type'     => 'color',
            'label'    => esc_html__('Background Color', 'neeha'),
            'section'  => 'footer_style',
            'priority' => 10,
            'output'   => array(
                array(
                    'element'  => '.footer-style-1 .footer__top',
                    'property' => 'background'
                ),
            )
        ),
        'footer_1_padding'    => array(
            'type'     => 'dimensions',
            'label'    => esc_html__('Padding (ex:10px)', 'neeha'),
            'section'  => 'footer_style',
            'priority' => 10,
            'default'  => array(
                'padding-top'   => '',
                'padding-bottom'  => '',
            ),
            'choices' => array(
                'labels' => array(
                    'padding-top' => esc_html__('Padding Top', 'neeha'),
                    'padding-bottom' => esc_html__('Padding Bottom', 'neeha'),
                )
            ),
            'output'   => array(
                array(
                    'element'  => '.footer-style-1 .footer__top',
                ),
            )
        ),
        'footer_1_borgcolor'  => array(
            'type'     => 'color',
            'label'    => esc_html__('Bottom Border Color', 'neeha'),
            'section'  => 'footer_style',
            'priority' => 10,
            'output'   => array(
                array(
                    'element'  => '.footer-style-1 .footer__copyright p',
                    'property' => 'border-color'
                ),
            )
        ),
        'footer_1_bbgcolor'  => array(
            'type'     => 'color',
            'label'    => esc_html__('Bottom Background Color', 'neeha'),
            'section'  => 'footer_style',
            'priority' => 10,
            'output'   => array(
                array(
                    'element'  => '.footer-style-1 .footer__bottom',
                    'property' => 'background'
                ),
            )
        ),
        'separator_8'  => array(
            'type'        => 'custom',
            'label'       => esc_html__('Footer Two Style', 'neeha'),
            'section'     => 'footer_style',
            'default'     => '<hr>',
            'priority'    => 10,
        ),
        'footer_2_tcolor'  => array(
            'type'     => 'color',
            'label'    => esc_html__('Title Color', 'neeha'),
            'section'  => 'footer_style',
            'priority' => 10,
            'output'   => array(
                array(
                    'element'  => '.footer-style-2 .footer-title, .footer-style-1  .footer-widget h4, .footer-style-2 .footer__social ul li, .footer-style-2  .footer-widget h5',
                    'property' => 'color'
                ),
            )
        ),
        'footer_2_ttcolor'  => array(
            'type'     => 'color',
            'label'    => esc_html__('Text Color', 'neeha'),
            'section'  => 'footer_style',
            'priority' => 10,
            'output'   => array(
                array(
                    'element'  => '.footer-style-2 .footer-widget p, .footer-style-2 .footer--contact-text span, .footer-style-2 .footer-widget ul li a, .footer-style-2 .footer1__copyright--text p',
                    'property' => 'color'
                ),
            )
        ),
        'footer_2_tthcolor'  => array(
            'type'     => 'color',
            'label'    => esc_html__('Link Hover Color', 'neeha'),
            'section'  => 'footer_style',
            'priority' => 10,
            'output'   => array(
                array(
                    'element'  => '.footer-style-2 .footer-widget ul li a:hover',
                    'property' => 'color'
                ),
            )
        ),
        'footer_2_bgcolor'  => array(
            'type'     => 'color',
            'label'    => esc_html__('Background Color', 'neeha'),
            'section'  => 'footer_style',
            'priority' => 10,
            'output'   => array(
                array(
                    'element'  => '.footer-style-2 .footer1__padding1',
                    'property' => 'background'
                ),
            )
        ),
        'footer_2_bbgcolor'  => array(
            'type'     => 'color',
            'label'    => esc_html__('Bottom Background Color', 'neeha'),
            'section'  => 'footer_style',
            'priority' => 10,
            'output'   => array(
                array(
                    'element'  => '.footer-style-2 .footer1__copyright',
                    'property' => 'background'
                ),
            )
        ),
        'separator_9'  => array(
            'type'        => 'custom',
            'label'       => esc_html__('Footer Three Style', 'neeha'),
            'section'     => 'footer_style',
            'default'     => '<hr>',
            'priority'    => 10,
        ),
        'footer_3_tcolor'  => array(
            'type'     => 'color',
            'label'    => esc_html__('Title Color', 'neeha'),
            'section'  => 'footer_style',
            'priority' => 10,
            'output'   => array(
                array(
                    'element'  => '.footer-widget.three .footer__social ul li, .footer-widget.three .footer--contact-icon i, .footer-widget.three h4',
                    'property' => 'color'
                ),
            )
        ),
        'footer_3_ttcolor'  => array(
            'type'     => 'color',
            'label'    => esc_html__('Text Color', 'neeha'),
            'section'  => 'footer_style',
            'priority' => 10,
            'output'   => array(
                array(
                    'element'  => '.footer-style-3 .footer-widget p, .footer-style-3 .footer-widget ul li a, .footer-style-3 .copyright-text p, .footer-widget.three .footer--contact-text h5, .footer-widget.three .footer--contact-text span',
                    'property' => 'color'
                ),
            )
        ),
        'footer_3_tthcolor'  => array(
            'type'     => 'color',
            'label'    => esc_html__('Link Hover Color', 'neeha'),
            'section'  => 'footer_style',
            'priority' => 10,
            'output'   => array(
                array(
                    'element'  => '.footer-style-3 .footer-widget ul li a:hover',
                    'property' => 'color'
                ),
            )
        ),
        'footer_3_bgcolor'  => array(
            'type'     => 'color',
            'label'    => esc_html__('Background Color', 'neeha'),
            'section'  => 'footer_style',
            'priority' => 10,
            'output'   => array(
                array(
                    'element'  => 'footer.site-footer.footer-style-3.theme-bg',
                    'property' => 'background'
                ),
            )
        ),
    );

    $settings['panels']   = apply_filters('neeha_customize_panels', $panels);
    $settings['sections'] = apply_filters('neeha_customize_sections', $sections);
    $settings['fields']   = apply_filters('neeha_customize_fields', $fields);

    return $settings;
}

$neeha_customize = new Neeha_Customizer(neeha_customize_settings());
