<?php

/**
 * neeha functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package neeha
 */

if (!function_exists('neeha_setup')):
    /**
     * Sets up theme defaults and registers support for various WordPress features.
     *
     * Note that this function is hooked into the after_setup_theme hook, which
     * runs before the init hook. The init hook is too late for some features, such
     * as indicating support for post thumbnails.
     */
    function neeha_setup()
    {
        /*
         * Make theme available for translation.
         * Translations can be filed in the /languages/ directory.
         * If you're building a theme based on neeha, use a find and replace
         * to change 'neeha' to the name of your theme in all the template files.
         */
        load_theme_textdomain('neeha', get_template_directory() . '/languages');

        // Add default posts and comments RSS feed links to head.
        add_theme_support('automatic-feed-links');

        /*
         * Let WordPress manage the document title.
         * By adding theme support, we declare that this theme does not use a
         * hard-coded <title> tag in the document head, and expect WordPress to
         * provide it for us.
         */
        add_theme_support('title-tag');

        /*
         * Enable support for Post Thumbnails on posts and pages.
         *
         * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
         */
        add_theme_support('post-thumbnails');

        // This theme uses wp_nav_menu() in one location.
        register_nav_menus([
            'main-menu'   => esc_html__('Main Menu', 'neeha'),
            'footer-menu' => esc_html__('Footer Menu', 'neeha'),
        ]);

        /*
         * Switch default core markup for search form, comment form, and comments
         * to output valid HTML5.
         */
        add_theme_support('html5', [
            'search-form',
            'comment-form',
            'comment-list',
            'gallery',
            'caption',
        ]);

        // Set up the WordPress core custom background feature.
        add_theme_support('custom-background', apply_filters('neeha_custom_background_args', [
            'default-color' => 'ffffff',
            'default-image' => '',
        ]));

        // Add theme support for selective refresh for widgets.
        add_theme_support('customize-selective-refresh-widgets');

        //Enable custom header
        add_theme_support('custom-header');

        /**
         * Add support for core custom logo.
         *
         * @link https://codex.wordpress.org/Theme_Logo
         */
        add_theme_support('custom-logo', [
            'height'      => 250,
            'width'       => 250,
            'flex-width'  => true,
            'flex-height' => true,
        ]);

        /**
         * Enable suporrt for Post Formats
         *
         * see: https://codex.wordpress.org/Post_Formats
         */
        add_theme_support('post-formats', [
            'image',
            'audio',
            'video',
            'gallery',
            'quote',
        ]);

        // Add theme support for selective refresh for widgets.

        //add_theme_support( 'customize-selective-refresh-widgets' );

        // Add support for Block Styles.
        add_theme_support('wp-block-styles');

        // Add support for full and wide align images.
        add_theme_support('align-wide');

        // Add support for editor styles.
        add_theme_support('editor-styles');

        // Add support for responsive embedded content.
        add_theme_support('responsive-embeds');

        remove_theme_support('widgets-block-editor');

        add_image_size('neeha-case-details', 1170, 600, ['center', 'center']);
        add_image_size('neeha-post-thumb', 500, 350, ['center', 'center']);
        add_image_size('neeha-case-thumb', 700, 544, ['center', 'center']);
    }

endif;
add_action('after_setup_theme', 'neeha_setup');

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function neeha_content_width()
{

    // This variable is intended to be overruled from themes.

    // Open WPCS issue: {@link https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards/issues/1043}.
    // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
    $GLOBALS['content_width'] = apply_filters('neeha_content_width', 640);
}

add_action('after_setup_theme', 'neeha_content_width', 0);

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function neeha_widgets_init()
{

    $footer_style_2_switch = get_theme_mod('footer_style_2_switch', false);
    $footer_style_3_switch = get_theme_mod('footer_style_3_switch', false);

    /**
     * blog sidebar
     */
    register_sidebar([
        'name'          => esc_html__('Blog Sidebar', 'neeha'),
        'id'            => 'blog-sidebar',
        'before_widget' => '<div id="%1$s" class="widget mb-40 %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<div class="widget-title-box"><h3 class="widget-title mb-30">',
        'after_title'   => '</h3></div>',
    ]);

    $footer_widgets = get_theme_mod('footer_widget_number', 4);

    for ($num = 1; $num <= $footer_widgets; $num++) {
        register_sidebar([
            'name'          => esc_html__('Footer ' . $num, 'neeha'),
            'id'            => 'footer-' . $num,
            'description'   => esc_html__('Footer ' . $num, 'neeha'),
            'before_widget' => '<div id="%1$s" class="footer__widget mb-50 %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<div class="footer__title"><h4>',
            'after_title'   => '</h4></div>',
        ]);
    }

    // footer 2
    if ($footer_style_2_switch) {
        for ($num = 1; $num <= $footer_widgets; $num++) {

            register_sidebar([
                'name'          => esc_html__('Footer Style 2: ' . $num, 'neeha'),
                'id'            => 'footer-2-' . $num,
                'description'   => esc_html__('Footer Style 2: ' . $num, 'neeha'),
                'before_widget' => '<div id="%1$s" class="footer-widget two mb-50 %2$s">',
                'after_widget'  => '</div>',
                'before_title'  => '<h4 class="footer-title mb-30">',
                'after_title'   => '</h4>',
            ]);
        }
    }

    // footer 3
    if ($footer_style_3_switch) {
        for ($num = 1; $num <= $footer_widgets; $num++) {
            register_sidebar([
                'name'          => esc_html__('Footer Style 3: ' . $num, 'neeha'),
                'id'            => 'footer-3-' . $num,
                'description'   => esc_html__('Footer Style 3: ' . $num, 'neeha'),
                'before_widget' => '<div id="%1$s" class="footer-widget three mb-50 %2$s">',
                'after_widget'  => '</div>',
                'before_title'  => '<h4 class="footer-title mb-30">',
                'after_title'   => '</h4>',
            ]);
        }
    }
}

add_action('widgets_init', 'neeha_widgets_init');

/**
 * Enqueue scripts and styles.
 */

define('NEEHA_THEME_DIR', get_template_directory());
define('NEEHA_THEME_URI', get_template_directory_uri());
define('NEEHA_THEME_CSS_DIR', NEEHA_THEME_URI . '/assets/css/');
define('NEEHA_THEME_JS_DIR', NEEHA_THEME_URI . '/assets/js/');
define('NEEHA_THEME_INC', NEEHA_THEME_DIR . '/inc/');

/**
 * neeha_scripts description
 * @return [type] [description]
 */
function neeha_scripts()
{
    /**
     * all css files
     */
    wp_enqueue_style('neeha-fonts', neeha_fonts_url(), [], '1.0.0');
    wp_enqueue_style('bootstrap', NEEHA_THEME_CSS_DIR . 'bootstrap.min.css', []);
    wp_enqueue_style('aos', NEEHA_THEME_CSS_DIR . 'aos.css', []);
    wp_enqueue_style('animate', NEEHA_THEME_CSS_DIR . 'animate.min.css', []);
    wp_enqueue_style('fontawesome-pro', NEEHA_THEME_CSS_DIR . 'fontawesome.pro.min.css', []);
    wp_enqueue_style('flaticon', NEEHA_THEME_CSS_DIR . 'flaticon.css', []);
    wp_enqueue_style('magnific-popup', NEEHA_THEME_CSS_DIR . 'magnific-popup.css', []);
    wp_enqueue_style('meanmenu', NEEHA_THEME_CSS_DIR . 'meanmenu.css', []);
    wp_enqueue_style('owl-carousel', NEEHA_THEME_CSS_DIR . 'owl.carousel.min.css', []);
    wp_enqueue_style('slick', NEEHA_THEME_CSS_DIR . 'slick.css', []);
    wp_enqueue_style('custom-animation', NEEHA_THEME_CSS_DIR . 'custom-animation.css', []);
    wp_enqueue_style('neeha-core', NEEHA_THEME_CSS_DIR . 'neeha-core.css', []);
    wp_enqueue_style('neeha-unit', NEEHA_THEME_CSS_DIR . 'neeha-unit.css', []);
    wp_enqueue_style('neeha-style', get_stylesheet_uri());
    wp_enqueue_style('neeha-responsive', NEEHA_THEME_CSS_DIR . 'responsive.css', []);

    if (is_rtl()) {
        wp_enqueue_style('neeha-rtl', NEEHA_THEME_CSS_DIR . 'rtl.css', []);
        wp_enqueue_style('neeha-responsive-rtl', NEEHA_THEME_CSS_DIR . 'responsive-rtl.css', []);
    }

    // all js
    wp_enqueue_script('popper', NEEHA_THEME_JS_DIR . 'popper.min.js', ['jquery'], '', true);
    wp_enqueue_script('bootstrap', NEEHA_THEME_JS_DIR . 'bootstrap.min.js', ['jquery'], '', true);
    wp_enqueue_script('isotope-pkgd', NEEHA_THEME_JS_DIR . 'isotope.pkgd.min.js', ['imagesloaded'], false, true);
    wp_enqueue_script('jquery-meanmenu', NEEHA_THEME_JS_DIR . 'jquery.meanmenu.min.js', ['jquery'], false, true);
    wp_enqueue_script('owl-carousel', NEEHA_THEME_JS_DIR . 'owl.carousel.min.js', ['jquery'], false, true);
    wp_enqueue_script('jquery-magnific-popup', NEEHA_THEME_JS_DIR . 'jquery.magnific-popup.min.js', ['jquery'], false, true);
    wp_enqueue_script('slick', NEEHA_THEME_JS_DIR . 'slick.min.js', ['jquery'], false, true);
    wp_enqueue_script('wow', NEEHA_THEME_JS_DIR . 'wow.min.js', ['jquery'], false, true);
    wp_enqueue_script('jquery-knob', NEEHA_THEME_JS_DIR . 'jquery.knob.js', ['jquery'], false, true);
    wp_enqueue_script('jquery-appear', NEEHA_THEME_JS_DIR . 'jquery.appear.js', ['jquery'], false, true);
    wp_enqueue_script('tilt-jquery', NEEHA_THEME_JS_DIR . 'tilt.jquery.js', ['jquery'], false, true);
    wp_enqueue_script('aos', NEEHA_THEME_JS_DIR . 'aos.js', ['jquery'], false, true);
    wp_enqueue_script('jquery-waypoints', NEEHA_THEME_JS_DIR . 'jquery.waypoints.min.js', ['jquery'], false, true);
    wp_enqueue_script('jquery-counterup', NEEHA_THEME_JS_DIR . 'jquery.counterup.min.js', ['jquery'], false, true);

    if (is_rtl()) {
        wp_enqueue_script('neeha-rtl-main', NEEHA_THEME_JS_DIR . 'rtl-main.js', ['jquery'], false, true);
    } else {
        wp_enqueue_script('neeha-rtl-main', NEEHA_THEME_JS_DIR . 'main.js', ['jquery'], false, true);
    }

    if (is_singular() && comments_open() && get_option('thread_comments')) {
        wp_enqueue_script('comment-reply');
    }
}

add_action('wp_enqueue_scripts', 'neeha_scripts');

/*
Register Fonts
 */
function neeha_fonts_url()
{
    $neeha_fonts_url = get_theme_mod('neeha_fonts_url', "Exo:300,400,400i,500,500i,600,700|Roboto:300,400,500,700,900");

    $font_url = '';

    /*
    Translators: If there are characters in your language that are not supported
    by chosen font(s), translate this to 'off'. Do not translate into your own language.
     */

    if ('off' !== _x('on', 'Google font: on or off', 'neeha')) {
        $font_url = add_query_arg('family', urlencode($neeha_fonts_url), "//fonts.googleapis.com/css");
    }

    return $font_url;
}

/**
 * Implement the Custom Header feature.
 */
require NEEHA_THEME_INC . 'custom-header.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require NEEHA_THEME_INC . 'template-functions.php';

/**
 * Custom template helper function for this theme.
 */
require NEEHA_THEME_INC . 'template-helper.php';

/**
 * Load Jetpack compatibility file.
 */
if (defined('JETPACK__VERSION')) {
    require NEEHA_THEME_INC . 'jetpack.php';
}

/**
 * include neeha functions file
 */
require_once NEEHA_THEME_INC . 'class-navwalker.php';
require_once NEEHA_THEME_INC . 'class-tgm-plugin-activation.php';
require_once NEEHA_THEME_INC . 'add_plugin.php';

if (class_exists('Kirki')) {
    require_once NEEHA_THEME_INC . 'kirki-customizer.php';
}

/**
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 */
function neeha_pingback_header()
{
    if (is_singular() && pings_open()) {
        printf('<link rel="pingback" href="%s">', esc_url(get_bloginfo('pingback_url')));
    }
}

add_action('wp_head', 'neeha_pingback_header');

/**
 *
 * comment section
 *
 */
add_filter('comment_form_default_fields', 'neeha_comment_form_default_fields_func');

function neeha_comment_form_default_fields_func($default)
{
    $default['author'] = '<div class="row">
    <div class="col-xl-6">
    	<div class="contacts-name">
    		<label>' . esc_html__('Your name *', 'neeha') . '</label>
        	<input type="text" name="author">
        </div>
    </div>';
    $default['email'] = '<div class="col-xl-6">
		<div class="contacts-email ">
		<label>' . esc_html__('Your email *', 'neeha') . '</label>
        <input type="text" name="email">
    	</div>
    </div>';
    $default['url'] = '';

    $default['clients_commnet'] = '<div class="col-xl-12">
	<div class="contacts-message">
	<label>' . esc_html__('Comments *', 'neeha') . '</label>
     <textarea id="comment" name="comment" cols="30" rows="10"></textarea>
    </div>';
    return $default;
}

add_filter('comment_form_defaults', 'neeha_comment_form_defaults_func');

function neeha_comment_form_defaults_func($info)
{
    if (!is_user_logged_in()) {
        $info['comment_field'] = '';
        $info['submit_field'] = '%1$s %2$s</div></div>';
    } else {
        $info['comment_field'] = '<div class="comments-textarea contacts-message contact-icon">
											<label>' . esc_html__('Comments *', 'neeha') . '</label>
                                                <textarea id="comment" name="comment" cols="30" rows="10"></textarea>';
        $info['submit_field'] = '%1$s %2$s</div>';
    }

    $info['submit_button'] = '<button class="btn btn--blue btn--icon white-color" type="submit"><i class="fal fa-comments"></i> ' . esc_html__('Post Comment', 'neeha') . ' </button>';

    $info['title_reply_before'] = '<div class="post-comments-title">
                                        <h2>';
    $info['title_reply_after'] = '</h2></div>';
    $info['comment_notes_before'] = '';

    return $info;
}

if (!function_exists('neeha_comment')) {
    function neeha_comment($comment, $args, $depth)
    {
        $GLOBAL['comment'] = $comment;
        extract($args, EXTR_SKIP);
        $args['reply_text'] = '<i class="fas fa-reply-all"></i> Reply';
        $replayClass = 'comment-depth-' . esc_attr($depth);
?>
        <li id="comment-<?php comment_ID(); ?>">
            <div class="comments-box">
                <div class="comments-avatar">
                    <?php print get_avatar($comment, 102, null, null, ['class' => []]); ?>
                </div>
                <div class="comments-text">
                    <div class="avatar-name">
                        <h5><?php print get_comment_author_link(); ?></h5>
                        <span><?php comment_time(get_option('date_format')); ?></span>
                    </div>
                    <?php comment_text(); ?>
                    <?php comment_reply_link(array_merge($args, ['depth' => $depth, 'max_depth' => $args['max_depth']])); ?>
                </div>
            </div>
    <?php
    }
}

/**
 * shortcode supports for removing extra p, spance etc
 *
 */
add_filter('the_content', 'neeha_shortcode_extra_content_remove');
/**
 * Filters the content to remove any extra paragraph or break tags
 * caused by shortcodes.
 *
 * @since 1.0.0
 *
 * @param string $content  String of HTML content.
 * @return string $content Amended string of HTML content.
 */
function neeha_shortcode_extra_content_remove($content)
{

    $array = [
        '<p>['    => '[',
        ']</p>'   => ']',
        ']<br />' => ']',
    ];
    return strtr($content, $array);
}

// neeha_search_filter_form
if (!function_exists('neeha_search_filter_form')) {
    function neeha_search_filter_form($form)
    {

        $form = sprintf(
            '<div class="sidebar-form"><form class="sidebar-search-form" action="%s" method="get">
      	<input type="text" value="%s" required name="s" placeholder="%s">
      	<button type="submit"> <i class="fas fa-search"></i>  </button>
		</form></div>',
            esc_url(home_url('/')),
            esc_attr(get_search_query()),
            esc_html__('Search', 'neeha')
        );

        return $form;
    }

    add_filter('get_search_form', 'neeha_search_filter_form');
}

add_action('admin_enqueue_scripts', 'neeha_admin_custom_scripts');

function neeha_admin_custom_scripts()
{
    wp_enqueue_media();
    wp_register_script('neeha-admin-custom', get_template_directory_uri() . '/inc/js/admin_custom.js', ['jquery'], '', true);
    wp_enqueue_script('neeha-admin-custom');
}

// enable_rtl
function neeha_enable_rtl()
{

    if (get_theme_mod('rtl_switch', false)) {
        return ' dir="rtl" ';
    } else {
        return '';
    }
}
