<?php 
/** 
 * The main template file
 *
 * @package  WordPress
 * @subpackage  medidove
 */
get_header(); ?>

	<!-- Case Details -->
    <?php 
    if( have_posts() ):
        while( have_posts() ): the_post();
            $department_details_thumb = function_exists('get_field') ? get_field('department_details_thumb') : '';
            $portfolio_bottom_left_image = function_exists('get_field') ? get_field('portfolio_bottom_left_image') : '';
            $department_info_list = function_exists('get_field') ? get_field('department_info_list') : '';
            $cta_info = function_exists('get_field') ? get_field('cta_info') : '';
            // video
            $department_video_image = function_exists('get_field') ? get_field('department_video_image') : '';
            $department_video_url = function_exists('get_field') ? get_field('department_video_url') : '';
            // department short info
            $department_bottom_text = function_exists('get_field') ? get_field('department_bottom_text') : '';  

    ?>
	<div class="case pt-125">
		<div class="container">
			<div class="row">
				<div class="col-sm-12">
					<div class="case__details--body">
						<div class="case__details--thumb mb-55">
	                        <?php if (!empty($department_details_thumb['url'])) : ?>
	                        <div class="service-details-thumb">
	                            <img src="<?php echo esc_url($department_details_thumb['url']); ?>" alt="">
	                        </div>
	                        <?php endif; ?>

							<div class="case__details--header--wrapper">
								<div class="row align-items-center no-gutters">
									<?php if (!empty($department_info_list['project_name'])) : ?>
									<div class="col-xl-3 col-lg-3 col-md-6">
										<div class="case__details--header">
											<h4><?php echo wp_kses_post( $department_info_list['project_label'] ); ?></h4>
                                        	<p><i class="far fa-boxes-alt"></i> <?php echo wp_kses_post( $department_info_list['project_name'] ); ?></p>
										</div>
									</div>
									<?php endif; ?>
									<?php if (!empty($department_info_list['clients_name'])) : ?>
									<div class="col-xl-3 col-lg-3 col-md-6">
										<div class="case__details--header">
											<h4><?php echo wp_kses_post( $department_info_list['clients_label'] ); ?></h4>
                                        	<p><i class="far fa-user"></i> <?php echo wp_kses_post( $department_info_list['clients_name'] ); ?></p>
										</div>
									</div>
									<?php endif; ?>
									<?php if (!empty($department_info_list['date_text'])) : ?>
									<div class="col-xl-3 col-lg-3 col-md-6">
										<div class="case__details--header">
											<h4><?php echo wp_kses_post( $department_info_list['date_label'] ); ?></h4>
                                        	<p><i class="far fa-calendar-alt"></i> <?php echo wp_kses_post( $department_info_list['date_text'] ); ?></p>
										</div>
									</div>
									<?php endif; ?>
									<?php if (!empty($department_info_list['country_name'])) : ?>
									<div class="col-xl-3 col-lg-3 col-md-6">
										<div class="case__details--header">
											<h4><?php echo wp_kses_post( $department_info_list['country_label'] ); ?></h4>
                                        	<p><i class="far fa-flag"></i> <?php echo wp_kses_post( $department_info_list['country_name'] ); ?></p>
										</div>
									</div>
									<?php endif; ?>
								</div>
							</div>
						</div>
						<div class="case__details--content mb-30">
							<?php the_content(); ?>	
						</div>
						<div class="case__details--list">
							<ul>
								<li>
									<div class="row">
				                        <?php if (!empty($portfolio_bottom_left_image['url'])) : ?>
										<div class="col-lg-7 mb-10">
											<div class="case__details--thumb">
												<img src="<?php echo esc_url($portfolio_bottom_left_image['url']); ?>" alt="img">
											</div>
										</div>
										<?php endif; ?>
										<?php if (!empty($department_video_image['url'])) : ?>
										<div class="col-lg-5 mb-10">
											<div class="case__details--thumb position-relative" data-overlay="theme" data-opacity="6">
												<img src="<?php echo esc_url($department_video_image['url']); ?>" alt="img">
												<a class="popup-video btn--play service__play" href="<?php echo esc_url($department_video_url); ?>" tabindex="0"><i class="fas fa-play"></i></a>
											</div>
										</div>
										<?php endif; ?>
									</div>
								</li>
								<li>
									<?php if (!empty($department_bottom_text)) : ?>
			                        <?php echo wp_kses_post($department_bottom_text); ?>
			                        <?php endif; ?>
								</li>
							</ul>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!-- Case Details End -->

	<!-- Consultation -->
	<?php if (!empty($cta_info['title'])) : ?>
	<section class="consult mb-120">
		<div class="container">
			<div class="row">
				<div class="col-sm-12">
					<div class="consult__bg pt-70 pb-80" data-background="<?php echo esc_url( $cta_info['cta_img']['url'] ); ?>"
					     data-overlay="theme" data-opacity="6">
						<div class="row">
							<div class="col-lg-8 offset-lg-2">
								<div class="theme text-center">
									<?php if (!empty($cta_info['sub_title'])) : ?>
                                     <span class="theme__small--title white-color fw-700 text-uppercase">
                                     	<span class="white-line"></span>
                                     	<?php echo wp_kses_post( $cta_info['sub_title'] ); ?>
                                     	<span class="white-line"></span>
                                     </span>
                                     <?php endif; ?>

                                     <?php if (!empty($cta_info['title'])) : ?>
									<h2 class="theme__big--title white-color fw-700 mb-40"><?php echo wp_kses_post( $cta_info['title'] ); ?></h2>
									<?php endif; ?>

									<?php if (!empty($cta_info['button_url'])) : ?>
									<a href="<?php echo wp_kses_post( $cta_info['button_url'] ); ?>" class="btn btn--icon btn--white theme-color"><?php echo wp_kses_post( $cta_info['button_text'] ); ?></a>
									<?php endif; ?>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<?php endif; ?>
	<!-- Consultation End -->

    <?php 
        endwhile; wp_reset_query();
    endif; 
    ?>


<?php get_footer();  ?>