<?php

namespace BdevsElement\Widget;

use \Elementor\Core\Schemes\Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Control_Media;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Typography;

defined('ABSPATH') || die();

class Who_We_Are extends BDevs_El_Widget
{

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Element widget name.
	 *
	 * @return string Widget name.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_name()
	{
		return 'who_we_are';
	}


	/**
	 * Get widget title.
	 *
	 * @return string Widget title.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_title()
	{
		return __('Who We Are', 'bdevselement');
	}

	public function get_custom_help_url()
	{
		return 'http://elementor.bdevs.net//widgets/info-box/';
	}

	/**
	 * Get widget icon.
	 *
	 * @return string Widget icon.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_icon()
	{
		return 'eicon-info-box';
	}

	public function get_keywords()
	{
		return ['info', 'blurb', 'box', 'text', 'content'];
	}

	/**
	 * Register content related controls
	 */
	protected function register_content_controls()
	{

		$this->start_controls_section(
			'_section_design_title',
			[
				'label' => __('Design Style', 'bdevselement'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'design_style',
			[
				'label' => __('Design Style', 'bdevselement'),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'style_1' => __('Style 1', 'bdevselement'),
				],
				'default' => 'style_1',
				'frontend_available' => true,
				'style_transfer' => true,
			]
		);

		$this->add_control(
			'sub_title',
			[
				'label' => __('Title', 'bdevselement'),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __('Type Box Sub Title', 'bdevselement'),
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->add_control(
			'title',
			[
				'label' => __('Title', 'bdevselement'),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __('Type Box Title', 'bdevselement'),
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'_section_mission',
			[
				'label' => __('Our Mission', 'bdevselement'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'm_image',
			[
				'label' => __('Image', 'bdevselement'),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->add_control(
			'm_title',
			[
				'label' => __('Title', 'bdevselement'),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => __('Statistic Info', 'bdevselement'),
				'placeholder' => __('Type Info Box Title', 'bdevselement'),
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->add_control(
			'm_description',
			[
				'label' => __('Description', 'bdevselement'),
				'description' => bdevs_element_get_allowed_html_desc('intermediate'),
				'type' => Controls_Manager::TEXTAREA,
				'default' => __('bdevs info box description goes here', 'bdevselement'),
				'placeholder' => __('Type info box description', 'bdevselement'),
				'rows' => 5,
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->add_control(
			'm_button_text',
			[
				'label' => __('Text', 'bdevselement'),
				'type' => Controls_Manager::TEXT,
				'default' => __('Button Text', 'bdevselement'),
				'placeholder' => __('Type button text here', 'bdevselement'),
				'label_block' => true,
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->add_control(
			'm_button_link',
			[
				'label' => __('Link', 'bdevselement'),
				'type' => Controls_Manager::URL,
				'placeholder' => __('http://elementor.bdevs.net/', 'bdevselement'),
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'_section_vision',
			[
				'label' => __('Our Vision', 'bdevselement'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'v_title',
			[
				'label' => __('Title', 'bdevselement'),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => __('Statistic Info', 'bdevselement'),
				'placeholder' => __('Type Info Box Title', 'bdevselement'),
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->add_control(
			'v_description',
			[
				'label' => __('Description', 'bdevselement'),
				'description' => bdevs_element_get_allowed_html_desc('intermediate'),
				'type' => Controls_Manager::TEXTAREA,
				'default' => __('bdevs info box description goes here', 'bdevselement'),
				'placeholder' => __('Type info box description', 'bdevselement'),
				'rows' => 5,
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->add_control(
			'v_button_text',
			[
				'label' => __('Text', 'bdevselement'),
				'type' => Controls_Manager::TEXT,
				'default' => __('Button Text', 'bdevselement'),
				'placeholder' => __('Type button text here', 'bdevselement'),
				'label_block' => true,
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->add_control(
			'v_button_link',
			[
				'label' => __('Link', 'bdevselement'),
				'type' => Controls_Manager::URL,
				'placeholder' => __('http://elementor.bdevs.net/', 'bdevselement'),
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'_section_business',
			[
				'label' => __('Our Business', 'bdevselement'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'b_image',
			[
				'label' => __('Image', 'bdevselement'),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->add_control(
			'b_title',
			[
				'label' => __('Title', 'bdevselement'),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => __('Statistic Info', 'bdevselement'),
				'placeholder' => __('Type Info Box Title', 'bdevselement'),
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->add_control(
			'b_description',
			[
				'label' => __('Description', 'bdevselement'),
				'description' => bdevs_element_get_allowed_html_desc('intermediate'),
				'type' => Controls_Manager::TEXTAREA,
				'default' => __('bdevs info box description goes here', 'bdevselement'),
				'placeholder' => __('Type info box description', 'bdevselement'),
				'rows' => 5,
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->add_control(
			'b_button_text',
			[
				'label' => __('Text', 'bdevselement'),
				'type' => Controls_Manager::TEXT,
				'default' => __('Button Text', 'bdevselement'),
				'placeholder' => __('Type button text here', 'bdevselement'),
				'label_block' => true,
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->add_control(
			'b_button_link',
			[
				'label' => __('Link', 'bdevselement'),
				'type' => Controls_Manager::URL,
				'placeholder' => __('http://elementor.bdevs.net/', 'bdevselement'),
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'_section_video',
			[
				'label' => __('Our Video', 'bdevselement'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'v_image',
			[
				'label' => __('Image', 'bdevselement'),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->add_control(
			'v_link',
			[
				'label' => __('Link', 'bdevselement'),
				'type' => Controls_Manager::URL,
				'placeholder' => __('http://elementor.bdevs.net/', 'bdevselement'),
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->end_controls_section();
	}

	/**
	 * Register styles related controls
	 */
	protected function register_style_controls()
	{
		$this->start_controls_section(
			'_section_media_style',
			[
				'label' => __('Icon / Image', 'bdevselement'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'icon_size',
			[
				'label' => __('Size', 'bdevselement'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range' => [
					'px' => [
						'min' => 10,
						'max' => 300,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .bdevs-infobox-figure--icon' => 'font-size: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'type' => 'icon'
				]
			]
		);

		$this->add_responsive_control(
			'image_width',
			[
				'label' => __('Width', 'bdevselement'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px', '%'],
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 400,
					],
					'%' => [
						'min' => 1,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .bdevs-infobox-figure--image' => 'width: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'type' => 'image'
				]
			]
		);

		$this->add_responsive_control(
			'image_height',
			[
				'label' => __('Height', 'bdevselement'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 400,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .bdevs-infobox-figure--image' => 'height: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'type' => 'image'
				]
			]
		);

		$this->add_control(
			'offset_toggle',
			[
				'label' => __('Offset', 'bdevselement'),
				'type' => Controls_Manager::POPOVER_TOGGLE,
				'label_off' => __('None', 'bdevselement'),
				'label_on' => __('Custom', 'bdevselement'),
				'return_value' => 'yes',
			]
		);

		$this->start_popover();

		$this->add_responsive_control(
			'media_offset_x',
			[
				'label' => __('Offset Left', 'bdevselement'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'condition' => [
					'offset_toggle' => 'yes'
				],
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
					],
				],
				'render_type' => 'ui',
			]
		);

		$this->add_responsive_control(
			'media_offset_y',
			[
				'label' => __('Offset Top', 'bdevselement'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'condition' => [
					'offset_toggle' => 'yes'
				],
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
					],
				],
				'selectors' => [
					// Media translate styles
					'(desktop){{WRAPPER}} .bdevs-infobox-figure' => '-ms-transform: translate({{media_offset_x.SIZE || 0}}{{UNIT}}, {{media_offset_y.SIZE || 0}}{{UNIT}}); -webkit-transform: translate({{media_offset_x.SIZE || 0}}{{UNIT}}, {{media_offset_y.SIZE || 0}}{{UNIT}}); transform: translate({{media_offset_x.SIZE || 0}}{{UNIT}}, {{media_offset_y.SIZE || 0}}{{UNIT}});',
					'(tablet){{WRAPPER}} .bdevs-infobox-figure' => '-ms-transform: translate({{media_offset_x_tablet.SIZE || 0}}{{UNIT}}, {{media_offset_y_tablet.SIZE || 0}}{{UNIT}}); -webkit-transform: translate({{media_offset_x_tablet.SIZE || 0}}{{UNIT}}, {{media_offset_y_tablet.SIZE || 0}}{{UNIT}}); transform: translate({{media_offset_x_tablet.SIZE || 0}}{{UNIT}}, {{media_offset_y_tablet.SIZE || 0}}{{UNIT}});',
					'(mobile){{WRAPPER}} .bdevs-infobox-figure' => '-ms-transform: translate({{media_offset_x_mobile.SIZE || 0}}{{UNIT}}, {{media_offset_y_mobile.SIZE || 0}}{{UNIT}}); -webkit-transform: translate({{media_offset_x_mobile.SIZE || 0}}{{UNIT}}, {{media_offset_y_mobile.SIZE || 0}}{{UNIT}}); transform: translate({{media_offset_x_mobile.SIZE || 0}}{{UNIT}}, {{media_offset_y_mobile.SIZE || 0}}{{UNIT}});',
					// Body text styles
					'{{WRAPPER}} .bdevs-infobox-body' => 'margin-top: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_popover();

		$this->add_responsive_control(
			'media_spacing',
			[
				'label' => __('Bottom Spacing', 'bdevselement'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'selectors' => [
					'{{WRAPPER}} .bdevs-infobox-figure' => 'margin-bottom: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);

		$this->add_responsive_control(
			'media_padding',
			[
				'label' => __('Padding', 'bdevselement'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'selectors' => [
					'{{WRAPPER}} .bdevs-infobox-figure--image img, {{WRAPPER}} .bdevs-infobox-figure--icon' => 'padding: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'media_border',
				'selector' => '{{WRAPPER}} .bdevs-infobox-figure--image img, {{WRAPPER}} .bdevs-infobox-figure--icon',
			]
		);

		$this->add_responsive_control(
			'media_border_radius',
			[
				'label' => __('Border Radius', 'bdevselement'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .bdevs-infobox-figure--image img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .bdevs-infobox-figure--icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'media_box_shadow',
				'exclude' => [
					'box_shadow_position',
				],
				'selector' => '{{WRAPPER}} .bdevs-infobox-figure--image img, {{WRAPPER}} .bdevs-infobox-figure--icon'
			]
		);

		$this->add_control(
			'icon_color',
			[
				'label' => __('Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bdevs-infobox-figure--icon' => 'color: {{VALUE}}',
				],
				'condition' => [
					'type' => 'icon'
				]
			]
		);

		$this->add_control(
			'icon_bg_color',
			[
				'label' => __('Background Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bdevs-infobox-figure--icon' => 'background-color: {{VALUE}};',
				],
				'condition' => [
					'type' => 'icon'
				]
			]
		);

		$this->add_control(
			'icon_bg_rotate',
			[
				'label' => __('Background Rotate', 'bdevselement'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['deg'],
				'default' => [
					'unit' => 'deg',
				],
				'range' => [
					'deg' => [
						'min' => 0,
						'max' => 360,
					],
				],
				'selectors' => [
					// Icon rotate styles
					'{{WRAPPER}} .bdevs-infobox-figure--icon > i' => '-ms-transform: rotate(-{{SIZE}}{{UNIT}}); -webkit-transform: rotate(-{{SIZE}}{{UNIT}}); transform: rotate(-{{SIZE}}{{UNIT}});',
					// Icon box transform styles
					'(desktop){{WRAPPER}} .bdevs-infobox-figure--icon' => '-ms-transform: translate({{media_offset_x.SIZE || 0}}px, {{media_offset_y.SIZE || 0}}px) rotate({{SIZE}}deg); -webkit-transform: translate({{media_offset_x.SIZE || 0}}px, {{media_offset_y.SIZE || 0}}px) rotate({{SIZE}}deg); transform: translate({{media_offset_x.SIZE || 0}}px, {{media_offset_y.SIZE || 0}}px) rotate({{SIZE}}deg);',
					'(tablet){{WRAPPER}} .bdevs-infobox-figure--icon' => '-ms-transform: translate({{media_offset_x_tablet.SIZE || 0}}px, {{media_offset_y_tablet.SIZE || 0}}px) rotate({{SIZE}}deg); -webkit-transform: translate({{media_offset_x_tablet.SIZE || 0}}px, {{media_offset_y_tablet.SIZE || 0}}px) rotate({{SIZE}}deg); transform: translate({{media_offset_x_tablet.SIZE || 0}}px, {{media_offset_y_tablet.SIZE || 0}}px) rotate({{SIZE}}deg);',
					'(mobile){{WRAPPER}} .bdevs-infobox-figure--icon' => '-ms-transform: translate({{media_offset_x_mobile.SIZE || 0}}px, {{media_offset_y_mobile.SIZE || 0}}px) rotate({{SIZE}}deg); -webkit-transform: translate({{media_offset_x_mobile.SIZE || 0}}px, {{media_offset_y_mobile.SIZE || 0}}px) rotate({{SIZE}}deg); transform: translate({{media_offset_x_mobile.SIZE || 0}}px, {{media_offset_y_mobile.SIZE || 0}}px) rotate({{SIZE}}deg);',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'_section_title_style',
			[
				'label' => __('Title & Description', 'bdevselement'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'content_padding',
			[
				'label' => __('Content Box Padding', 'bdevselement'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .bdevs-infobox-body' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'title_heading',
			[
				'type' => Controls_Manager::HEADING,
				'label' => __('Title', 'bdevselement'),
				'separator' => 'before'
			]
		);

		$this->add_responsive_control(
			'title_spacing',
			[
				'label' => __('Bottom Spacing', 'bdevselement'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'selectors' => [
					'{{WRAPPER}} .bdevs-infobox-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' => __('Text Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bdevs-infobox-title' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __('Typography', 'bdevselement'),
				'selector' => '{{WRAPPER}} .bdevs-infobox-title',
				//'scheme' => Typography::TYPOGRAPHY_2
			]
		);

		$this->add_control(
			'description_heading',
			[
				'type' => Controls_Manager::HEADING,
				'label' => __('Description', 'bdevselement'),
				'separator' => 'before'
			]
		);

		$this->add_responsive_control(
			'description_spacing',
			[
				'label' => __('Bottom Spacing', 'bdevselement'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'selectors' => [
					'{{WRAPPER}} .bdevs-infobox-text' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'description_color',
			[
				'label' => __('Text Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bdevs-infobox-text' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'description_typography',
				'label' => __('Typography', 'bdevselement'),
				'selector' => '{{WRAPPER}} .bdevs-infobox-text',
				//'scheme' => Typography::TYPOGRAPHY_3,
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'_section_style_button',
			[
				'label' => __('Button', 'bdevselement'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'link_padding',
			[
				'label' => __('Padding', 'bdevselement'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'btn_typography',
				'selector' => '{{WRAPPER}} .btn',
				//'scheme' => Typography::TYPOGRAPHY_4,
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'button_border',
				'selector' => '{{WRAPPER}} .btn',
			]
		);

		$this->add_control(
			'button_border_radius',
			[
				'label' => __('Border Radius', 'bdevselement'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'button_box_shadow',
				'selector' => '{{WRAPPER}} .btn',
			]
		);

		$this->add_control(
			'hr',
			[
				'type' => Controls_Manager::DIVIDER,
				'style' => 'thick',
			]
		);

		$this->start_controls_tabs('_tabs_button');

		$this->start_controls_tab(
			'_tab_button_normal',
			[
				'label' => __('Normal', 'bdevselement'),
			]
		);

		$this->add_control(
			'link_color',
			[
				'label' => __('Text Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .btn' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'button_bg_color',
			[
				'label' => __('Background Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .btn' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'button_icon_translate',
			[
				'label' => __('Icon Translate X', 'bdevselement'),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => -100,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .btn--icon-before .btn-icon' => '-webkit-transform: translateX(calc(-1 * {{SIZE}}{{UNIT}})); transform: translateX(calc(-1 * {{SIZE}}{{UNIT}}));',
					'{{WRAPPER}} .btn--icon-after .btn-icon' => '-webkit-transform: translateX({{SIZE}}{{UNIT}}); transform: translateX({{SIZE}}{{UNIT}});',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'_tab_button_hover',
			[
				'label' => __('Hover', 'bdevselement'),
			]
		);

		$this->add_control(
			'link_hover_color',
			[
				'label' => __('Text Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .btn:hover, {{WRAPPER}} .btn:focus' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'button_hover_bg_color',
			[
				'label' => __('Background Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .btn:hover, {{WRAPPER}} .btn:focus' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'button_hover_border_color',
			[
				'label' => __('Border Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'condition' => [
					'button_border_border!' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .btn:hover, {{WRAPPER}} .btn:focus' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'button_hover_icon_translate',
			[
				'label' => __('Icon Translate X', 'bdevselement'),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 10
				],
				'range' => [
					'px' => [
						'min' => -100,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .btn.btn--icon-before:hover .btn-icon' => '-webkit-transform: translateX(calc(-1 * {{SIZE}}{{UNIT}})); transform: translateX(calc(-1 * {{SIZE}}{{UNIT}}));',
					'{{WRAPPER}} .btn.btn--icon-after:hover .btn-icon' => '-webkit-transform: translateX({{SIZE}}{{UNIT}}); transform: translateX({{SIZE}}{{UNIT}});',
				],
			]
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();

		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();

		if (!empty($settings['m_image']['id'])) {
			$mimage = wp_get_attachment_image_url($settings['m_image']['id'], 'large');
			if (!$mimage) {
				$mimage = !empty($settings['m_image']['url']) ? $settings['m_image']['url'] : '';
			}
		}

		if (!empty($settings['b_image']['id'])) {
			$bimage = wp_get_attachment_image_url($settings['b_image']['id'], 'large');
			if (!$bimage) {
				$bimage = !empty($settings['b_image']['url']) ? $settings['b_image']['url'] : '';
			}
		}

		if (!empty($settings['v_image']['id'])) {
			$vimage = wp_get_attachment_image_url($settings['v_image']['id'], 'large');
			if (!$vimage) {
				$vimage = !empty($settings['v_image']['url']) ? $settings['v_image']['url'] : '';
			}
		}

?>
		<section class="who pt-125 pb-100">
			<div class="container">
				<div class="row">
					<div class="col-lg-10 offset-lg-1">
						<div class="theme text-center">
							<?php if (!empty($settings['sub_title'])): ?>
								<span class="theme__small--title fw-700 text-uppercase">
									<span></span>
									<?php print bdevs_element_kses_basic($settings['sub_title']); ?>
									<span></span>
								</span>
							<?php endif; ?>
							<?php if (!empty($settings['title'])): ?>
								<h2 class="theme__big--title fw-700 mb-75">
									<?php print bdevs_element_kses_basic($settings['title']); ?>
								</h2>
							<?php endif; ?>
						</div>
					</div>
				</div>
				<div class="row">
					<div class="col-lg-4 col-md-6 mb-30">
						<div class="who who1 position-relative">
							<?php if (!empty($mimage)): ?>
								<div class="who__thumb">
									<img src="<?php print esc_url($mimage); ?>" alt="img">
								</div>
							<?php endif; ?>
							<div class="who__content">
								<?php if (!empty($settings['m_title'])): ?>
									<h3 class="white-color fw-600">
										<?php print bdevs_element_kses_basic($settings['m_title']); ?>
									</h3>
								<?php endif; ?>

								<?php if (!empty($settings['m_description'])): ?>
									<p class="white-color">
										<?php print bdevs_element_kses_basic($settings['m_description']); ?>
									</p>
								<?php endif; ?>

								<?php if (!empty($settings['m_button_text'])): ?>
									<a class="white-color fw-700"
										href="<?php echo esc_url($settings['m_button_link']['url']); ?>">
										<?php print bdevs_element_kses_basic($settings['m_button_text']); ?>
										<i class="far fa-long-arrow-right"></i>
									</a>
								<?php endif; ?>
							</div>
						</div>
					</div>
					<div class="col-lg-8 col-md-6">
						<div class="row">
							<div class="col-lg-6 col-md-12 mb-30">
								<div class="who who2 position-relative">
									<div class="who__content position-relative">
										<?php if (!empty($settings['v_title'])): ?>
											<h3 class="fw-600">
												<?php print bdevs_element_kses_basic($settings['v_title']); ?>
											</h3>
										<?php endif; ?>

										<?php if (!empty($settings['v_description'])): ?>
											<p>
												<?php print bdevs_element_kses_basic($settings['v_description']); ?>
											</p>
										<?php endif; ?>

										<?php if (!empty($settings['v_button_text'])): ?>
											<a class="theme-color fw-700"
												href="<?php echo esc_url($settings['v_button_link']['url']); ?>">
												<?php print bdevs_element_kses_basic($settings['v_button_text']); ?>
												<i class="far fa-long-arrow-right"></i>
											</a>
										<?php endif; ?>
									</div>
								</div>
							</div>
							<div class="col-lg-6 col-md-12 mb-30">
								<div class="who theme-bg position-relative"
									style="background-image: url(<?php print esc_url($bimage); ?>)">
									<div class="who__content position-relative">
										<?php if (!empty($settings['b_title'])): ?>
											<h3 class="white-color fw-600">
												<?php print bdevs_element_kses_basic($settings['b_title']); ?>
											</h3>
										<?php endif; ?>

										<?php if (!empty($settings['b_description'])): ?>
											<p class="white-color">
												<?php print bdevs_element_kses_basic($settings['b_description']); ?>
											</p>
										<?php endif; ?>

										<?php if (!empty($settings['b_button_text'])): ?>
											<a class="white-color fw-700"
												href="<?php echo esc_url($settings['b_button_link']['url']); ?>">
												<?php print bdevs_element_kses_basic($settings['b_button_text']); ?>
												<i class="far fa-long-arrow-right"></i>
											</a>
										<?php endif; ?>
									</div>
								</div>
							</div>
							<div class="col-sm-12 mb-30">
								<div class="who position-relative" data-overlay="theme" data-opacity="3">
									<?php if (!empty($vimage)): ?>
										<div class="who__thumb">
											<img src="<?php print esc_url($vimage); ?>" alt="img">
										</div>
									<?php endif; ?>
									<?php if (!empty($settings['v_link']['url'])): ?>
										<a class="popup-video btn--play who__play"
											href="<?php echo esc_url($settings['v_link']['url']); ?>" tabindex="0"><i
												class="fas fa-play"></i></a>
									<?php endif; ?>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
<?php }
}
