<?php

namespace BdevsElement\Widget;

use Elementor\Control_Media;
use \Elementor\Group_Control_Background;
use \Elementor\Repeater;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Typography;
use \Elementor\Core\Schemes\Typography;
use \Elementor\Utils;

defined('ABSPATH') || die();

class Testimonial_Slider extends BDevs_El_Widget
{

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Element widget name.
	 *
	 * @return string Widget name.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_name()
	{
		return 'testimonial_slider';
	}

	/**
	 * Get widget title.
	 *
	 * @return string Widget title.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_title()
	{
		return __('Testimonial', 'bdevselement');
	}

	public function get_custom_help_url()
	{
		return 'http://elementor.bdevs.net//widgets/slider/';
	}

	/**
	 * Get widget icon.
	 *
	 * @return string Widget icon.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_icon()
	{
		return 'eicon-blockquote';
	}

	public function get_keywords()
	{
		return ['slider', 'testimonial', 'gallery', 'carousel'];
	}

	protected function register_content_controls()
	{
		$this->start_controls_section(
			'_section_title',
			[
				'label' => __('Title & Description', 'bdevselement'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'image',
			[
				'label' => __('Image', 'bdevselement'),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->add_control(
			'subtitle',
			[
				'label' => __('Sub Title', 'bdevselement'),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => __('bdevs Info Box Sub Title', 'bdevselement'),
				'placeholder' => __('Type Info Box Sub Title', 'bdevselement'),
				'dynamic' => [
					'active' => true,
				]
			]
		);


		$this->add_control(
			'title',
			[
				'label' => __('Title', 'bdevselement'),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => __('bdevs Info Box Title', 'bdevselement'),
				'placeholder' => __('Type Info Box Title', 'bdevselement'),
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->add_control(
			'description',
			[
				'label' => __('Description', 'bdevselement'),
				'description' => bdevs_element_get_allowed_html_desc('intermediate'),
				'type' => Controls_Manager::TEXTAREA,
				'default' => __('bdevs info box description goes here', 'bdevselement'),
				'placeholder' => __('Type info box description', 'bdevselement'),
				'rows' => 5,
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->add_control(
			'title_tag',
			[
				'label' => __('Title HTML Tag', 'bdevselement'),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'h1' => [
						'title' => __('H1', 'bdevselement'),
						'icon' => 'eicon-editor-h1'
					],
					'h2' => [
						'title' => __('H2', 'bdevselement'),
						'icon' => 'eicon-editor-h2'
					],
					'h3' => [
						'title' => __('H3', 'bdevselement'),
						'icon' => 'eicon-editor-h3'
					],
					'h4' => [
						'title' => __('H4', 'bdevselement'),
						'icon' => 'eicon-editor-h4'
					],
					'h5' => [
						'title' => __('H5', 'bdevselement'),
						'icon' => 'eicon-editor-h5'
					],
					'h6' => [
						'title' => __('H6', 'bdevselement'),
						'icon' => 'eicon-editor-h6'
					]
				],
				'default' => 'h1',
				'toggle' => false,
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label' => __('Alignment', 'bdevselement'),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __('Left', 'bdevselement'),
						'icon' => 'fa fa-align-left',
					],
					'center' => [
						'title' => __('Center', 'bdevselement'),
						'icon' => 'fa fa-align-center',
					],
					'right' => [
						'title' => __('Right', 'bdevselement'),
						'icon' => 'fa fa-align-right',
					],
				],
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}}' => 'text-align: {{VALUE}};'
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'_section_slides',
			[
				'label' => __('Slides', 'bdevselement'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'image',
			[
				'type' => Controls_Manager::MEDIA,
				'label' => __('Image', 'bdevselement'),
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$repeater->add_control(
			'image_quote',
			[
				'type' => Controls_Manager::MEDIA,
				'label' => __('Image quote', 'bdevselement'),
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$repeater->add_control(
			'title',
			[
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'label' => __('Title', 'bdevselement'),
				'placeholder' => __('Type title here', 'bdevselement'),
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$repeater->add_control(
			'subtitle',
			[
				'type' => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'show_label' => false,
				'placeholder' => __('Designation', 'bdevselement'),
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$repeater->add_control(
			'message',
			[
				'type' => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'show_label' => false,
				'placeholder' => __('Message', 'bdevselement'),
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->add_control(
			'slides',
			[
				'show_label' => false,
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '<# print(title || "Carousel Item"); #>',
				'default' => [
					[
						'image' => [
							'url' => Utils::get_placeholder_image_src(),
						],
					],
					[
						'image' => [
							'url' => Utils::get_placeholder_image_src(),
						],
					],
					[
						'image' => [
							'url' => Utils::get_placeholder_image_src(),
						],
					],
				]
			]
		);

		$this->add_group_control(
			Group_Control_Image_Size::get_type(),
			[
				'name' => 'thumbnail',
				'default' => 'medium_large',
				'separator' => 'before',
				'exclude' => [
					'custom'
				]
			]
		);


		$this->end_controls_section();

		$this->start_controls_section(
			'_section_settings',
			[
				'label' => __('Settings', 'bdevselement'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'animation_speed',
			[
				'label' => __('Animation Speed', 'bdevselement'),
				'type' => Controls_Manager::NUMBER,
				'min' => 100,
				'step' => 10,
				'max' => 10000,
				'default' => 300,
				'description' => __('Slide speed in milliseconds', 'bdevselement'),
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'autoplay',
			[
				'label' => __('Autoplay?', 'bdevselement'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __('Yes', 'bdevselement'),
				'label_off' => __('No', 'bdevselement'),
				'return_value' => 'yes',
				'default' => 'yes',
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'autoplay_speed',
			[
				'label' => __('Autoplay Speed', 'bdevselement'),
				'type' => Controls_Manager::NUMBER,
				'min' => 100,
				'step' => 100,
				'max' => 10000,
				'default' => 3000,
				'description' => __('Autoplay speed in milliseconds', 'bdevselement'),
				'condition' => [
					'autoplay' => 'yes'
				],
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'loop',
			[
				'label' => __('Infinite Loop?', 'bdevselement'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __('Yes', 'bdevselement'),
				'label_off' => __('No', 'bdevselement'),
				'return_value' => 'yes',
				'default' => 'yes',
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'vertical',
			[
				'label' => __('Vertical Mode?', 'bdevselement'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __('Yes', 'bdevselement'),
				'label_off' => __('No', 'bdevselement'),
				'return_value' => 'yes',
				'frontend_available' => true,
				'style_transfer' => true,
			]
		);

		$this->add_control(
			'navigation',
			[
				'label' => __('Navigation', 'bdevselement'),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'none' => __('None', 'bdevselement'),
					'arrow' => __('Arrow', 'bdevselement'),
					'dots' => __('Dots', 'bdevselement'),
					'both' => __('Arrow & Dots', 'bdevselement'),
				],
				'default' => 'arrow',
				'frontend_available' => true,
				'style_transfer' => true,
			]
		);

		$this->add_control(
			'design_style',
			[
				'label' => __('Design Style', 'bdevselement'),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'style_1' => __('Style 1', 'bdevselement'),
					'style_2' => __('Style 2', 'bdevselement'),
					'style_3' => __('Style 3', 'bdevselement'),
					'style_4' => __('Style 4', 'bdevselement'),
				],
				'default' => 'style_1',
				'frontend_available' => true,
				'style_transfer' => true,
			]
		);

		$this->end_controls_section();
	}

	protected function register_style_controls()
	{
		$this->start_controls_section(
			'_section_style_item',
			[
				'label' => __('Slider Item', 'bdevselement'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'item_border',
				'selector' => '{{WRAPPER}} .bdevs-slick-item',
			]
		);

		$this->add_responsive_control(
			'item_border_radius',
			[
				'label' => __('Border Radius', 'bdevselement'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .bdevs-slick-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; overflow: hidden;',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'_section_style_content',
			[
				'label' => __('Slide Content', 'bdevselement'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'content_padding',
			[
				'label' => __('Content Padding', 'bdevselement'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .bdevs-slick-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'content_background',
				'selector' => '{{WRAPPER}} .bdevs-slick-content',
				'exclude' => [
					'image'
				]
			]
		);

		$this->add_control(
			'_heading_title',
			[
				'type' => Controls_Manager::HEADING,
				'label' => __('Title', 'bdevselement'),
				'separator' => 'before'
			]
		);

		$this->add_responsive_control(
			'title_spacing',
			[
				'label' => __('Bottom Spacing', 'bdevselement'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'selectors' => [
					'{{WRAPPER}} .bdevs-slick-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' => __('Text Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bdevs-slick-title' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title',
				'selector' => '{{WRAPPER}} .bdevs-slick-title',
				//'scheme' => Typography::TYPOGRAPHY_2,
			]
		);

		$this->add_control(
			'_heading_subtitle',
			[
				'type' => Controls_Manager::HEADING,
				'label' => __('Subtitle', 'bdevselement'),
				'separator' => 'before'
			]
		);

		$this->add_responsive_control(
			'subtitle_spacing',
			[
				'label' => __('Bottom Spacing', 'bdevselement'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'selectors' => [
					'{{WRAPPER}} .bdevs-slick-subtitle' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'subtitle_color',
			[
				'label' => __('Text Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bdevs-slick-subtitle' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'subtitle',
				'selector' => '{{WRAPPER}} .bdevs-slick-subtitle',
				//'scheme' => Typography::TYPOGRAPHY_3,
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'_section_style_arrow',
			[
				'label' => __('Navigation - Arrow', 'bdevselement'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'arrow_position_toggle',
			[
				'label' => __('Position', 'bdevselement'),
				'type' => Controls_Manager::POPOVER_TOGGLE,
				'label_off' => __('None', 'bdevselement'),
				'label_on' => __('Custom', 'bdevselement'),
				'return_value' => 'yes',
			]
		);

		$this->start_popover();

		$this->add_responsive_control(
			'arrow_position_y',
			[
				'label' => __('Vertical', 'bdevselement'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'condition' => [
					'arrow_position_toggle' => 'yes'
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .slick-prev, {{WRAPPER}} .slick-next' => 'top: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'arrow_position_x',
			[
				'label' => __('Horizontal', 'bdevselement'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'condition' => [
					'arrow_position_toggle' => 'yes'
				],
				'range' => [
					'px' => [
						'min' => -100,
						'max' => 250,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .slick-prev' => 'left: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .slick-next' => 'right: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_popover();

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'arrow_border',
				'selector' => '{{WRAPPER}} .slick-prev, {{WRAPPER}} .slick-next',
			]
		);

		$this->add_responsive_control(
			'arrow_border_radius',
			[
				'label' => __('Border Radius', 'bdevselement'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .slick-prev, {{WRAPPER}} .slick-next' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; overflow: hidden;',
				],
			]
		);

		$this->start_controls_tabs('_tabs_arrow');

		$this->start_controls_tab(
			'_tab_arrow_normal',
			[
				'label' => __('Normal', 'bdevselement'),
			]
		);

		$this->add_control(
			'arrow_color',
			[
				'label' => __('Text Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .slick-prev, {{WRAPPER}} .slick-next' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'arrow_bg_color',
			[
				'label' => __('Background Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .slick-prev, {{WRAPPER}} .slick-next' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'_tab_arrow_hover',
			[
				'label' => __('Hover', 'bdevselement'),
			]
		);

		$this->add_control(
			'arrow_hover_color',
			[
				'label' => __('Text Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .slick-prev:hover, {{WRAPPER}} .slick-next:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'arrow_hover_bg_color',
			[
				'label' => __('Background Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .slick-prev:hover, {{WRAPPER}} .slick-next:hover' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'arrow_hover_border_color',
			[
				'label' => __('Border Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'condition' => [
					'arrow_border_border!' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .slick-prev:hover, {{WRAPPER}} .slick-next:hover' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();

		$this->end_controls_section();

		$this->start_controls_section(
			'_section_style_dots',
			[
				'label' => __('Navigation - Dots', 'bdevselement'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'dots_nav_position_y',
			[
				'label' => __('Vertical Position', 'bdevselement'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range' => [
					'px' => [
						'min' => -100,
						'max' => 500,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .slick-dots' => 'bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'dots_nav_spacing',
			[
				'label' => __('Spacing', 'bdevselement'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'selectors' => [
					'{{WRAPPER}} .slick-dots li' => 'margin-right: calc({{SIZE}}{{UNIT}} / 2); margin-left: calc({{SIZE}}{{UNIT}} / 2);',
				],
			]
		);

		$this->add_responsive_control(
			'dots_nav_align',
			[
				'label' => __('Alignment', 'bdevselement'),
				'type' => Controls_Manager::CHOOSE,
				'label_block' => false,
				'options' => [
					'left' => [
						'title' => __('Left', 'bdevselement'),
						'icon' => 'eicon-h-align-left',
					],
					'center' => [
						'title' => __('Center', 'bdevselement'),
						'icon' => 'eicon-h-align-center',
					],
					'right' => [
						'title' => __('Right', 'bdevselement'),
						'icon' => 'eicon-h-align-right',
					],
				],
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .slick-dots' => 'text-align: {{VALUE}}'
				]
			]
		);

		$this->start_controls_tabs('_tabs_dots');
		$this->start_controls_tab(
			'_tab_dots_normal',
			[
				'label' => __('Normal', 'bdevselement'),
			]
		);

		$this->add_control(
			'dots_nav_color',
			[
				'label' => __('Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .slick-dots li button:before' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'_tab_dots_hover',
			[
				'label' => __('Hover', 'bdevselement'),
			]
		);

		$this->add_control(
			'dots_nav_hover_color',
			[
				'label' => __('Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .slick-dots li button:hover:before' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'_tab_dots_active',
			[
				'label' => __('Active', 'bdevselement'),
			]
		);

		$this->add_control(
			'dots_nav_active_color',
			[
				'label' => __('Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .slick-dots .slick-active button:before' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();

		$this->end_controls_section();
	}

	protected function render()
	{

		$settings = $this->get_settings_for_display();

		if (empty($settings['slides'])) {
			return;
		}
?>

		<?php if ($settings['design_style'] == 'style_4'): ?>
			<section class="review--area pt-125 position-relative">
				<img src="<?php echo get_template_directory_uri(); ?>/assets/images/icon/h4-quotes-icon.png" alt="img"
					class="review__quotes--icon">
				<img src="<?php echo get_template_directory_uri(); ?>/assets/images/shape/rev-shape-ex.png" alt="Shape"
					class="review-shape--line aos-init aos-animate" data-aos="fade-right" data-aos-easing="ease-in-sine"
					data-aos-duration="9000">
				<div class="review__shape review__shape--ex"></div>
				<div class="container">
					<div class="row">
						<div class="col-xl-6 offset-xl-3 col-lg-8 offset-lg-2">
							<div class="theme text-center">
								<?php if (!empty($settings['subtitle'])) : ?>
									<span class="theme__small--title fw-700 text-uppercase color-text-2"><span
											class="white-line"></span>
										<?php echo bdevs_element_kses_basic($settings['subtitle']); ?>
										<span class="white-line"></span></span>
								<?php endif; ?>
								<?php if (!empty($settings['title'])) : ?>
									<h2 class="theme__big--title fw-700 mb-80 white-color">
										<?php echo bdevs_element_kses_basic($settings['title']); ?>
									</h2>
								<?php endif; ?>
							</div>
						</div>
					</div>
					<div class="row align-items-center">
						<div class="col-sm-12">
							<div class="review__active--h2 review__active--h4 row">
								<?php foreach ($settings['slides'] as $slide) :
									// image
									$image = wp_get_attachment_image_url($slide['image']['id'], $settings['thumbnail_size']);
									if (!$image) {
										$image = $slide['image']['url'];
									} ?>
									<div class="review__single col-lg-4 mb-80">
										<div class="review__wrapper review__wrapper--h4 white-bg">
											<div class="review__content review__content--h4 position-relative">
												<?php if (!empty($slide['message'])) : ?>
													<h5 class="mb-20 primary-color fw-400">
														<i class="fal fa-quote-left"></i>
														<?php echo bdevs_element_kses_basic($slide['message']); ?>
													</h5>
												<?php endif; ?>
											</div>
											<div class="review--header--h2 position-relative d-flex align-items-center">
												<?php if (!empty($image)) : ?>
													<div class="review--author--img position-relative">
														<img src="<?php print esc_url($image); ?>" alt="img">
													</div>
												<?php endif; ?>

												<div class="review__header--text pl-15">
													<?php if (!empty($slide['title'])) : ?>
														<h4><?php echo bdevs_element_kses_basic($slide['title']); ?></h4>
													<?php endif; ?>
													<?php if (!empty($slide['subtitle'])) : ?>
														<h6 class="primary-color fw-400 text-uppercase mb-0"><?php echo bdevs_element_kses_basic($slide['subtitle']); ?></h6>
													<?php endif; ?>
												</div>
											</div>
										</div>
									</div>
								<?php endforeach; ?>
							</div>
						</div>
					</div>
				</div>
			</section>
		<?php elseif ($settings['design_style'] == 'style_3'): ?>
			<section class="review--area pt-125 pb-130 position-relative">
				<img src="<?php echo get_template_directory_uri(); ?>/assets/images/icon/h4-quotes-icon.png" alt="img"
					class="review__quotes--icon">
				<img src="<?php echo get_template_directory_uri(); ?>/assets/images/shape/services-line-shape.png"
					alt="Shape" class="review-shape--line aos-init aos-animate" data-aos="fade-right"
					data-aos-easing="ease-in-sine" data-aos-duration="9000">
				<div class="review__shape"></div>
				<div class="container">
					<div class="row">
						<div class="col-xl-6 offset-xl-3 col-lg-8 offset-lg-2">
							<div class="theme text-center">
								<?php if (!empty($settings['subtitle'])) : ?>
									<span class="theme__small--title fw-700 text-uppercase"><span></span>
										<?php echo bdevs_element_kses_basic($settings['subtitle']); ?>
										<span></span></span>
								<?php endif; ?>
								<?php if (!empty($settings['title'])) : ?>
									<h2 class="theme__big--title fw-700 mb-80">
										<?php echo bdevs_element_kses_basic($settings['title']); ?>
									</h2>
								<?php endif; ?>
							</div>
						</div>
					</div>
					<div class="row align-items-center">
						<div class="col-sm-12">
							<div class="review__active--h2 review__active--h4 row">
								<?php foreach ($settings['slides'] as $slide) :
									if (!empty($slide['image']['id'])) {
										$image = wp_get_attachment_image_url($slide['image']['id'], $settings['thumbnail_size']);
									} ?>
									<div class="review__single col-lg-4 mb-80">
										<div class="review__wrapper review__wrapper--h4 white-bg">
											<div class="review__content review__content--h4 position-relative">
												<?php if (!empty($slide['message'])) : ?>
													<h5 class="mb-20 primary-color fw-400">
														<i class="fal fa-quote-left"></i>
														<?php echo bdevs_element_kses_basic($slide['message']); ?>
													</h5>
												<?php endif; ?>
											</div>
											<div class="review--header--h2 position-relative d-flex align-items-center">
												<?php if (!empty($image)) : ?>
													<div class="review--author--img position-relative">
														<img src="<?php print esc_url($image); ?>" alt="img">
													</div>
												<?php endif; ?>

												<div class="review__header--text pl-15">
													<?php if (!empty($slide['title'])) : ?>
														<h4><?php echo bdevs_element_kses_basic($slide['title']); ?></h4>
													<?php endif; ?>
													<?php if (!empty($slide['subtitle'])) : ?>
														<h6 class="primary-color fw-400 text-uppercase mb-0"><?php echo bdevs_element_kses_basic($slide['subtitle']); ?></h6>
													<?php endif; ?>
												</div>
											</div>
										</div>
									</div>
								<?php endforeach; ?>
							</div>
						</div>
					</div>
				</div>
			</section>
		<?php elseif ($settings['design_style'] == 'style_2'):

			$this->add_inline_editing_attributes('title', 'basic');
			$this->add_render_attribute('title', 'class', 'theme__big--title fw-700');

			$this->add_inline_editing_attributes('description', 'intermediate');
			$this->add_render_attribute('description', 'class', 'theme__small--title fw-700 text-uppercase theme__small--title-left');

		?>
			<section class="review--area pt-125 pb-130">
				<div class="container">
					<div class="row">
						<div class="col-lg-7 mb-70">
							<div class="theme">
								<?php if (!empty($settings['description'])) : ?>
									<span <?php $this->print_render_attribute_string('description'); ?>><span></span><?php echo bdevs_element_kses_intermediate($settings['description']); ?></span>
								<?php endif; ?>

								<?php if (!empty($settings['title'])) :
									printf(
										'<%1$s %2$s>%3$s</%1$s>',
										tag_escape($settings['title_tag']),
										$this->get_render_attribute_string('title'),
										bdevs_element_kses_basic($settings['title'])
									);
								endif; ?>
							</div>
						</div>
					</div>
					<div class="row align-items-center">
						<div class="col-sm-12">
							<div class="review__active--h2 row">
								<?php foreach ($settings['slides'] as $slide) :
									// image
									$image = wp_get_attachment_image_url($slide['image']['id'], $settings['thumbnail_size']);
									if (!$image) {
										$image = $slide['image']['url'];
									} ?>
									<div class="review__single col-lg-4 mb-80">
										<div class="review__wrapper">
											<div class="review--header review--header--h2 position-relative d-flex align-items-center">
												<?php if (!empty($image)) : ?>
													<div class="review--header--img position-relative">
														<img src="<?php print esc_url($image); ?>" alt="img">
													</div>
												<?php endif; ?>
												<div class="review__header--text pl-30">
													<?php if (!empty($slide['title'])) : ?>
														<h4><?php echo bdevs_element_kses_basic($slide['title']); ?></h4>
													<?php endif; ?>
													<?php if (!empty($slide['subtitle'])) : ?>
														<h6 class="primary-color fw-400 text-uppercase mb-0"><?php echo bdevs_element_kses_basic($slide['subtitle']); ?></h6>
													<?php endif; ?>
												</div>
											</div>
											<div class="review__content position-relative">
												<?php if (!empty($slide['message'])) : ?>
													<p class="mb-25"><?php echo bdevs_element_kses_basic($slide['message']); ?></p>
												<?php endif; ?>
												<i class="review__quote review__quote--h2 fas fa-quote-right"></i>
												<ul>
													<li><i class="fas fa-star"></i></li>
													<li><i class="fas fa-star"></i></li>
													<li><i class="fas fa-star"></i></li>
													<li><i class="fas fa-star"></i></li>
													<li><i class="fas fa-star"></i></li>
												</ul>
											</div>
										</div>
									</div>
								<?php endforeach; ?>
							</div>
						</div>
					</div>
				</div>
			</section>

		<?php else: ?>

			<section class="review--area review--minus">
				<div class="container">
					<div class="row align-items-center">
						<div class="col-lg-5 mb-30">
							<?php if (($settings['image']['url'] || $settings['image']['id'])) :
								$this->add_render_attribute('image', 'src', $settings['image']['url']);
								$this->add_render_attribute('image', 'alt', Control_Media::get_image_alt($settings['image']));
								$this->add_render_attribute('image', 'title', Control_Media::get_image_title($settings['image']));
								$settings['hover_animation'] = 'disable-animation'; // hack to prevent image hover animation
							?>
								<div class="review__img aos-init">
									<?php echo Group_Control_Image_Size::get_attachment_image_html($settings, 'thumbnail', 'image'); ?>
								</div>
							<?php endif; ?>
						</div>
						<div class="col-lg-6 offset-lg-1 mb-30">
							<div class="review__active">
								<?php foreach ($settings['slides'] as $slide) :
									// image
									$image = wp_get_attachment_image_url($slide['image']['id'], $settings['thumbnail_size']);
									if (!$image) {
										$image = $slide['image']['url'];
									}
								?>
									<div class="review__single">
										<div class="review--header d-flex align-items-center position-relative">
											<?php if (!empty($image)) : ?>
												<i class="review__quote fal fa-quote-left"></i>
												<div class="review__header--img">
													<img src="<?php print esc_url($image); ?>" alt="slide-image">
												</div>
											<?php endif; ?>
											<div class="review__header--text pl-30">
												<?php if (!empty($slide['title'])) : ?>
													<h4><?php echo bdevs_element_kses_basic($slide['title']); ?></h4>
												<?php endif; ?>
												<?php if (!empty($slide['subtitle'])) : ?>
													<h6 class="primary-color fw-400 text-uppercase mb-0"><?php echo bdevs_element_kses_basic($slide['subtitle']); ?></h6>
												<?php endif; ?>
											</div>
										</div>
										<?php if (!empty($slide['message'])) : ?>
											<div class="review__content">
												<p><?php echo bdevs_element_kses_basic($slide['message']); ?></p>
											</div>
										<?php endif; ?>
									</div>
								<?php endforeach; ?>
							</div>
						</div>
					</div>
				</div>
			</section>

		<?php endif; ?>

<?php
	}
}
