<?php

namespace BdevsElement\Widget;

use \Elementor\Group_Control_Background;
use \Elementor\Repeater;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Typography;
use \Elementor\Core\Schemes\Typography;
use \Elementor\Utils;

defined('ABSPATH') || die();


class Slider extends BDevs_El_Widget
{

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Element widget name.
	 *
	 * @return string Widget name.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_name()
	{
		return 'slider';
	}


	/**
	 * Get widget title.
	 *
	 * @return string Widget title.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_title()
	{
		return __('Slider', 'bdevselement');
	}

	public function get_custom_help_url()
	{
		return 'http://elementor.bdevs.net//widgets/slider/';
	}

	/**
	 * Get widget icon.
	 *
	 * @return string Widget icon.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_icon()
	{
		return 'eicon-slider-full-screen';
	}

	public function get_keywords()
	{
		return ['slider', 'image', 'gallery', 'carousel'];
	}

	protected function register_content_controls()
	{


		$this->start_controls_section(
			'_section_slides',
			[
				'label' => __('Slides', 'bdevselement'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'design_style',
			[
				'label' => __('Design Style', 'bdevselement'),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'style_1' => __('Style 1', 'bdevselement'),
					'style_2' => __('Style 2', 'bdevselement'),
					'style_3' => __('Style 3', 'bdevselement'),
					'style_4' => __('Style 4', 'bdevselement'),
					'style_5' => __('Style 5', 'bdevselement'),
				],
				'default' => 'style_1',
				'frontend_available' => true,
				'style_transfer' => true,
			]
		);

		$this->add_control(
			'shape_switch',
			[
				'label' => __('Shape On/Off?', 'bdevselement'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __('Yes', 'bdevselement'),
				'label_off' => __('No', 'bdevselement'),
				'return_value' => 'yes',
				'default' => 'yes',
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'shape_bg_color',
			[
				'label' => __('Shape BG Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .hero__shape' => 'background-color: {{VALUE}};',
				],
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'field_condition',
			[
				'label' => __('Field condition', 'bdevselement'),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'style_1' => __('Style 1', 'bdevselement'),
					'style_2' => __('Style 2', 'bdevselement'),
					'style_3' => __('Style 3', 'bdevselement'),
					'style_4' => __('Style 4', 'bdevselement'),
					'style_5' => __('Style 5', 'bdevselement'),
				],
				'default' => 'style_1',
				'frontend_available' => true,
				'style_transfer' => true,
			]
		);

		$repeater->add_control(
			'image',
			[
				'type' => Controls_Manager::MEDIA,
				'label' => __('Image', 'bdevselement'),
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$repeater->add_control(
			'shape_title',
			[
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'show_label' => true,
				'label' => __('Shape Title', 'bdevselement'),
				'placeholder' => __('Type subtitle here', 'bdevselement'),
				'condition' => [
					'field_condition' => ['style_5'],
				],
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$repeater->add_control(
			'subtitle',
			[
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'show_label' => true,
				'label' => __('Sub Title', 'bdevselement'),
				'default' => __('Subtitle', 'bdevselement'),
				'placeholder' => __('Type subtitle here', 'bdevselement'),
				'condition' => [
					'field_condition' => ['style_1', 'style_3', 'style_5'],
				],
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$repeater->add_control(
			'title',
			[
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'label' => __('Title', 'bdevselement'),
				'default' => __('Title Here', 'bdevselement'),
				'placeholder' => __('Type title here', 'bdevselement'),
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$repeater->add_control(
			'desc',
			[
				'type' => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'label' => __('Description', 'bdevselement'),
				'default' => __('Here content', 'bdevselement'),
				'placeholder' => __('Type title here', 'bdevselement'),
				'condition' => [
					'field_condition' => ['style_2', 'style_5', 'style_4'],
				],
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$repeater->add_control(
			'video_url',
			[
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'show_label' => true,
				'label' => __('Video URL', 'bdevselement'),
				'default' => __('#', 'bdevselement'),
				'placeholder' => __('url here', 'bdevselement'),
				'condition' => [
					'field_condition' => ['style_4'],
				],
				'dynamic' => [
					'active' => true,
				]
			]
		);

		//button two
		$repeater->add_control(
			'button_text',
			[
				'label' => __('Button One Text', 'bdevselement'),
				'type' => Controls_Manager::TEXT,
				'default' => 'Button Text',
				'placeholder' => __('Type button text here', 'bdevselement'),
				'label_block' => true,
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$repeater->add_control(
			'button_link',
			[
				'label' => __('Button One Link', 'bdevselement'),
				'type' => Controls_Manager::URL,
				'placeholder' => 'http://elementor.bdevs.net/',
				'dynamic' => [
					'active' => true,
				]
			]
		);

		if (bdevs_element_is_elementor_version('<', '2.6.0')) {
			$repeater->add_control(
				'button_icon',
				[
					'label' => __('Icon', 'bdevselement'),
					'label_block' => true,
					'type' => Controls_Manager::ICON,
					'options' => bdevs_element_get_bdevs_element_icons(),
					'default' => 'fa fa-angle-right',
				]
			);

			$condition = ['button_icon!' => ''];
		} else {
			$repeater->add_control(
				'button_selected_icon',
				[
					'type' => Controls_Manager::ICONS,
					'fa4compatibility' => 'button_icon',
					'label_block' => true,
				]
			);
			$condition = ['button_selected_icon[value]!' => ''];
		}

		$repeater->add_control(
			'button_icon_position',
			[
				'label' => __('Icon Position', 'bdevselement'),
				'type' => Controls_Manager::CHOOSE,
				'label_block' => false,
				'options' => [
					'before' => [
						'title' => __('Before', 'bdevselement'),
						'icon' => 'eicon-h-align-left',
					],
					'after' => [
						'title' => __('After', 'bdevselement'),
						'icon' => 'eicon-h-align-right',
					],
				],
				'default' => 'before',
				'toggle' => false,
				'condition' => $condition,
				'style_transfer' => true,
			]
		);

		$repeater->add_control(
			'button_icon_spacing',
			[
				'label' => __('Icon Spacing', 'bdevselement'),
				'type' => Controls_Manager::SLIDER,
				'condition' => $condition,
				'selectors' => [
					'{{WRAPPER}} .bdevs-btn--icon-before .bdevs-btn-icon' => 'margin-right: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .bdevs-btn--icon-after .bdevs-btn-icon' => 'margin-left: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$repeater->add_control(
			'button2_text',
			[
				'label' => __('Button Two Text', 'bdevselement'),
				'type' => Controls_Manager::TEXT,
				'default' => 'Button 2 Text',
				'placeholder' => __('Type button 2 text here', 'bdevselement'),
				'label_block' => true,
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$repeater->add_control(
			'button2_link',
			[
				'label' => __('Button Two Link', 'bdevselement'),
				'type' => Controls_Manager::URL,
				'placeholder' => 'http://elementor.bdevs.net/',
				'dynamic' => [
					'active' => true,
				]
			]
		);

		if (bdevs_element_is_elementor_version('<', '2.6.0')) {
			$repeater->add_control(
				'button2_icon',
				[
					'label' => __('Icon', 'bdevselement'),
					'label_block' => true,
					'type' => Controls_Manager::ICON,
					'options' => bdevs_element_get_bdevs_element_icons(),
					'default' => 'fa fa-angle-right',
				]
			);

			$condition_2 = ['button2_icon!' => ''];
		} else {
			$repeater->add_control(
				'button2_selected_icon',
				[
					'type' => Controls_Manager::ICONS,
					'fa4compatibility' => 'button_icon',
					'label_block' => true,
				]
			);
			$condition_2 = ['button2_selected_icon[value]!' => ''];
		}

		$repeater->add_control(
			'button2_icon_position',
			[
				'label' => __('Icon Position', 'bdevselement'),
				'type' => Controls_Manager::CHOOSE,
				'label_block' => false,
				'options' => [
					'before' => [
						'title' => __('Before', 'bdevselement'),
						'icon' => 'eicon-h-align-left',
					],
					'after' => [
						'title' => __('After', 'bdevselement'),
						'icon' => 'eicon-h-align-right',
					],
				],
				'default' => 'before',
				'toggle' => false,
				'condition' => $condition_2,
				'style_transfer' => true,
			]
		);

		$repeater->add_control(
			'button2_icon_spacing',
			[
				'label' => __('Icon Spacing', 'bdevselement'),
				'type' => Controls_Manager::SLIDER,
				'condition' => $condition_2,
				'selectors' => [
					'{{WRAPPER}} .bdevs-btn--icon-before2 .bdevs-btn-icon' => 'margin-right: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .bdevs-btn--icon-after2 .bdevs-btn-icon' => 'margin-left: {{SIZE}}{{UNIT}};',
				],
			]
		);
		//end button

		$this->add_control(
			'slides',
			[
				'show_label' => false,
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '<# print(title || "Carousel Item"); #>',
				'default' => [
					[
						'image' => [
							'url' => Utils::get_placeholder_image_src(),
						],
					],
					[
						'image' => [
							'url' => Utils::get_placeholder_image_src(),
						],
					],
					[
						'image' => [
							'url' => Utils::get_placeholder_image_src(),
						],
					],
					[
						'image' => [
							'url' => Utils::get_placeholder_image_src(),
						],
					],
					[
						'image' => [
							'url' => Utils::get_placeholder_image_src(),
						],
					]
				]
			]
		);

		$this->add_group_control(
			Group_Control_Image_Size::get_type(),
			[
				'name' => 'thumbnail',
				'default' => 'medium_large',
				'separator' => 'before',
				'exclude' => [
					'custom'
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'_section_settings',
			[
				'label' => __('Settings', 'bdevselement'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'animation_speed',
			[
				'label' => __('Animation Speed', 'bdevselement'),
				'type' => Controls_Manager::NUMBER,
				'min' => 100,
				'step' => 10,
				'max' => 10000,
				'default' => 300,
				'description' => __('Slide speed in milliseconds', 'bdevselement'),
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'autoplay',
			[
				'label' => __('Autoplay?', 'bdevselement'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __('Yes', 'bdevselement'),
				'label_off' => __('No', 'bdevselement'),
				'return_value' => 'yes',
				'default' => 'yes',
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'autoplay_speed',
			[
				'label' => __('Autoplay Speed', 'bdevselement'),
				'type' => Controls_Manager::NUMBER,
				'min' => 100,
				'step' => 100,
				'max' => 10000,
				'default' => 3000,
				'description' => __('Autoplay speed in milliseconds', 'bdevselement'),
				'condition' => [
					'autoplay' => 'yes'
				],
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'slidetoshow',
			[
				'label' => __('Slide to Show', 'bdevselement'),
				'type' => Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'max' => 12,
				'default' => 1,
				'description' => __('How many item you want to show?', 'bdevselement'),
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'loop',
			[
				'label' => __('Infinite Loop?', 'bdevselement'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __('Yes', 'bdevselement'),
				'label_off' => __('No', 'bdevselement'),
				'return_value' => 'yes',
				'default' => 'yes',
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'vertical',
			[
				'label' => __('Vertical Mode?', 'bdevselement'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __('Yes', 'bdevselement'),
				'label_off' => __('No', 'bdevselement'),
				'return_value' => 'yes',
				'frontend_available' => true,
				'style_transfer' => true,
			]
		);

		$this->add_control(
			'navigation',
			[
				'label' => __('Navigation', 'bdevselement'),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'none' => __('None', 'bdevselement'),
					'arrow' => __('Arrow', 'bdevselement'),
					'dots' => __('Dots', 'bdevselement'),
					'both' => __('Arrow & Dots', 'bdevselement'),
				],
				'default' => 'arrow',
				'frontend_available' => true,
				'style_transfer' => true,
			]
		);

		$this->end_controls_section();
	}

	protected function register_style_controls()
	{
		$this->start_controls_section(
			'_section_style_content',
			[
				'label' => __('Slide Content', 'bdevselement'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'content_padding',
			[
				'label' => __('Content Padding', 'bdevselement'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .single-slide-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'content_background',
				'selector' => '{{WRAPPER}} .single-slide-content',
				'exclude' => [
					'image'
				]
			]
		);

		$this->add_control(
			'_heading_title',
			[
				'type' => Controls_Manager::HEADING,
				'label' => __('Title', 'bdevselement'),
				'separator' => 'before'
			]
		);

		$this->add_responsive_control(
			'title_spacing',
			[
				'label' => __('Bottom Spacing', 'bdevselement'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'selectors' => [
					'{{WRAPPER}} .title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' => __('Text Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .title' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title',
				'selector' => '{{WRAPPER}} .title',
				//'scheme' => Typography::TYPOGRAPHY_2,
			]
		);

		$this->add_control(
			'_heading_subtitle',
			[
				'type' => Controls_Manager::HEADING,
				'label' => __('Subtitle', 'bdevselement'),
				'separator' => 'before'
			]
		);

		$this->add_responsive_control(
			'subtitle_spacing',
			[
				'label' => __('Bottom Spacing', 'bdevselement'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'selectors' => [
					'{{WRAPPER}} .sub-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'subtitle_color',
			[
				'label' => __('Text Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sub-title' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'subtitle',
				'selector' => '{{WRAPPER}} .sub-title',
				//'scheme' => Typography::TYPOGRAPHY_3,
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'_section_style_arrow',
			[
				'label' => __('Navigation - Arrow', 'bdevselement'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'arrow_position_toggle',
			[
				'label' => __('Position', 'bdevselement'),
				'type' => Controls_Manager::POPOVER_TOGGLE,
				'label_off' => __('None', 'bdevselement'),
				'label_on' => __('Custom', 'bdevselement'),
				'return_value' => 'yes',
			]
		);

		$this->start_popover();

		$this->add_responsive_control(
			'arrow_position_y',
			[
				'label' => __('Vertical', 'bdevselement'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'condition' => [
					'arrow_position_toggle' => 'yes'
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .slick-prev, {{WRAPPER}} .slick-next' => 'top: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'arrow_position_x',
			[
				'label' => __('Horizontal', 'bdevselement'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'condition' => [
					'arrow_position_toggle' => 'yes'
				],
				'range' => [
					'px' => [
						'min' => -100,
						'max' => 250,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .slick-prev' => 'left: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .slick-next' => 'right: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_popover();

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'arrow_border',
				'selector' => '{{WRAPPER}} .slick-prev, {{WRAPPER}} .slick-next',
			]
		);

		$this->add_responsive_control(
			'arrow_border_radius',
			[
				'label' => __('Border Radius', 'bdevselement'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .slick-prev, {{WRAPPER}} .slick-next' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; overflow: hidden;',
				],
			]
		);

		$this->start_controls_tabs('_tabs_arrow');

		$this->start_controls_tab(
			'_tab_arrow_normal',
			[
				'label' => __('Normal', 'bdevselement'),
			]
		);

		$this->add_control(
			'arrow_color',
			[
				'label' => __('Text Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .slick-prev, {{WRAPPER}} .slick-next' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'arrow_bg_color',
			[
				'label' => __('Background Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .slick-prev, {{WRAPPER}} .slick-next' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'_tab_arrow_hover',
			[
				'label' => __('Hover', 'bdevselement'),
			]
		);

		$this->add_control(
			'arrow_hover_color',
			[
				'label' => __('Text Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .slick-prev:hover, {{WRAPPER}} .slick-next:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'arrow_hover_bg_color',
			[
				'label' => __('Background Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .slick-prev:hover, {{WRAPPER}} .slick-next:hover' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'arrow_hover_border_color',
			[
				'label' => __('Border Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'condition' => [
					'arrow_border_border!' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .slick-prev:hover, {{WRAPPER}} .slick-next:hover' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();

		$this->end_controls_section();

		$this->start_controls_section(
			'_section_style_dots',
			[
				'label' => __('Navigation - Dots', 'bdevselement'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'dots_nav_position_y',
			[
				'label' => __('Vertical Position', 'bdevselement'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range' => [
					'px' => [
						'min' => -100,
						'max' => 500,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .slick-dots' => 'bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'dots_nav_spacing',
			[
				'label' => __('Spacing', 'bdevselement'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'selectors' => [
					'{{WRAPPER}} .slick-dots li' => 'margin-right: calc({{SIZE}}{{UNIT}} / 2); margin-left: calc({{SIZE}}{{UNIT}} / 2);',
				],
			]
		);

		$this->add_responsive_control(
			'dots_nav_align',
			[
				'label' => __('Alignment', 'bdevselement'),
				'type' => Controls_Manager::CHOOSE,
				'label_block' => false,
				'options' => [
					'left' => [
						'title' => __('Left', 'bdevselement'),
						'icon' => 'eicon-h-align-left',
					],
					'center' => [
						'title' => __('Center', 'bdevselement'),
						'icon' => 'eicon-h-align-center',
					],
					'right' => [
						'title' => __('Right', 'bdevselement'),
						'icon' => 'eicon-h-align-right',
					],
				],
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .slick-dots' => 'text-align: {{VALUE}}'
				]
			]
		);

		$this->start_controls_tabs('_tabs_dots');
		$this->start_controls_tab(
			'_tab_dots_normal',
			[
				'label' => __('Normal', 'bdevselement'),
			]
		);

		$this->add_control(
			'dots_nav_color',
			[
				'label' => __('Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .slick-dots li button' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'_tab_dots_hover',
			[
				'label' => __('Hover', 'bdevselement'),
			]
		);

		$this->add_control(
			'dots_nav_hover_color',
			[
				'label' => __('Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .slick-dots li button:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'_tab_dots_active',
			[
				'label' => __('Active', 'bdevselement'),
			]
		);

		$this->add_control(
			'dots_nav_active_color',
			[
				'label' => __('Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .slick-dots .slick-active button' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();

		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		$slider_id = rand(12036456, 25693487);
		$slider_autoplay = (!empty($settings['autoplay']) and $settings['autoplay'] == 'yes') ? true : false;
		$slider_playspeed = $settings['autoplay_speed'] ? $settings['autoplay_speed'] : '3000';
		$slider_slideshow = $settings['slidetoshow'] ? $settings['slidetoshow'] : '1';
		$slider_infinite = (!empty($settings['infinite']) and $settings['infinite'] == 'yes') ? true : false;
		$slider_fade = (!empty($settings['fade']) and $settings['fade'] == 'yes') ? true : false;

		switch ($settings['navigation']) {
			case 'none':
				$slider_arrows = false;
				$slider_dots = false;
				break;
			case 'arrow':
				$slider_arrows = true;
				$slider_dots = false;
				break;
			case 'dots':
				$slider_arrows = false;
				$slider_dots = true;
				break;
			case 'both':
				$slider_arrows = true;
				$slider_dots = true;
				break;
		}

		$slider_settings = array(
			'id' => $slider_id,
			'autoplay' => $slider_autoplay,
			'arrows' => $slider_arrows,
			'dots' => $slider_dots,
			'fade' => $slider_fade,
			'autoplaySpeed' => $slider_playspeed,
			'slidesToShow' => $slider_slideshow,
			'infinite' => $slider_infinite,
		);


		if (empty($settings['slides'])) {
			return;
		}

?>

		<?php if ($settings['design_style'] === 'style_5') :

			// button
			$this->add_render_attribute('button', 'class', 'btn btn--blue white-color');
			$this->add_render_attribute('button', 'data-animation', 'fadeInLeft');
			$this->add_render_attribute('button', 'data-delay', '.6s');
			$this->add_render_attribute('button', 'data-duration', '.5s');
		?>

			<section class="hero position-relative  slider-settings"
				data-settings="<?php print json_encode($slider_settings); ?>">
				<div class="hero--active">
					<?php foreach ($settings['slides'] as $slide) :
						if (!empty($slide['image']['id'])) {
							$image = wp_get_attachment_image_url($slide['image']['id'], 'full');
						}

						$this->add_render_attribute('button', 'href', $slide['button_link']['url']);
						$this->add_render_attribute('button2', 'href', $slide['button2_link']['url']);
					?>
						<div class="hero-single hero__padding hero__padding--h5" data-overlay="hard-blue" data-opacity="5"
							style="background-image: url(<?php print esc_url($image); ?>);">
							<div class="hero__shape--h5">
								<?php if (!empty($slide['shape_title'])) : ?>
									<h1 class="shape shape1">
										<?php echo bdevs_element_kses_basic($slide['shape_title']); ?>
									</h1>
								<?php endif; ?>
							</div>
							<div class="container">
								<div class="row">
									<div class="col-lg-10 offset-lg-1 text-center">
										<div class="hero__caption hero__caption--h5">
											<?php if (!empty($slide['subtitle'])) : ?>
												<h5 class="hero--small-title white-color fw-500" data-animation="fadeInDown"
													data-delay=".2s">
													<span></span>
													<?php echo bdevs_element_kses_basic($slide['subtitle']); ?>
													<span></span>
												</h5>
											<?php endif; ?>

											<?php if (!empty($slide['title'])) : ?>
												<h1 class="hero--big-title white-color fw-700" data-animation="fadeInDown"
													data-delay=".4s">
													<?php echo bdevs_element_kses_basic($slide['title']); ?>
												</h1>
											<?php endif; ?>

											<!-- button one  -->
											<?php if ($slide['button_text'] && ((empty($slide['button_selected_icon']) || empty($slide['button_selected_icon']['value'])) && empty($slide['button_icon']))) :
												printf(
													'<a %1$s href="%3$s">%2$s</a>',
													$this->get_render_attribute_string('button'),
													esc_html($slide['button_text']),
													esc_url($slide['button_link']['url'])
												);
											elseif (empty($slide['button_text']) && (!(empty($slide['button_selected_icon']) || empty($slide['button_selected_icon']['value'])) || !empty($slide['button_icon']))) : ?>
												<a <?php $this->print_render_attribute_string('button'); ?>><?php bdevs_element_render_icon($slide, 'button_icon', 'button_selected_icon'); ?></a>
												<?php elseif ($slide['button_text'] && (!(empty($slide['button_selected_icon']) || empty($slide['button_selected_icon']['value'])) || !empty($slide['button_icon']))) :
												if ($slide['button_icon_position'] === 'before') :
													$this->add_render_attribute('button', 'class', 'bt-btn btn-h-white bdevs-btn--icon-before');
													$button_text = sprintf('<span %1$s>%2$s</span>', $this->get_render_attribute_string('button_text'), esc_html($slide['button_text']));
												?>
													<a <?php $this->print_render_attribute_string('button'); ?>><?php bdevs_element_render_icon($slide, 'button_icon', 'button_selected_icon', ['class' => 'bdevs-btn-icon']); ?><?php echo $button_text; ?></a>
												<?php
												else :
													$this->add_render_attribute('button', 'class', 'bt-btn btn-h-white bdevs-btn--icon-after');
													$button_text = sprintf('<span %1$s>%2$s</span>', $this->get_render_attribute_string('button_text'), esc_html($slide['button_text']));
												?>
													<a <?php $this->print_render_attribute_string('button'); ?>><?php echo $button_text; ?><?php bdevs_element_render_icon($slide, 'button_icon', 'button_selected_icon', ['class' => 'bdevs-btn-icon']); ?></a>
											<?php
												endif;
											endif; ?>
										</div>
									</div>
								</div>
							</div>
						</div>
					<?php endforeach; ?>
				</div>
			</section>

		<?php elseif ($settings['design_style'] === 'style_4') :
			// button
			$this->add_render_attribute('button', 'class', 'btn btn--white theme-color');
			$this->add_render_attribute('button', 'data-animation', 'fadeInLeft');
			$this->add_render_attribute('button', 'data-delay', '.6s');
			$this->add_render_attribute('button', 'data-duration', '.5s');
		?>

			<section class="hero position-relative  slider-settings"
				data-settings="<?php print json_encode($slider_settings); ?>">
				<div class="hero--active">
					<?php foreach ($settings['slides'] as $slide) :
						if (!empty($slide['image']['id'])) {
							$image = wp_get_attachment_image_url($slide['image']['id'], 'full');
						}

						$this->add_render_attribute('button', 'href', $slide['button_link']['url']);
						$this->add_render_attribute('button2', 'href', $slide['button2_link']['url']);
					?>
						<div class="hero-single hero__padding hero__padding--h4 position-relative"
							style="background-image: url(<?php print esc_url($image); ?>)" data-overlay="theme"
							data-opacity="75">
							<div class="hero__overlay"
								style="background-image: url(<?php echo get_template_directory_uri(); ?>/assets/images/overlay/h4-overlay-img.png)"></div>
							<div class="container">
								<div class="row align-items-center">
									<div class="col-xl-4 col-lg-6 col-md-6 col-12 mb-30">
										<div class="hero__caption hero__caption--h4">
											<?php if (!empty($slide['title'])) : ?>
												<h1 class="hero--big-title white-color fw-700" data-animation="fadeInDown"
													data-delay=".4s">
													<?php echo bdevs_element_kses_basic($slide['title']); ?>
												</h1>
											<?php endif; ?>
											<?php if (!empty($slide['subtitle'])) : ?>
												<h4 class="hero--big-title white-color fw-400" data-animation="fadeInDown"
													data-delay=".4s">
													<?php echo bdevs_element_kses_basic($slide['subtitle']); ?>
												</h4>
											<?php endif; ?>

											<!-- button one  -->
											<?php if ($slide['button_text'] && ((empty($slide['button_selected_icon']) || empty($slide['button_selected_icon']['value'])) && empty($slide['button_icon']))) :
												printf(
													'<a %1$s href="%3$s">%2$s</a>',
													$this->get_render_attribute_string('button'),
													esc_html($slide['button_text']),
													esc_url($slide['button_link']['url'])
												);
											elseif (empty($slide['button_text']) && (!(empty($slide['button_selected_icon']) || empty($slide['button_selected_icon']['value'])) || !empty($slide['button_icon']))) : ?>
												<a <?php $this->print_render_attribute_string('button'); ?>><?php bdevs_element_render_icon($slide, 'button_icon', 'button_selected_icon'); ?></a>
												<?php elseif ($slide['button_text'] && (!(empty($slide['button_selected_icon']) || empty($slide['button_selected_icon']['value'])) || !empty($slide['button_icon']))) :
												if ($slide['button_icon_position'] === 'before') :
													$this->add_render_attribute('button', 'class', 'bt-btn btn-h-white bdevs-btn--icon-before');
													$button_text = sprintf('<span %1$s>%2$s</span>', $this->get_render_attribute_string('button_text'), esc_html($slide['button_text']));
												?>
													<a <?php $this->print_render_attribute_string('button'); ?>><?php bdevs_element_render_icon($slide, 'button_icon', 'button_selected_icon', ['class' => 'bdevs-btn-icon']); ?><?php echo $button_text; ?></a>
												<?php
												else :
													$this->add_render_attribute('button', 'class', 'bt-btn btn-h-white bdevs-btn--icon-after');
													$button_text = sprintf('<span %1$s>%2$s</span>', $this->get_render_attribute_string('button_text'), esc_html($slide['button_text']));
												?>
													<a <?php $this->print_render_attribute_string('button'); ?>><?php echo $button_text; ?><?php bdevs_element_render_icon($slide, 'button_icon', 'button_selected_icon', ['class' => 'bdevs-btn-icon']); ?></a>
											<?php
												endif;
											endif; ?>
										</div>
									</div>
									<?php if (!empty($slide['video_url'])): ?>
										<div class="col-xl-8 col-lg-6 col-md-6 mb-30">
											<div class="hero__play">
												<a class="popup-video btn--play"
													href="<?php echo $slide['video_url']; ?>">
													<i class="fas fa-play"></i>
												</a>
											</div>
										</div>
									<?php endif; ?>
								</div>
							</div>
						</div>
					<?php endforeach; ?>
				</div>
			</section>


		<?php elseif ($settings['design_style'] === 'style_3') :

			// button
			$this->add_render_attribute('button', 'class', 'btn btn--blue white-color');
			$this->add_render_attribute('button', 'data-animation', 'fadeInLeft');
			$this->add_render_attribute('button', 'data-delay', '.6s');
			$this->add_render_attribute('button', 'data-duration', '.5s');

			// button 2
			$this->add_render_attribute('button2', 'class', 'btn btn--white theme-color');
			$this->add_render_attribute('button2', 'data-animation', 'fadeInRight');
			$this->add_render_attribute('button2', 'data-delay', '.8s');
			$this->add_render_attribute('button2', 'data-duration', '.5s');

		?>

			<section class="hero position-relative slider-settings"
				data-settings="<?php print json_encode($slider_settings); ?>">
				<div class="hero--active">
					<?php foreach ($settings['slides'] as $slide) :
						if (!empty($slide['image']['id'])) {
							$image = wp_get_attachment_image_url($slide['image']['id'], 'full');
						}

						$this->add_render_attribute('button', 'href', $slide['button_link']['url']);
						$this->add_render_attribute('button2', 'href', $slide['button2_link']['url']);
					?>
						<div class="hero-single hero__padding hero__padding--h3"
							style="background-image: url(<?php print esc_url($image); ?>)">
							<div class="container">
								<div class="row">
									<div class="col-sm-12 text-center">
										<div class="hero__caption hero__caption--h3">
											<?php if (!empty($slide['title'])) : ?>
												<h1 class="hero--big-title white-color fw-700" data-animation="fadeInDown"
													data-delay=".4s">
													<?php echo bdevs_element_kses_basic($slide['title']); ?>
												</h1>
											<?php endif; ?>
											<?php if (!empty($slide['subtitle'])) : ?>
												<h2 class="hero--big-title white-color fw-500" data-animation="fadeInDown"
													data-delay=".4s">
													<?php echo bdevs_element_kses_basic($slide['subtitle']); ?>
												</h2>
											<?php endif; ?>

											<!-- button one  -->
											<?php if ($slide['button_text'] && ((empty($slide['button_selected_icon']) || empty($slide['button_selected_icon']['value'])) && empty($slide['button_icon']))) :
												printf(
													'<a %1$s href="%3$s">%2$s</a>',
													$this->get_render_attribute_string('button'),
													esc_html($slide['button_text']),
													esc_url($slide['button_link']['url'])
												);
											elseif (empty($slide['button_text']) && (!(empty($slide['button_selected_icon']) || empty($slide['button_selected_icon']['value'])) || !empty($slide['button_icon']))) : ?>
												<a <?php $this->print_render_attribute_string('button'); ?>><?php bdevs_element_render_icon($slide, 'button_icon', 'button_selected_icon'); ?></a>
												<?php elseif ($slide['button_text'] && (!(empty($slide['button_selected_icon']) || empty($slide['button_selected_icon']['value'])) || !empty($slide['button_icon']))) :
												if ($slide['button_icon_position'] === 'before') :
													$this->add_render_attribute('button', 'class', 'bt-btn btn-h-white bdevs-btn--icon-before');
													$button_text = sprintf('<span %1$s>%2$s</span>', $this->get_render_attribute_string('button_text'), esc_html($slide['button_text']));
												?>
													<a <?php $this->print_render_attribute_string('button'); ?>><?php bdevs_element_render_icon($slide, 'button_icon', 'button_selected_icon', ['class' => 'bdevs-btn-icon']); ?><?php echo $button_text; ?></a>
												<?php
												else :
													$this->add_render_attribute('button', 'class', 'bt-btn btn-h-white bdevs-btn--icon-after');
													$button_text = sprintf('<span %1$s>%2$s</span>', $this->get_render_attribute_string('button_text'), esc_html($slide['button_text']));
												?>
													<a <?php $this->print_render_attribute_string('button'); ?>><?php echo $button_text; ?><?php bdevs_element_render_icon($slide, 'button_icon', 'button_selected_icon', ['class' => 'bdevs-btn-icon']); ?></a>
											<?php
												endif;
											endif; ?>

											<!-- button two  -->
											<?php if ($slide['button2_text'] && ((empty($slide['button2_selected_icon']) || empty($slide['button2_selected_icon']['value'])) && empty($slide['button2_icon']))) :
												printf(
													'<a %1$s href="%3$s">%2$s</a>',
													$this->get_render_attribute_string('button2'),
													esc_html($slide['button2_text']),
													esc_url($slide['button2_link']['url'])
												);
											elseif (empty($slide['button2_text']) && (!(empty($slide['button2_selected_icon']) || empty($slide['button2_selected_icon']['value'])) || !empty($slide['button2_icon']))) : ?>
												<a <?php $this->print_render_attribute_string('button2'); ?>><?php bdevs_element_render_icon($slide, 'button2_icon', 'button2_selected_icon'); ?></a>
												<?php elseif ($slide['button2_text'] && (!(empty($slide['button2_selected_icon']) || empty($slide['button2_selected_icon']['value'])) || !empty($slide['button2_icon']))) :
												if ($slide['button2_icon_position'] === 'before') :
													$this->add_render_attribute('button2', 'class', 'bt-btn btn-h-white bdevs-btn--icon-before2');
													$button2_text = sprintf('<span %1$s>%2$s</span>', $this->get_render_attribute_string('button2_text'), esc_html($slide['button2_text']));
												?>
													<a <?php $this->print_render_attribute_string('button2'); ?>><?php bdevs_element_render_icon($slide, 'button2_icon', 'button2_selected_icon', ['class' => 'bdevs-btn-icon']); ?><?php echo $button2_text; ?></a>
												<?php
												else :
													$this->add_render_attribute('button2', 'class', 'bt-btn btn-h-white bdevs-btn--icon-after2');
													$button2_text = sprintf('<span %1$s>%2$s</span>', $this->get_render_attribute_string('button2_text'), esc_html($slide['button2_text']));
												?>
													<a <?php $this->print_render_attribute_string('button2'); ?>><?php echo $button2_text; ?><?php bdevs_element_render_icon($slide, 'button2_icon', 'button2_selected_icon', ['class' => 'bdevs-btn-icon']); ?></a>
											<?php
												endif;
											endif; ?>

										</div>
									</div>
								</div>
							</div>
						</div>
					<?php endforeach; ?>
				</div>
			</section>

		<?php elseif ($settings['design_style'] === 'style_2') :

			// button
			$this->add_render_attribute('button', 'class', 'btn btn--blue btn--icon white-color');
			$this->add_render_attribute('button', 'data-animation', 'fadeInLeft');
			$this->add_render_attribute('button', 'data-delay', '.6s');
			$this->add_render_attribute('button', 'data-duration', '.5s');

			// button 2
			$this->add_render_attribute('button2', 'class', 'btn btn--blue btn--icon btn--border--round white-color');
			$this->add_render_attribute('button2', 'data-animation', 'fadeInRight');
			$this->add_render_attribute('button2', 'data-delay', '.8s');
			$this->add_render_attribute('button2', 'data-duration', '.5s');
		?>

			<section class="hero position-relative grey-bg fix slider-settings"
				data-settings="<?php print json_encode($slider_settings); ?>">
				<div class="hero__shape--h2 d-none d-xl-block">
					<img src="<?php echo get_template_directory_uri(); ?>/assets/images/shape/hero-shape-h2.png" alt="">
				</div>
				<img src="<?php echo get_template_directory_uri(); ?>/assets/images/shape/h2-hero-shape1.png" alt=""
					class="hero__shape--h2--squre hero__shape--h2--1">
				<img src="<?php echo get_template_directory_uri(); ?>/assets/images/shape/h2-hero-shape2.png" alt=""
					class="hero__shape--h2--squre hero__shape--h2--2">
				<img src="<?php echo get_template_directory_uri(); ?>/assets/images/shape/h2-hero-shape3.png" alt=""
					class="hero__shape--h2--squre hero__shape--h2--3">
				<img src="<?php echo get_template_directory_uri(); ?>/assets/images/shape/h2-hero-shape4.png" alt=""
					class="hero__shape--h2--squre hero__shape--h2--4">
				<div class="hero--active">
					<?php foreach ($settings['slides'] as $slide) :
						if (!empty($slide['image']['id'])) {
							$image = wp_get_attachment_image_url($slide['image']['id'], 'full');
						}

						$this->add_render_attribute('button', 'href', $slide['button_link']['url']);
						$this->add_render_attribute('button2', 'href', $slide['button2_link']['url']);
					?>
						<div class="hero-single hero__padding hero__padding--h2">
							<div class="container-fluid">
								<div class="row align-items-center">
									<div class="col-xl-6 col-lg-7">
										<div class="hero__caption hero__caption--h2">
											<?php if (!empty($slide['title'])) : ?>
												<h1 class="hero--big-title theme-color fw-700" data-animation="fadeInDown"
													data-delay=".4s">
													<?php echo bdevs_element_kses_basic($slide['title']); ?>
												</h1>
											<?php endif; ?>

											<?php if (!empty($slide['subtitle'])) : ?>
												<p><?php echo bdevs_element_kses_basic($slide['subtitle']); ?></p>
											<?php endif; ?>

											<!-- button one  -->
											<?php if ($slide['button_text'] && ((empty($slide['button_selected_icon']) || empty($slide['button_selected_icon']['value'])) && empty($slide['button_icon']))) :
												printf(
													'<a %1$s href="%3$s">%2$s</a>',
													$this->get_render_attribute_string('button'),
													esc_html($slide['button_text']),
													esc_url($slide['button_link']['url'])
												);
											elseif (empty($slide['button_text']) && (!(empty($slide['button_selected_icon']) || empty($slide['button_selected_icon']['value'])) || !empty($slide['button_icon']))) : ?>
												<a <?php $this->print_render_attribute_string('button'); ?>><?php bdevs_element_render_icon($slide, 'button_icon', 'button_selected_icon'); ?></a>
												<?php elseif ($slide['button_text'] && (!(empty($slide['button_selected_icon']) || empty($slide['button_selected_icon']['value'])) || !empty($slide['button_icon']))) :
												if ($slide['button_icon_position'] === 'before') :
													$this->add_render_attribute('button', 'class', 'bt-btn btn-h-white bdevs-btn--icon-before');
													$button_text = sprintf('<span %1$s>%2$s</span>', $this->get_render_attribute_string('button_text'), esc_html($slide['button_text']));
												?>
													<a <?php $this->print_render_attribute_string('button'); ?>><?php bdevs_element_render_icon($slide, 'button_icon', 'button_selected_icon', ['class' => 'bdevs-btn-icon']); ?><?php echo $button_text; ?></a>
												<?php
												else :
													$this->add_render_attribute('button', 'class', 'bt-btn btn-h-white bdevs-btn--icon-after');
													$button_text = sprintf('<span %1$s>%2$s</span>', $this->get_render_attribute_string('button_text'), esc_html($slide['button_text']));
												?>
													<a <?php $this->print_render_attribute_string('button'); ?>><?php echo $button_text; ?><?php bdevs_element_render_icon($slide, 'button_icon', 'button_selected_icon', ['class' => 'bdevs-btn-icon']); ?></a>
											<?php
												endif;
											endif; ?>

											<!-- button two  -->
											<?php if ($slide['button2_text'] && ((empty($slide['button2_selected_icon']) || empty($slide['button2_selected_icon']['value'])) && empty($slide['button2_icon']))) :
												printf(
													'<a %1$s href="%3$s">%2$s</a>',
													$this->get_render_attribute_string('button2'),
													esc_html($slide['button2_text']),
													esc_url($slide['button2_link']['url'])
												);
											elseif (empty($slide['button2_text']) && (!(empty($slide['button2_selected_icon']) || empty($slide['button2_selected_icon']['value'])) || !empty($slide['button2_icon']))) : ?>
												<a <?php $this->print_render_attribute_string('button2'); ?>><?php bdevs_element_render_icon($slide, 'button2_icon', 'button2_selected_icon'); ?></a>
												<?php elseif ($slide['button2_text'] && (!(empty($slide['button2_selected_icon']) || empty($slide['button2_selected_icon']['value'])) || !empty($slide['button2_icon']))) :
												if ($slide['button2_icon_position'] === 'before') :
													$this->add_render_attribute('button2', 'class', 'bt-btn btn-h-white bdevs-btn--icon-before2');
													$button2_text = sprintf('<span %1$s>%2$s</span>', $this->get_render_attribute_string('button2_text'), esc_html($slide['button2_text']));
												?>
													<a <?php $this->print_render_attribute_string('button2'); ?>><?php bdevs_element_render_icon($slide, 'button2_icon', 'button2_selected_icon', ['class' => 'bdevs-btn-icon']); ?><?php echo $button2_text; ?></a>
												<?php
												else :
													$this->add_render_attribute('button2', 'class', 'bt-btn btn-h-white bdevs-btn--icon-after2');
													$button2_text = sprintf('<span %1$s>%2$s</span>', $this->get_render_attribute_string('button2_text'), esc_html($slide['button2_text']));
												?>
													<a <?php $this->print_render_attribute_string('button2'); ?>><?php echo $button2_text; ?><?php bdevs_element_render_icon($slide, 'button2_icon', 'button2_selected_icon', ['class' => 'bdevs-btn-icon']); ?></a>
											<?php
												endif;
											endif; ?>
										</div>
									</div>
									<?php if (!empty($image)): ?>
										<div class="col-xl-6 col-lg-5">
											<div class="hero__thumb">
												<img src="<?php print esc_url($image); ?>" alt="hero image">
											</div>
										</div>
									<?php endif; ?>
								</div>
							</div>
						</div>
					<?php endforeach; ?>
				</div>
			</section>

		<?php else:

			// button
			$this->add_render_attribute('button', 'class', 'btn btn--blue white-color');
			$this->add_render_attribute('button', 'data-animation', 'fadeInLeft');
			$this->add_render_attribute('button', 'data-delay', '.6s');
			$this->add_render_attribute('button', 'data-duration', '.5s');

			// button 2
			$this->add_render_attribute('button2', 'class', 'bt-btn btn--border white-color fw-700');
			$this->add_render_attribute('button2', 'data-animation', 'fadeInRight');
			$this->add_render_attribute('button2', 'data-delay', '.8s');
			$this->add_render_attribute('button2', 'data-duration', '.5s');
		?>

			<section class="hero position-relative slider-settings slider-arrow slider-dots"
				data-settings='<?php print json_encode($slider_settings); ?>'>
				<div class="hero--active">
					<?php foreach ($settings['slides'] as $slide) :
						if (!empty($slide['image']['id'])) {
							$image = wp_get_attachment_image_url($slide['image']['id'], 'full');
						}
					?>
						<div class="hero-single hero__padding" data-overlay="dark" data-opacity="4"
							style="background-image: url(<?php print esc_url($image); ?>)">

							<?php if (!empty($settings['shape_switch'])) : ?>
								<div class="hero__shape"></div>
							<?php endif; ?>

							<div class="container">
								<div class="row">
									<div class="col-lg-8 offset-lg-2 text-center">
										<div class="hero__caption">

											<?php if (!empty($slide['subtitle'])) : ?>
												<h5 class="hero--small-title white-color fw-500" data-animation="fadeInDown"
													data-delay=".2s">
													<span></span><?php echo bdevs_element_kses_basic($slide['subtitle']); ?>
													<span></span>
												</h5>
											<?php endif; ?>

											<?php if (!empty($slide['title'])) : ?>
												<h1 class="hero--big-title white-color fw-700" data-animation="fadeInDown"
													data-delay=".4s">
													<?php echo bdevs_element_kses_basic($slide['title']); ?>
												</h1>
											<?php endif; ?>

											<!-- button one  -->
											<?php if ($slide['button_text'] && ((empty($slide['button_selected_icon']) || empty($slide['button_selected_icon']['value'])) && empty($slide['button_icon']))) :
												printf(
													'<a %1$s href="%3$s">%2$s</a>',
													$this->get_render_attribute_string('button'),
													esc_html($slide['button_text']),
													esc_url($slide['button_link']['url'])
												);
											elseif (empty($slide['button_text']) && (!(empty($slide['button_selected_icon']) || empty($slide['button_selected_icon']['value'])) || !empty($slide['button_icon']))) : ?>
												<a <?php $this->print_render_attribute_string('button'); ?>><?php bdevs_element_render_icon($slide, 'button_icon', 'button_selected_icon'); ?></a>
												<?php elseif ($slide['button_text'] && (!(empty($slide['button_selected_icon']) || empty($slide['button_selected_icon']['value'])) || !empty($slide['button_icon']))) :
												if ($slide['button_icon_position'] === 'before') :
													$this->add_render_attribute('button', 'class', 'bt-btn btn-h-white bdevs-btn--icon-before');
													$button_text = sprintf('<span %1$s>%2$s</span>', $this->get_render_attribute_string('button_text'), esc_html($slide['button_text']));
												?>
													<a <?php $this->print_render_attribute_string('button'); ?>><?php bdevs_element_render_icon($slide, 'button_icon', 'button_selected_icon', ['class' => 'bdevs-btn-icon']); ?><?php echo $button_text; ?></a>
												<?php
												else :
													$this->add_render_attribute('button', 'class', 'bt-btn btn-h-white bdevs-btn--icon-after');
													$button_text = sprintf('<span %1$s>%2$s</span>', $this->get_render_attribute_string('button_text'), esc_html($slide['button_text']));
												?>
													<a <?php $this->print_render_attribute_string('button'); ?>><?php echo $button_text; ?><?php bdevs_element_render_icon($slide, 'button_icon', 'button_selected_icon', ['class' => 'bdevs-btn-icon']); ?></a>
											<?php
												endif;
											endif; ?>

											<!-- button two  -->
											<?php if ($slide['button2_text'] && ((empty($slide['button2_selected_icon']) || empty($slide['button2_selected_icon']['value'])) && empty($slide['button2_icon']))) :
												printf(
													'<a %1$s href="%3$s">%2$s</a>',
													$this->get_render_attribute_string('button2'),
													esc_html($slide['button2_text']),
													esc_url($slide['button2_link']['url'])
												);
											elseif (empty($slide['button2_text']) && (!(empty($slide['button2_selected_icon']) || empty($slide['button2_selected_icon']['value'])) || !empty($slide['button2_icon']))) : ?>
												<a <?php $this->print_render_attribute_string('button2'); ?>><?php bdevs_element_render_icon($slide, 'button2_icon', 'button2_selected_icon'); ?></a>
												<?php elseif ($slide['button2_text'] && (!(empty($slide['button2_selected_icon']) || empty($slide['button2_selected_icon']['value'])) || !empty($slide['button2_icon']))) :
												if ($slide['button2_icon_position'] === 'before') :
													$this->add_render_attribute('button2', 'class', 'bt-btn btn-h-white bdevs-btn--icon-before2');
													$button2_text = sprintf('<span %1$s>%2$s</span>', $this->get_render_attribute_string('button2_text'), esc_html($slide['button2_text']));
												?>
													<a <?php $this->print_render_attribute_string('button2'); ?>><?php bdevs_element_render_icon($slide, 'button2_icon', 'button2_selected_icon', ['class' => 'bdevs-btn-icon']); ?><?php echo $button2_text; ?></a>
												<?php
												else :
													$this->add_render_attribute('button2', 'class', 'bt-btn btn-h-white bdevs-btn--icon-after2');
													$button2_text = sprintf('<span %1$s>%2$s</span>', $this->get_render_attribute_string('button2_text'), esc_html($slide['button2_text']));
												?>
													<a <?php $this->print_render_attribute_string('button2'); ?>><?php echo $button2_text; ?><?php bdevs_element_render_icon($slide, 'button2_icon', 'button2_selected_icon', ['class' => 'bdevs-btn-icon']); ?></a>
											<?php
												endif;
											endif; ?>

										</div>
									</div>
								</div>
							</div>
						</div>
					<?php endforeach; ?>
				</div>
			</section>

		<?php endif; ?>

<?php
	}
}
