<?php

namespace BdevsElement\Widget;

use Elementor\Control_Media;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Core\Schemes\Typography;
use \Elementor\Repeater;
use \Elementor\Utils;

defined('ABSPATH') || die();

class Services_Tab extends BDevs_El_Widget
{

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Element widget name.
	 *
	 * @return string Widget name.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_name()
	{
		return 'services_tab';
	}

	/**
	 * Get widget title.
	 *
	 * @return string Widget title.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_title()
	{
		return __('Services TAB', 'bdevselement');
	}

	public function get_custom_help_url()
	{
		return 'http://elementor.bdevs.net//widgets/contact-7-form/';
	}

	/**
	 * Get widget icon.
	 *
	 * @return string Widget icon.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_icon()
	{
		return 'eicon-favorite';
	}

	public function get_keywords()
	{
		return ['services', 'tab'];
	}

	protected function register_content_controls()
	{

		$this->start_controls_section(
			'_section_design_title',
			[
				'label' => __('Design Style', 'bdevselement'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'design_style',
			[
				'label' => __('Design Style', 'bdevselement'),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'style_1' => __('Style 1', 'bdevselement'),
					'style_2' => __('Style 2', 'bdevselement'),
					'style_3' => __('Style 3', 'bdevselement'),
					'style_4' => __('Style 4', 'bdevselement'),
					'style_5' => __('Style 5', 'bdevselement'),
					'style_6' => __('Style 6', 'bdevselement'),
					'style_7' => __('Style 7', 'bdevselement'),
					'style_8' => __('Style 8', 'bdevselement'),
					'style_9' => __('Style 9', 'bdevselement'),
					'style_10' => __('Style 10', 'bdevselement'),
					'style_11' => __('Style 11', 'bdevselement'),
				],
				'default' => 'style_1',
				'frontend_available' => true,
				'style_transfer' => true,
			]
		);

		$this->add_responsive_control(
			'padding_top',
			[
				'label' => __('Padding Top', 'bdevselement'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 5,
					]
				],
				'selectors' => [
					'{{WRAPPER}} .section-padding-wrap' => 'padding-top: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'design_style' => ['style_1']
				]
			]
		);

		$this->add_responsive_control(
			'padding_bottom',
			[
				'label' => __('Padding Bottom', 'bdevselement'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 5,
					]
				],
				'selectors' => [
					'{{WRAPPER}} .section-padding-wrap' => 'padding-bottom: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'design_style' => ['style_1']
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'_section_title',
			[
				'label' => __('Title & Description', 'bdevselement'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'sub_title',
			[
				'label' => __('Sub Title', 'bdevselement'),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => __('bdevs Info Box Sub Title', 'bdevselement'),
				'placeholder' => __('Type Info Box Sub Title', 'bdevselement'),
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->add_control(
			'title',
			[
				'label' => __('Title', 'bdevselement'),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => __('bdevs Info Box Title', 'bdevselement'),
				'placeholder' => __('Type Info Box Title', 'bdevselement'),
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->add_control(
			'description',
			[
				'label' => __('Description', 'bdevselement'),
				'label_block' => true,
				'type' => Controls_Manager::TEXTAREA,
				'placeholder' => __('Type Info Box Title', 'bdevselement'),
				'condition' => [
					'design_style' => ['style_3'],
				],
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->add_control(
			'section_image',
			[
				'label' => __('Image', 'bdevselement'),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->add_control(
			'section_image_shape',
			[
				'label' => __('Shape Image', 'bdevselement'),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'condition' => [
					'design_style' => ['style_1'],
				],
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->add_control(
			'video_url',
			[
				'label' => __('Video URL', 'bdevselement'),
				'type' => Controls_Manager::TEXT,
				'default' => '#',
				'placeholder' => __('video url', 'bdevselement'),
				'label_block' => true,
				'condition' => [
					'design_style' => ['style_6'],
				],
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'_section_slides',
			[
				'label' => __('Slides', 'bdevselement'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'field_condition',
			[
				'label' => __('Field condition', 'bdevselement'),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'style_1' => __('Style 1', 'bdevselement'),
					'style_2' => __('Style 2', 'bdevselement'),
					'style_3' => __('Style 3', 'bdevselement'),
					'style_4' => __('Style 4', 'bdevselement'),
					'style_5' => __('Style 5', 'bdevselement'),
					'style_6' => __('Style 6', 'bdevselement'),
					'style_7' => __('Style 7', 'bdevselement'),
					'style_8' => __('Style 8', 'bdevselement'),
					'style_9' => __('Style 9', 'bdevselement'),
					'style_10' => __('Style 10', 'bdevselement'),
				],
				'default' => 'style_1',
				'frontend_available' => true,
				'style_transfer' => true,
			]
		);

		$repeater->add_control(
			'image',
			[
				'label' => __('Image', 'bdevselement'),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'condition' => [
					'field_condition' => ['style_5', 'style_6', 'style_8'],
				],
				'dynamic' => [
					'active' => true,
				]
			]
		);

		if (bdevs_element_is_elementor_version('<', '2.6.0')) {
			$repeater->add_control(
				'icon',
				[
					'label' => __('Icon', 'bdevselement'),
					'label_block' => true,
					'type' => Controls_Manager::ICON,
					'options' => bdevs_element_get_bdevs_element_icons(),
					'default' => 'fa fa-smile-o'
				]
			);
		} else {
			$repeater->add_control(
				'selected_icon',
				[
					'type' => Controls_Manager::ICONS,
					'fa4compatibility' => 'icon',
					'label_block' => true,
					'default' => [
						'value' => 'fas fa-smile-wink',
						'library' => 'fa-solid',
					]
				]
			);
		}

		$repeater->add_control(
			'tab_num',
			[
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'label' => __('Tab Number', 'bdevselement'),
				'placeholder' => __('Type title here', 'bdevselement'),
				'condition' => [
					'field_condition' => ['style_3'],
				],
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$repeater->add_control(
			'tab_title',
			[
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'label' => __('Tab Title', 'bdevselement'),
				'default' => __('Tab Title', 'bdevselement'),
				'placeholder' => __('Type title here', 'bdevselement'),
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$repeater->add_control(
			'tab_title_url',
			[
				'label' => __('Title URL', 'bdevselement'),
				'type' => Controls_Manager::TEXT,
				'default' => '#',
				'placeholder' => __('button url', 'bdevselement'),
				'label_block' => true,
				'condition' => [
					'field_condition' => ['style_5'],
				],
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$repeater->add_control(
			'tab_content_info',
			[
				'type' => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'show_label' => true,
				'default' => __('Content Here', 'bdevselement'),
				'placeholder' => __('Type subtitle here', 'bdevselement'),
				'dynamic' => [
					'active' => true,
				]
			]
		);


		// Button
		$repeater->add_control(
			'button_text',
			[
				'label' => __('Button Text', 'bdevselement'),
				'type' => Controls_Manager::TEXT,
				'default' => 'Learn More',
				'placeholder' => __('Type button text here', 'bdevselement'),
				'label_block' => true,
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$repeater->add_control(
			'button_url',
			[
				'label' => __('Button URL', 'bdevselement'),
				'type' => Controls_Manager::TEXT,
				'default' => '#',
				'placeholder' => __('button url', 'bdevselement'),
				'label_block' => true,
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$repeater->add_control(
			'large',
			[
				'label' => __('Large', 'bdevselement'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __('Yes', 'bdevselement'),
				'label_off' => __('No', 'bdevselement'),
				'return_value' => 'yes',
				'default' => 'No',
				'frontend_available' => true,
				'condition' => [
					'field_condition' => ['style_5'],
				],
			]
		);


		// REPEATER
		$this->add_control(
			'slides',
			[
				'show_label' => false,
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '<# print(tab_title || "Carousel Item"); #>',
				'default' => [
					[
						'image' => [
							'url' => Utils::get_placeholder_image_src(),
						],
					],
					[
						'image' => [
							'url' => Utils::get_placeholder_image_src(),
						],
					],
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'_section_profile',
			[
				'label' => __('Lists', 'bdevselement'),
				'tab' => Controls_Manager::TAB_CONTENT,
				'condition' => [
					'design_style' => ['style_6', 'style_11'],
				],
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'field_condition',
			[
				'label' => __('Field condition', 'bdevselement'),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'style_1' => __('Style 1', 'bdevselement'),
					'style_2' => __('Style 2', 'bdevselement')
				],
				'default' => 'style_1',
				'frontend_available' => true,
				'style_transfer' => true,
			]
		);

		$repeater->add_control(
			'image',
			[
				'label' => __('Image', 'bdevselement'),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'condition' => [
					'field_condition' => ['style_2'],
				],
				'dynamic' => [
					'active' => true,
				]
			]
		);

		if (bdevs_element_is_elementor_version('<', '2.6.0')) {
			$repeater->add_control(
				'icon',
				[
					'label' => __('Icon', 'bdevselement'),
					'label_block' => true,
					'type' => Controls_Manager::ICON,
					'options' => bdevs_element_get_bdevs_element_icons(),
					'default' => 'fa fa-smile-o'
				]
			);
		} else {
			$repeater->add_control(
				'selected_icon',
				[
					'type' => Controls_Manager::ICONS,
					'fa4compatibility' => 'icon',
					'label_block' => true,
					'default' => [
						'value' => 'fas fa-smile-wink',
						'library' => 'fa-solid',
					]
				]
			);
		}

		$repeater->add_control(
			'number',
			[
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'label' => __('Tab Title', 'bdevselement'),
				'default' => __('Tab Title', 'bdevselement'),
				'placeholder' => __('Type title here', 'bdevselement'),
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$repeater->add_control(
			'title',
			[
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'label' => __('Tab Title', 'bdevselement'),
				'default' => __('Tab Title', 'bdevselement'),
				'placeholder' => __('Type title here', 'bdevselement'),
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$repeater->add_control(
			'content',
			[
				'type' => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'show_label' => true,
				'default' => __('Content Here', 'bdevselement'),
				'placeholder' => __('Type subtitle here', 'bdevselement'),
				'dynamic' => [
					'active' => true,
				]
			]
		);

		// REPEATER
		$this->add_control(
			'services',
			[
				'show_label' => false,
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '<# print(title || "Services Item"); #>',
			]
		);

		$this->end_controls_section();


		$this->start_controls_section(
			'_section_button',
			[
				'label' => __('Button', 'bdevselement'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'button_text',
			[
				'label' => __('Text', 'bdevselement'),
				'type' => Controls_Manager::TEXT,
				'default' => __('Button Text', 'bdevselement'),
				'placeholder' => __('Type button text here', 'bdevselement'),
				'label_block' => true,
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->add_control(
			'button_link',
			[
				'label' => __('Link', 'bdevselement'),
				'type' => Controls_Manager::URL,
				'placeholder' => __('http://elementor.bdevs.net/', 'bdevselement'),
				'dynamic' => [
					'active' => true,
				]
			]
		);

		if (bdevs_element_is_elementor_version('<', '2.6.0')) {
			$this->add_control(
				'button_icon',
				[
					'label' => __('Icon', 'bdevselement'),
					'label_block' => true,
					'type' => Controls_Manager::ICON,
					'options' => bdevs_element_get_bdevs_element_icons(),
					'default' => 'fa fa-angle-right',
				]
			);

			$condition = ['button_icon!' => ''];
		} else {
			$this->add_control(
				'button_selected_icon',
				[
					'type' => Controls_Manager::ICONS,
					'fa4compatibility' => 'button_icon',
					'label_block' => true,
				]
			);
			$condition = ['button_selected_icon[value]!' => ''];
		}

		$this->add_control(
			'button_icon_position',
			[
				'label' => __('Icon Position', 'bdevselement'),
				'type' => Controls_Manager::CHOOSE,
				'label_block' => false,
				'options' => [
					'before' => [
						'title' => __('Before', 'bdevselement'),
						'icon' => 'eicon-h-align-left',
					],
					'after' => [
						'title' => __('After', 'bdevselement'),
						'icon' => 'eicon-h-align-right',
					],
				],
				'default' => 'after',
				'toggle' => false,
				'condition' => $condition,
				'style_transfer' => true,
			]
		);

		$this->add_control(
			'button_icon_spacing',
			[
				'label' => __('Icon Spacing', 'bdevselement'),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 10
				],
				'condition' => $condition,
				'selectors' => [
					'{{WRAPPER}} .btn--icon-before .btn-icon' => 'margin-right: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .btn--icon-after .btn-icon' => 'margin-left: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();
	}


	// register_style_controls

	protected function register_style_controls()
	{
		$this->start_controls_section(
			'_section_fields_style',
			[
				'label' => __('Form Fields', 'bdevselement'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'field_width',
			[
				'label' => __('Width', 'bdevselement'),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'unit' => '%',
				],
				'tablet_default' => [
					'unit' => '%',
				],
				'mobile_default' => [
					'unit' => '%',
				],
				'size_units' => ['%', 'px'],
				'range' => [
					'%' => [
						'min' => 1,
						'max' => 100,
					],
					'px' => [
						'min' => 1,
						'max' => 500,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .wpcf7-form-control:not(.wpcf7-submit)' => 'width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .bdevs-cf7-form label' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'field_margin',
			[
				'label' => __('Spacing Bottom', 'bdevselement'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .wpcf7-form-control:not(.wpcf7-submit)' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'field_padding',
			[
				'label' => __('Padding', 'bdevselement'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .wpcf7-form-control:not(.wpcf7-submit)' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'field_border_radius',
			[
				'label' => __('Border Radius', 'bdevselement'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .wpcf7-form-control:not(.wpcf7-submit)' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'hr',
			[
				'type' => Controls_Manager::DIVIDER,
				'style' => 'thick',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'field_typography',
				'label' => __('Typography', 'bdevselement'),
				'selector' => '{{WRAPPER}} .wpcf7-form-control:not(.wpcf7-submit)',
				//'scheme' => Typography::TYPOGRAPHY_3
			]
		);

		$this->add_control(
			'field_color',
			[
				'label' => __('Text Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wpcf7-form-control:not(.wpcf7-submit)' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'field_placeholder_color',
			[
				'label' => __('Placeholder Text Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} ::-webkit-input-placeholder' => 'color: {{VALUE}};',
					'{{WRAPPER}} ::-moz-placeholder' => 'color: {{VALUE}};',
					'{{WRAPPER}} ::-ms-input-placeholder' => 'color: {{VALUE}};',
				],
			]
		);

		$this->start_controls_tabs('tabs_field_state');

		$this->start_controls_tab(
			'tab_field_normal',
			[
				'label' => __('Normal', 'bdevselement'),
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'field_border',
				'selector' => '{{WRAPPER}} .wpcf7-form-control:not(.wpcf7-submit)',
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'field_box_shadow',
				'selector' => '{{WRAPPER}} .wpcf7-form-control:not(.wpcf7-submit)',
			]
		);

		$this->add_control(
			'field_bg_color',
			[
				'label' => __('Background Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wpcf7-form-control:not(.wpcf7-submit)' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_field_focus',
			[
				'label' => __('Focus', 'bdevselement'),
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'field_focus_border',
				'selector' => '{{WRAPPER}} .wpcf7-form-control:not(.wpcf7-submit):focus',
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'field_focus_box_shadow',
				'exclude' => [
					'box_shadow_position',
				],
				'selector' => '{{WRAPPER}} .wpcf7-form-control:not(.wpcf7-submit):focus',
			]
		);

		$this->add_control(
			'field_focus_bg_color',
			[
				'label' => __('Background Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wpcf7-form-control:not(.wpcf7-submit):focus' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();

		$this->end_controls_section();

		$this->start_controls_section(
			'submit',
			[
				'label' => __('Submit Button', 'bdevselement'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'submit_margin',
			[
				'label' => __('Margin', 'bdevselement'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .wpcf7-submit' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'submit_padding',
			[
				'label' => __('Padding', 'bdevselement'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .wpcf7-submit' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'submit_typography',
				'selector' => '{{WRAPPER}} .wpcf7-submit',
				//'scheme' => Typography::TYPOGRAPHY_4
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'submit_border',
				'selector' => '{{WRAPPER}} .wpcf7-submit',
			]
		);

		$this->add_control(
			'submit_border_radius',
			[
				'label' => __('Border Radius', 'bdevselement'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .wpcf7-submit' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'submit_box_shadow',
				'selector' => '{{WRAPPER}} .wpcf7-submit',
			]
		);

		$this->add_control(
			'hr4',
			[
				'type' => Controls_Manager::DIVIDER,
				'style' => 'thick',
			]
		);

		$this->start_controls_tabs('tabs_button_style');

		$this->start_controls_tab(
			'tab_button_normal',
			[
				'label' => __('Normal', 'bdevselement'),
			]
		);

		$this->add_control(
			'submit_color',
			[
				'label' => __('Text Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .wpcf7-submit' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'submit_bg_color',
			[
				'label' => __('Background Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wpcf7-submit' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_button_hover',
			[
				'label' => __('Hover', 'bdevselement'),
			]
		);

		$this->add_control(
			'submit_hover_color',
			[
				'label' => __('Text Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wpcf7-submit:hover, {{WRAPPER}} .wpcf7-submit:focus' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'submit_hover_bg_color',
			[
				'label' => __('Background Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wpcf7-submit:hover, {{WRAPPER}} .wpcf7-submit:focus' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'submit_hover_border_color',
			[
				'label' => __('Border Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wpcf7-submit:hover, {{WRAPPER}} .wpcf7-submit:focus' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();

		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();

		if (empty($settings['slides'])) {
			return;
		}

		// bg_image
		if (!empty($settings['section_image']['id'])) {
			$section_image = wp_get_attachment_image_url($settings['section_image']['id'], 'full');
			$section_image = $settings['section_image']['url'];
		}
		if (!empty($settings['section_image_shape']['id'])) {
			$section_image_shape = wp_get_attachment_image_url($settings['section_image_shape']['id'], 'full');
			$section_image_shape = $settings['section_image_shape']['url'];
		}
?>

		<?php if ($settings['design_style'] === 'style_11'):
			$this->add_inline_editing_attributes('button_text', 'none');
			$this->add_render_attribute('button_text', 'class', 'btn-text');
			$this->add_link_attributes('button', $settings['button_link']);
		?>
			<section class="company-history pt-125">
				<div class="container">
					<div class="row">
						<div class="col-lg-8 offset-lg-2">
							<div class="theme text-center">
								<?php if (!empty($settings['sub_title'])) : ?>
									<span class="theme__small--title fw-700 text-uppercase"><span></span>
										<?php echo bdevs_element_kses_intermediate($settings['sub_title']); ?>
										<span></span></span>
								<?php endif; ?>
								<?php if (!empty($settings['title'])) : ?>
									<h2 class="theme__big--title fw-700 mb-80">
										<?php print bdevs_element_kses_basic($settings['title']); ?>
									</h2>
								<?php endif; ?>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-lg-10 offset-lg-1">
							<div class="row justify-content-between history-row position-relative">
								<div class="col-lg-5 col-md-6">
									<div class="history-col history-col--left">
										<?php foreach ($settings['slides'] as $id => $slide) : ?>
											<div class="history-single mb-145 text-center position-relative">
												<div class="history-thumb">
													<?php if (($slide['image']['url'] || $slide['image']['id'])) :
														$this->add_render_attribute('image', 'src', $slide['image']['url']);
														$this->add_render_attribute('image', 'alt', Control_Media::get_image_alt($slide['image']));
														$this->add_render_attribute('image', 'title', Control_Media::get_image_title($slide['image']));
														$slide['hover_animation'] = 'disable-animation';
													?>
														<?php echo Group_Control_Image_Size::get_attachment_image_html($slide, 'thumbnail', 'image'); ?>
													<?php endif; ?>
													<div class="history-content">
														<?php if (!empty($slide['tab_title'])) : ?>
															<h4>
																<?php echo bdevs_element_kses_basic($slide['tab_title']); ?>
															</h4>
														<?php endif; ?>

														<?php if (!empty($slide['tab_content_info'])) : ?>
															<p><?php echo bdevs_element_kses_basic($slide['tab_content_info']); ?></p>
														<?php endif; ?>
													</div>
												</div>
											</div>
										<?php endforeach; ?>
									</div>
								</div>
								<div class="col-lg-5 col-md-6">
									<div class="history-col history-col--right">
										<?php foreach ($settings['services'] as $service) : ?>
											<div class="history-single mb-145 text-center position-relative">
												<div class="history-thumb">
													<?php if (($service['image']['url'] || $service['image']['id'])) :
														$this->add_render_attribute('image', 'src', $service['image']['url']);
														$this->add_render_attribute('image', 'alt', Control_Media::get_image_alt($service['image']));
														$this->add_render_attribute('image', 'title', Control_Media::get_image_title($service['image']));
														$service['hover_animation'] = 'disable-animation';
													?>
														<?php echo Group_Control_Image_Size::get_attachment_image_html($service, 'thumbnail', 'image'); ?>
													<?php endif; ?>
													<div class="history-content">
														<?php if (!empty($service['title'])) : ?>
															<h4>
																<?php echo bdevs_element_kses_basic($service['title']); ?>
															<?php endif; ?>

															<?php if (!empty($service['content'])) : ?>
																<p><?php echo bdevs_element_kses_basic($service['content']); ?></p>
															<?php endif; ?>
													</div>
												</div>
											</div>
										<?php endforeach; ?>
									</div>
								</div>
								<div class="col-sm-12">
									<?php if (!empty($settings['button_link']['url'])) : ?>
										<div class="histroy-more">
											<a href="<?php echo esc_url($settings['button_link']['url']); ?>">
												<?php echo esc_html($settings['button_text']); ?>
												<i class="fal fa-plus"></i>
											</a>
										</div>
									<?php endif; ?>
								</div>
							</div>
						</div>
					</div>
				</div>
			</section>
		<?php elseif ($settings['design_style'] === 'style_10'):
			$this->add_inline_editing_attributes('button_text', 'none');
			$this->add_render_attribute('button_text', 'class', 'btn-text');
			$this->add_render_attribute('button', 'class', 'btn btn--white theme-color');
			$this->add_link_attributes('button', $settings['button_link']);
		?>
			<section class="service theme-bg position-relative pt-125 pb-100 fix">
				<img class="shape service__shape shape--h4"
					src="<?php echo get_template_directory_uri(); ?>/assets/images/shape/service-h5-shape1.png" alt="img">
				<img class="shape shape--h42"
					src="<?php echo get_template_directory_uri(); ?>/assets/images/shape/service-h5-shape2.png" alt="img">
				<div class="container">
					<div class="row">
						<div class="col-xl-8 offset-xl-2 col-lg-8 offset-lg-2 text-center mb-30">
							<div class="theme">
								<?php if (!empty($settings['sub_title'])) : ?>
									<span class="theme__small--title fw-700 text-uppercase white-color"><span
											class="white-line"></span>
										<?php echo bdevs_element_kses_intermediate($settings['sub_title']); ?>
										<span class="white-line"></span></span>
								<?php endif; ?>
								<?php if (!empty($settings['title'])) : ?>
									<h2 class="theme__big--title fw-700 mb-30 white-color">
										<?php print bdevs_element_kses_basic($settings['title']); ?>
									</h2>
								<?php endif; ?>
							</div>
						</div>
					</div>
					<div class="row">
						<?php foreach ($settings['slides'] as $id => $slide) : ?>
							<div class="col-lg-4 col col-md-6 mb-30">
								<div class="service__block--h6 position-relative">
									<div class="service__content--h5 service__content--h6">
										<?php if (!empty($slide['icon']) || !empty($slide['selected_icon']['value'])) : ?>
											<div class="service__icon--h5 service__icon--h6">
												<?php bdevs_element_render_icon($slide, 'icon', 'selected_icon', ['class' => 'white-color']); ?>
											</div>
										<?php endif; ?>

										<div class="service__text--h5 service__text--h6">
											<?php if (!empty($slide['tab_title'])) : ?>
												<h4 class="fw-600 white-color">
													<?php echo bdevs_element_kses_basic($slide['tab_title']); ?>
												</h4>
											<?php endif; ?>

											<?php if (!empty($slide['tab_content_info'])) : ?>
												<p class="color-text-2"><?php echo bdevs_element_kses_basic($slide['tab_content_info']); ?></p>
											<?php endif; ?>

											<?php if (!empty($slide['button_url'])) : ?>
												<a class="white-color" href="<?php echo esc_url($slide['button_url']); ?>">
													<?php echo esc_html($slide['button_text']); ?> <i
														class="far fa-long-arrow-right"></i>
												</a>
											<?php endif; ?>
										</div>
									</div>
								</div>
							</div>
						<?php endforeach; ?>
					</div>
				</div>
			</section>
		<?php elseif ($settings['design_style'] === 'style_9'): ?>
			<section class="service grey-bg position-relative fix pt-125 pb-100">
				<div class="container">
					<div class="row">
						<div class="col-xl-8 offset-xl-2 col-lg-10 offset-lg-1">
							<div class="theme text-center">
								<?php if (!empty($settings['sub_title'])) : ?>
									<span class="theme__small--title fw-700 text-uppercase"><span></span>
										<?php echo bdevs_element_kses_intermediate($settings['sub_title']); ?>
										<span></span></span>
								<?php endif; ?>
								<?php if (!empty($settings['title'])) : ?>
									<h2 class="theme__big--title fw-700 mb-80">
										<?php print bdevs_element_kses_basic($settings['title']); ?>
									</h2>
								<?php endif; ?>
							</div>
						</div>
					</div>
					<div class="row">
						<?php foreach ($settings['slides'] as $id => $slide) : ?>
							<div class="col-lg-4 col-md-6 col mb-30">
								<div class="securiy-services white-bg position-relative">
									<div class="service__content--h5 service__content--h6">
										<?php if (!empty($slide['icon']) || !empty($slide['selected_icon']['value'])) : ?>
											<div class="service__icon--h5 ">
												<div class="service__icon--h3 service__icon">
													<?php bdevs_element_render_icon($slide, 'icon', 'selected_icon', ['data-aos' => 'zoom-in-down', 'class' => ' aos-init aos-animate']); ?>
												</div>
											</div>
										<?php endif; ?>
										<div class="service__text--h5 service__text--h6">
											<?php if (!empty($slide['tab_title'])) : ?>
												<h4 class="fw-600 ">
													<?php echo bdevs_element_kses_basic($slide['tab_title']); ?>
												</h4>
											<?php endif; ?>

											<?php if (!empty($slide['tab_content_info'])) : ?>
												<p><?php echo bdevs_element_kses_basic($slide['tab_content_info']); ?></p>
											<?php endif; ?>

											<?php if (!empty($slide['button_url'])) : ?>
												<a class="link-more text-uppercase fw-700"
													href="<?php echo esc_url($slide['button_url']); ?>">
													<i class="far fa-long-arrow-right"></i>
												</a>
											<?php endif; ?>
										</div>
									</div>
								</div>
							</div>
						<?php endforeach; ?>
					</div>
				</div>
			</section>
		<?php elseif ($settings['design_style'] === 'style_8'):
			$this->add_inline_editing_attributes('button_text', 'none');
			$this->add_render_attribute('button_text', 'class', 'btn-text');
			$this->add_render_attribute('button', 'class', 'btn btn--white theme-color');
			$this->add_link_attributes('button', $settings['button_link']);
		?>
			<section class="service position-relative fix pb-100">
				<div class="container">
					<div class="row">
						<?php foreach ($settings['slides'] as $id => $slide) : ?>
							<div class="col-lg-4 col-md-6 mb-30 text-center">
								<div class="about-service position-relative white-bg">
									<div class="thumb">
										<?php if (($slide['image']['url'] || $slide['image']['id'])) :
											$this->add_render_attribute('image', 'src', $slide['image']['url']);
											$this->add_render_attribute('image', 'alt', Control_Media::get_image_alt($slide['image']));
											$this->add_render_attribute('image', 'title', Control_Media::get_image_title($slide['image']));
											$slide['hover_animation'] = 'disable-animation';
										?>
											<?php echo Group_Control_Image_Size::get_attachment_image_html($slide, 'thumbnail', 'image'); ?>
										<?php endif; ?>
										<?php if (!empty($slide['icon']) || !empty($slide['selected_icon']['value'])) : ?>
											<div class="icon">
												<?php bdevs_element_render_icon($slide, 'icon', 'selected_icon'); ?>
											</div>
										<?php endif; ?>
									</div>
									<div class="about-service--content">
										<?php if (!empty($slide['tab_title'])) : ?>
											<h4 class="service__title fw-600">
												<?php echo bdevs_element_kses_basic($slide['tab_title']); ?>
											</h4>
										<?php endif; ?>

										<?php if (!empty($slide['tab_content_info'])) : ?>
											<p class="mb-20"><?php echo bdevs_element_kses_basic($slide['tab_content_info']); ?></p>
										<?php endif; ?>

										<?php if (!empty($slide['button_url'])) : ?>
											<a href="<?php echo esc_url($slide['button_url']) ?>"
												class="service__read-more">
												<?php echo esc_html($slide['button_text']) ?> <i
													class="far fa-long-arrow-right"></i>
											</a>
										<?php endif; ?>
									</div>
								</div>
							</div>
						<?php endforeach; ?>
					</div>
				</div>
			</section>
		<?php elseif ($settings['design_style'] === 'style_7'):
			$this->add_inline_editing_attributes('button_text', 'none');
			$this->add_render_attribute('button_text', 'class', 'btn-text');
			$this->add_render_attribute('button', 'class', 'btn btn--white theme-color');
			$this->add_link_attributes('button', $settings['button_link']);
		?>
			<section class="service theme-bg position-relative pt-125 pb-100 fix">
				<img class="shape service__shape shape--h4"
					src="<?php echo get_template_directory_uri(); ?>/assets/images/shape/service-h5-shape1.png" alt="img">
				<img class="shape shape--h42"
					src="<?php echo get_template_directory_uri(); ?>/assets/images/shape/service-h5-shape2.png" alt="img">
				<div class="container">
					<div class="row">
						<div class="col-lg-4 col-md-8 mb-30">
							<div class="theme">
								<?php if (!empty($settings['sub_title'])) : ?>
									<span class="theme__small--title fw-700 text-uppercase white-color theme__small--title-left"><span
											class="white-line"></span>
										<?php echo bdevs_element_kses_intermediate($settings['sub_title']); ?>
									</span>
								<?php endif; ?>
								<?php if (!empty($settings['title'])) : ?>
									<h2 class="theme__big--title fw-700 mb-30 white-color">
										<?php print bdevs_element_kses_basic($settings['title']); ?>
									</h2>
								<?php endif; ?>
								<?php if (!empty($settings['description'])) : ?>
									<p class="color-text-2 mb-40 wd-do">
										<?php print bdevs_element_kses_basic($settings['description']); ?>
									</p>
								<?php endif; ?>
								<?php if ($settings['button_text'] && (empty($settings['button_selected_icon']) && empty($settings['button_icon']))) :
									printf(
										'<a %1$s>%2$s</a>',
										$this->get_render_attribute_string('button'),
										sprintf('<span %1$s>%2$s</span>', $this->get_render_attribute_string('button_text'), esc_html($settings['button_text']))
									);
								elseif (empty($settings['button_text']) && (!empty($settings['button_icon']) || !empty($settings['button_selected_icon']))) : ?>
									<a <?php $this->print_render_attribute_string('button'); ?>><?php bdevs_element_render_icon($settings, 'button_icon', 'button_selected_icon'); ?></a>
									<?php elseif ($settings['button_text'] && (!empty($settings['button_icon']) || !empty($settings['button_selected_icon']))) :
									if ($settings['button_icon_position'] === 'before') :
										$this->add_render_attribute('button', 'class', 'btn--icon-before');
										$button_text = sprintf('<span %1$s>%2$s</span>', $this->get_render_attribute_string('button_text'), esc_html($settings['button_text']));
									?>
										<a <?php $this->print_render_attribute_string('button'); ?>><?php bdevs_element_render_icon($settings, 'button_icon', 'button_selected_icon', ['class' => 'btn-icon']); ?><?php echo $button_text; ?></a>
									<?php
									else :
										$this->add_render_attribute('button', 'class', 'btn--icon-after');
										$button_text = sprintf('<span %1$s>%2$s</span>', $this->get_render_attribute_string('button_text'), esc_html($settings['button_text']));
									?>
										<a <?php $this->print_render_attribute_string('button'); ?>><?php echo $button_text; ?><?php bdevs_element_render_icon($settings, 'button_icon', 'button_selected_icon', ['class' => 'btn-icon']); ?></a>
								<?php
									endif;
								endif; ?>
							</div>
						</div>
						<div class="col-lg-8 mb-30">
							<div class="row service__row--h6">
								<?php foreach ($settings['slides'] as $id => $slide) : ?>
									<div class="col-lg-6 col col-md-6 mb-10">
										<div class="service__block--h6 position-relative">
											<div class="service__content--h5 service__content--h6">
												<?php if (!empty($slide['icon']) || !empty($slide['selected_icon']['value'])) : ?>
													<div class="service__icon--h5 service__icon--h6">
														<?php bdevs_element_render_icon($slide, 'icon', 'selected_icon', ['class' => 'white-color']); ?>
													</div>
												<?php endif; ?>
												<div class="service__text--h5 service__text--h6">
													<?php if (!empty($slide['tab_title'])) : ?>
														<h4 class="fw-600 white-color">
															<?php echo bdevs_element_kses_basic($slide['tab_title']); ?>
														</h4>
													<?php endif; ?>

													<?php if (!empty($slide['tab_content_info'])) : ?>
														<p class="color-text-2"><?php echo bdevs_element_kses_basic($slide['tab_content_info']); ?></p>
													<?php endif; ?>

													<?php if (!empty($slide['button_url'])) : ?>
														<a class="white-color"
															href="<?php echo esc_url($slide['button_url']) ?>">
															<?php echo esc_html($slide['button_text']) ?> <i
																class="far fa-long-arrow-right"></i>
														</a>
													<?php endif; ?>
												</div>
											</div>
										</div>
									</div>
								<?php endforeach; ?>
							</div>
						</div>
					</div>
				</div>
			</section>
		<?php elseif ($settings['design_style'] === 'style_6'): ?>
			<section class="service theme-bg position-relative pt-125 pb-100 fix">
				<img class="shape service__shape shape--h4"
					src="<?php echo get_template_directory_uri(); ?>/assets/images/shape/wwd-shape.png" alt="img">
				<img class="shape shape--h42"
					src="<?php echo get_template_directory_uri(); ?>/assets/images/shape/wwd-squre-shape.png" alt="img">
				<div class="container">
					<div class="row">
						<div class="col-xl-8 offset-xl-2 col-lg-10 offset-lg-1">
							<div class="theme text-center">
								<?php if (!empty($settings['sub_title'])) : ?>
									<span class="theme__small--title fw-700 text-uppercase white-color"><span
											class="white-line"></span>
										<?php echo bdevs_element_kses_intermediate($settings['sub_title']); ?>
										<span class="white-line"></span></span>
								<?php endif; ?>
								<?php if (!empty($settings['title'])) : ?>
									<h2 class="theme__big--title fw-700 mb-80 white-color">
										<?php print bdevs_element_kses_basic($settings['title']); ?>
									</h2>
								<?php endif; ?>
							</div>
						</div>
					</div>
					<div class="row">
						<?php foreach ($settings['slides'] as $id => $slide) : ?>
							<div class="col-lg-4 col-md-6 mb-30">
								<div class="service__block--h5 position-relative white-bg">
									<?php if (($slide['image']['url'] || $slide['image']['id'])) :
										$this->add_render_attribute('image', 'src', $slide['image']['url']);
										$this->add_render_attribute('image', 'alt', Control_Media::get_image_alt($slide['image']));
										$this->add_render_attribute('image', 'title', Control_Media::get_image_title($slide['image']));
										$slide['hover_animation'] = 'disable-animation';
									?>
										<div class="service__thumb--h5 fix">
											<?php echo Group_Control_Image_Size::get_attachment_image_html($slide, 'thumbnail', 'image'); ?>
										</div>
									<?php endif; ?>

									<div class="service__content--h5">
										<?php if (!empty($slide['icon']) || !empty($slide['selected_icon']['value'])) : ?>
											<div class="service__icon--h5">
												<?php bdevs_element_render_icon($slide, 'icon', 'selected_icon'); ?>
											</div>
										<?php endif; ?>

										<div class="service__text--h5">
											<?php if (!empty($slide['tab_title'])) : ?>
												<h4 class="fw-600">
													<?php echo bdevs_element_kses_basic($slide['tab_title']); ?>
												</h4>
											<?php endif; ?>

											<?php if (!empty($slide['tab_content_info'])) : ?>
												<p><?php echo bdevs_element_kses_basic($slide['tab_content_info']); ?></p>
											<?php endif; ?>

											<?php if (!empty($slide['button_url'])) : ?>
												<a href="<?php echo esc_url($slide['button_url']) ?>">
													<i class="far fa-long-arrow-right"></i>
												</a>
											<?php endif; ?>
										</div>
									</div>
								</div>
							</div>
						<?php endforeach; ?>
					</div>
				</div>
				<div class="personal-info pt-100">
					<div class="container">
						<div class="row">
							<?php if (!empty($section_image)): ?>
								<div class="col-lg-5 mb-30">
									<div class="personal-img img position-relative" data-overlay="theme" data-opacity="3">
										<img src="<?php print esc_url($section_image); ?>" alt="img">
										<a class="popup-video btn--play service__play"
											href="<?php echo esc_url($settings['video_url']); ?>" tabindex="0">
											<i class="fas fa-play"></i>
										</a>
									</div>
								</div>
							<?php endif; ?>
							<div class="col-lg-6 offset-lg-1 mb-30">
								<div class="row">
									<?php foreach ($settings['services'] as $id => $service) : ?>
										<div class="col-lg-6 col-md-6 mb-30">
											<div class="statistics__block">
												<?php if (!empty($service['icon']) || !empty($service['selected_icon']['value'])) : ?>
													<span class="white-color fw-600">
														<?php bdevs_element_render_icon($service, 'icon', 'selected_icon'); ?>
														<span class="counter"><?php echo bdevs_element_kses_basic($service['number']); ?></span>
													</span>
												<?php endif; ?>
												<?php if (!empty($service['title'])) : ?>
													<h4 class="white-color mb-10">
														<?php echo bdevs_element_kses_basic($service['title']); ?>
													</h4>
												<?php endif; ?>
												<?php if (!empty($service['content'])) : ?>
													<p class="white-color"><?php echo bdevs_element_kses_basic($service['content']); ?></p>
												<?php endif; ?>
											</div>
										</div>
									<?php endforeach; ?>
								</div>
							</div>
						</div>
					</div>
				</div>
			</section>
		<?php elseif ($settings['design_style'] === 'style_5'): ?>
			<section class="service case position-relative fix">
				<div class="container">
					<div class="row">
						<div class="col-xl-8 offset-xl-2 col-lg-10 offset-lg-1">
							<div class="theme text-center">
								<?php if (!empty($settings['sub_title'])) : ?>
									<span class="theme__small--title fw-700 text-uppercase"><span></span>
										<?php echo bdevs_element_kses_intermediate($settings['sub_title']); ?>
										<span></span></span>
								<?php endif; ?>
								<?php if (!empty($settings['title'])) : ?>
									<h2 class="theme__big--title fw-700 mb-75">
										<?php print bdevs_element_kses_basic($settings['title']); ?>
									</h2>
								<?php endif; ?>
							</div>
						</div>
					</div>
				</div>
				<div class="container-fluid">
					<div class="row">
						<?php foreach ($settings['slides'] as $id => $slide) :

							$slide_class = "col-xl-3 col-lg-6 col-md-6 mb-30";

							if ($slide['large'] == true) {
								$slide_class = "col-xl-6 col-lg-6 col-md-6 mb-30";
							}
						?>
							<div class="<?php echo esc_attr($slide_class); ?>">
								<div class="service__block--h2 position-relative">
									<?php if (($slide['image']['url'] || $slide['image']['id'])) :
										$this->add_render_attribute('image', 'src', $slide['image']['url']);
										$this->add_render_attribute('image', 'alt', Control_Media::get_image_alt($slide['image']));
										$this->add_render_attribute('image', 'title', Control_Media::get_image_title($slide['image']));
										$slide['hover_animation'] = 'disable-animation'; // hack to prevent image hover animation
									?>
										<div class="service__thumb--h2 fix">
											<?php echo Group_Control_Image_Size::get_attachment_image_html($slide, 'thumbnail', 'image'); ?>
										</div>
									<?php endif; ?>

									<div class="service__content--h2">
										<div class="icon">
											<?php if (!empty($slide['icon']) || !empty($slide['selected_icon']['value'])) : ?>
												<?php bdevs_element_render_icon($slide, 'icon', 'selected_icon', ['class' => ' white-color']); ?>
											<?php endif; ?>
										</div>
										<?php if (!empty($slide['tab_title'])) : ?>
											<h4 class="white-color hover-color-light">
												<a href="<?php echo esc_url($slide['tab_title_url']); ?>">
													<?php echo bdevs_element_kses_basic($slide['tab_title']); ?>
												</a>
											</h4>
										<?php endif; ?>

										<?php if (!empty($slide['tab_content_info'])) : ?>
											<p><?php echo bdevs_element_kses_basic($slide['tab_content_info']); ?></p>
										<?php endif; ?>

										<?php if (!empty($slide['button_url'])) : ?>
											<a href="<?php echo esc_url($slide['button_url']) ?>">
												<i class="fal fa-long-arrow-right white-color"></i>
											</a>
										<?php endif; ?>
									</div>
								</div>
							</div>
						<?php endforeach; ?>
					</div>
				</div>
			</section>
		<?php elseif ($settings['design_style'] === 'style_4'): ?>
			<section class="service position-relative fix pt-125">
				<div class="container">
					<div class="row">
						<div class="col-xl-8 offset-xl-2 col-lg-10 offset-lg-1">
							<div class="theme text-center">
								<?php if (!empty($settings['sub_title'])) : ?>
									<span class="theme__small--title fw-700 text-uppercase"><span></span>
										<?php echo bdevs_element_kses_intermediate($settings['sub_title']); ?>
										<span></span></span>
								<?php endif; ?>
								<?php if (!empty($settings['title'])) : ?>
									<h2 class="theme__big--title fw-700 mb-80">
										<?php print bdevs_element_kses_basic($settings['title']); ?>
									</h2>
								<?php endif; ?>
							</div>
						</div>
					</div>
					<div class="row">
						<?php foreach ($settings['slides'] as $id => $slide) : ?>
							<div class="col-lg-4 col-md-6 mb-30 text-center">
								<div class="service__block service__block--h4 position-relative white-bg">
									<?php if (!empty($slide['icon']) || !empty($slide['selected_icon']['value'])) : ?>
										<?php bdevs_element_render_icon($slide, 'icon', 'selected_icon', ['data-aos' => 'zoom-in-down', 'class' => 'service__icon--h4 aos-init aos-animate']); ?>
									<?php endif; ?>

									<?php if (!empty($slide['tab_title'])) : ?>
										<h4 class="service__title fw-600">
											<?php echo bdevs_element_kses_basic($slide['tab_title']); ?>
										</h4>
									<?php endif; ?>

									<?php if (!empty($slide['tab_content_info'])) : ?>
										<p><?php echo bdevs_element_kses_basic($slide['tab_content_info']); ?></p>
									<?php endif; ?>
									<?php if (!empty($slide['button_url'])) : ?>
										<a href="<?php echo esc_url($slide['button_url']) ?>"
											class="service__link--h4 text-uppercase fw-700">
											<i class="far fa-arrow-right"></i>
										</a>
									<?php endif; ?>
								</div>
							</div>
						<?php endforeach; ?>
					</div>
				</div>
			</section>
		<?php elseif ($settings['design_style'] === 'style_3'): ?>
			<section class="work pt-125 pb-85">
				<div class="container">
					<div class="row">
						<div class="col-xl-6 offset-xl-3 col-lg-10 offset-lg-1">
							<div class="theme text-center">
								<?php if (!empty($settings['sub_title'])) : ?>
									<span class="theme__small--title fw-700 text-uppercase"><span></span>
										<?php echo bdevs_element_kses_intermediate($settings['sub_title']); ?>
										<span></span></span>
								<?php endif; ?>
								<?php if (!empty($settings['title'])) : ?>
									<h2 class="theme__big--title fw-700 mb-90">
										<?php print bdevs_element_kses_basic($settings['title']); ?>
									</h2>
								<?php endif; ?>
							</div>
						</div>
					</div>
					<div class="row justify-content-between">
						<?php foreach ($settings['slides'] as $id => $slide) : ?>
							<div class="col-lg-3 col-md-6 text-center mb-30 aos-init aos-animate" data-aos="fade-right"
								data-aos-easing="ease-in-sine" data-aos-duration="9000">
								<div class="work__block">
									<div class="icon">
										<?php if (!empty($slide['icon']) || !empty($slide['selected_icon']['value'])) : ?>
											<div class="service__icon service__icon--h3">
												<?php bdevs_element_render_icon($slide, 'icon', 'selected_icon', ['data-aos' => 'zoom-in-down', 'class' => ' aos-init aos-animate']); ?>
											</div>
										<?php endif; ?>

										<?php if (!empty($slide['tab_num'])): ?>
											<span><?php echo bdevs_element_kses_basic($slide['tab_num']); ?></span>
										<?php endif; ?>
									</div>

									<?php if (!empty($slide['tab_title'])) : ?>
										<h4>
											<?php echo bdevs_element_kses_basic($slide['tab_title']); ?>
										</h4>
									<?php endif; ?>

									<?php if (!empty($slide['tab_content_info'])) : ?>
										<p><?php echo bdevs_element_kses_basic($slide['tab_content_info']); ?></p>
									<?php endif; ?>

									<?php if (!empty($slide['button_url'])) : ?>
										<a href="<?php echo esc_url($slide['button_url']); ?>"><?php echo bdevs_element_kses_basic($slide['button_text']); ?>
											<i class="fal fa-long-arrow-right"></i></a>
									<?php endif; ?>
								</div>
							</div>
						<?php endforeach; ?>
					</div>
				</div>
			</section>
		<?php elseif ($settings['design_style'] === 'style_2'): ?>
			<section class="service grey-bg position-relative fix pt-125 pb-70">
				<img src="<?php echo get_template_directory_uri(); ?>/assets/images/shape/services-line-shape.png"
					alt="Shape" class="shape shape--line aos-init"
					data-aos="fade-right" data-aos-easing="ease-in-sine" data-aos-duration="9000">
				<div class="container">
					<div class="row">
						<div class="col-xl-8 offset-xl-2 col-lg-10 offset-lg-1">
							<div class="theme text-center">
								<?php if (!empty($settings['sub_title'])) : ?>
									<span class="theme__small--title fw-700 text-uppercase"><span></span>
										<?php echo bdevs_element_kses_intermediate($settings['sub_title']); ?>
										<span></span></span>
								<?php endif; ?>
								<?php if (!empty($settings['title'])) : ?>
									<h2 class="theme__big--title fw-700 mb-80">
										<?php print bdevs_element_kses_basic($settings['title']); ?>
									</h2>
								<?php endif; ?>
							</div>
						</div>
					</div>
					<div class="row">
						<?php foreach ($settings['slides'] as $id => $slide) : ?>
							<div class="col-lg-4 col-md-6 mb-30 text-center">
								<div class="service__block service__block--h3 position-relative white-bg">
									<img class="line line1"
										src="<?php echo get_template_directory_uri(); ?>/assets/images/shape/what-we-do-h3-line1.png"
										alt="img">
									<img class="line line2"
										src="<?php echo get_template_directory_uri(); ?>/assets/images/shape/what-we-do-h3-line2.png"
										alt="img">

									<?php if (!empty($slide['icon']) || !empty($slide['selected_icon']['value'])) : ?>
										<div class="service__icon--h3 service__icon">
											<?php bdevs_element_render_icon($slide, 'icon', 'selected_icon', ['data-aos' => 'zoom-in-down', 'class' => 'aos-init aos-animate']); ?>
										</div>
									<?php endif; ?>

									<?php if (!empty($slide['tab_title'])) : ?>
										<h4 class="service__title">
											<?php echo bdevs_element_kses_basic($slide['tab_title']); ?>
										</h4>
									<?php endif; ?>

									<?php if (!empty($slide['tab_content_info'])) : ?>
										<p><?php echo bdevs_element_kses_basic($slide['tab_content_info']); ?></p>
									<?php endif; ?>

									<?php if (!empty($slide['button_url'])) : ?>
										<a class="link-more text-uppercase fw-700"
											href="<?php echo esc_url($slide['button_url']); ?>"><?php echo bdevs_element_kses_basic($slide['button_text']); ?></a>
									<?php endif; ?>
								</div>
							</div>
						<?php endforeach; ?>
					</div>
				</div>
			</section>
		<?php elseif ($settings['design_style'] === 'style_1'): ?>
			<section class="service section-padding-wrap position-relative fix">
				<img src="<?php echo get_template_directory_uri(); ?>/assets/images/shape/services-line-shape.png"
					alt="Shape" class="shape shape--line">
				<img src="<?php print esc_url($section_image); ?>" alt="Shape"
					class="shape shape--mimg d-none d-lg-block">
				<img src="<?php print esc_url($section_image_shape); ?>" alt="Shape"
					class="shape shape--mibg d-none d-lg-block">
				<div class="container">
					<div class="row">
						<div class="col-xl-8 offset-xl-2 col-lg-10 offset-lg-1">
							<div class="theme text-center">
								<?php if (!empty($settings['sub_title'])) : ?>
									<span class="theme__small--title fw-700 text-uppercase">
										<span></span>
										<?php echo bdevs_element_kses_intermediate($settings['sub_title']); ?>
										<span></span>
									</span>
								<?php endif; ?>
								<?php if (!empty($settings['title'])) : ?>
									<h2 class="theme__big--title fw-700 mb-80">
										<?php print bdevs_element_kses_basic($settings['title']); ?>
									</h2>
								<?php endif; ?>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-xl-6 col-lg-8">
							<div class="row">
								<?php foreach ($settings['slides'] as $id => $slide) : ?>
									<div class="col-lg-6 col-md-6 mb-55">
										<div class="service__block position-relative">
											<img src="<?php echo get_template_directory_uri(); ?>/assets/images/shape/services-ball-shape.png"
												alt="img" class="service__shape">

											<?php if (!empty($slide['icon']) || !empty($slide['selected_icon']['value'])) : ?>
												<div class="service__icon">
													<?php bdevs_element_render_icon($slide, 'icon', 'selected_icon', ['data-aos' => 'zoom-in-down', 'class' => 'aos-init aos-animate']); ?>
												</div>
											<?php endif; ?>

											<?php if (!empty($slide['tab_title'])) : ?>
												<h4 class="service__title">
													<a href="<?php echo esc_url($slide['button_url']); ?>">
														<?php echo bdevs_element_kses_basic($slide['tab_title']); ?>
													</a>
												</h4>
											<?php endif; ?>

											<?php if (!empty($slide['tab_content_info'])) : ?>
												<p><?php echo bdevs_element_kses_basic($slide['tab_content_info']); ?></p>
											<?php endif; ?>

											<?php if (!empty($slide['button_url'])) : ?>
												<a class="link-more text-uppercase fw-700"
													href="<?php echo esc_url($slide['button_url']); ?>"><?php echo bdevs_element_kses_basic($slide['button_text']); ?></a>
											<?php endif; ?>
										</div>
									</div>
								<?php endforeach; ?>
							</div>
						</div>
					</div>
				</div>
			</section>
<?php
		endif;
	}
}
