<?php

namespace BdevsElement\Widget;


use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Typography;
use \Elementor\Core\Schemes\Typography;
use \Elementor\Group_Control_Background;
use Elementor\Utils;


defined('ABSPATH') || die();

class CTA extends BDevs_El_Widget
{


	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Element widget name.
	 *
	 * @return string Widget name.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_name()
	{
		return 'cta';
	}

	/**
	 * Get widget title.
	 *
	 * @return string Widget title.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_title()
	{
		return __('CTA', 'bdevselement');
	}

	public function get_custom_help_url()
	{
		return 'http://elementor.bdevs.net/widgets/gradient-heading/';
	}

	/**
	 * Get widget icon.
	 *
	 * @return string Widget icon.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_icon()
	{
		return 'eicon-t-letter';
	}

	public function get_keywords()
	{
		return ['gradient', 'advanced', 'heading', 'title', 'colorful'];
	}

	protected function register_content_controls()
	{

		$this->start_controls_section(
			'_section_settings',
			[
				'label' => __('Design Style', 'bdevselement'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'design_style',
			[
				'label' => __('Design Style', 'bdevselement'),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'style_1' => __('Style 1', 'bdevselement'),
					'style_2' => __('Style 2', 'bdevselement'),
					'style_3' => __('Style 3', 'bdevselement'),
					'style_4' => __('Style 4', 'bdevselement'),
					'style_5' => __('Style 5', 'bdevselement'),
				],
				'default' => 'style_1',
				'frontend_available' => true,
				'style_transfer' => true,
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'_section_about_image',
			[
				'label' => __('Image', 'bdevselement'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'bg_image',
			[
				'label' => __('Image', 'bdevselement'),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->add_control(
			'bg_image_2',
			[
				'label' => __('Image 2', 'bdevselement'),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'condition' => [
					'design_style' => ['style_1', 'style_2']
				],
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'_section_title',
			[
				'label' => __('Title & Desccription', 'bdevselement'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'sub_title',
			[
				'label' => __('Sub Title', 'bdevselement'),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => 'Heading Sub Title',
				'placeholder' => __('Heading Sub Text', 'bdevselement'),
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->add_control(
			'title',
			[
				'label' => __('Title', 'bdevselement'),
				'label_block' => true,
				'type' => Controls_Manager::TEXTAREA,
				'default' => 'Heading Title',
				'placeholder' => __('Heading Text', 'bdevselement'),
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->add_control(
			'description',
			[
				'label' => __('Description', 'bdevselement'),
				'description' => bdevs_element_get_allowed_html_desc('intermediate'),
				'type' => Controls_Manager::TEXTAREA,
				'default' => __('bdevs info box description goes here', 'bdevselement'),
				'placeholder' => __('Type info box description', 'bdevselement'),
				'rows' => 5,
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'_section_button',
			[
				'label' => __('Button', 'bdevselement'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'button_text',
			[
				'label' => __('Text', 'bdevselement'),
				'type' => Controls_Manager::TEXT,
				'default' => 'Button Text',
				'placeholder' => __('Type button text here', 'bdevselement'),
				'label_block' => true,
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->add_control(
			'button_link',
			[
				'label' => __('Link', 'bdevselement'),
				'type' => Controls_Manager::URL,
				'placeholder' => 'http://elementor.bdevs.net/',
				'dynamic' => [
					'active' => true,
				]
			]
		);

		if (bdevs_element_is_elementor_version('<', '2.6.0')) {
			$this->add_control(
				'button_icon',
				[
					'label' => __('Icon', 'bdevselement'),
					'label_block' => true,
					'type' => Controls_Manager::ICON,
					'options' => bdevs_element_get_bdevs_element_icons(),
					'default' => 'fa fa-angle-right',
				]
			);

			$condition = ['button_icon!' => ''];
		} else {
			$this->add_control(
				'button_selected_icon',
				[
					'type' => Controls_Manager::ICONS,
					'fa4compatibility' => 'button_icon',
					'label_block' => true,
				]
			);
			$condition = ['button_selected_icon[value]!' => ''];
		}

		$this->add_control(
			'button_icon_position',
			[
				'label' => __('Icon Position', 'bdevselement'),
				'type' => Controls_Manager::CHOOSE,
				'label_block' => false,
				'options' => [
					'before' => [
						'title' => __('Before', 'bdevselement'),
						'icon' => 'eicon-h-align-left',
					],
					'after' => [
						'title' => __('After', 'bdevselement'),
						'icon' => 'eicon-h-align-right',
					],
				],
				'default' => 'before',
				'toggle' => false,
				'condition' => $condition,
				'style_transfer' => true,
			]
		);

		$this->add_control(
			'button_icon_spacing',
			[
				'label' => __('Icon Spacing', 'bdevselement'),
				'type' => Controls_Manager::SLIDER,
				'condition' => $condition,
				'selectors' => [
					'{{WRAPPER}} .bdevs-btn--icon-before .bdevs-btn-icon' => 'margin-right: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .bdevs-btn--icon-after .bdevs-btn-icon' => 'margin-left: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();
	}

	protected function register_style_controls()
	{
		$this->start_controls_section(
			'_section_style_title',
			[
				'label' => __('Title & Desccription', 'bdevselement'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'_heading_title',
			[
				'type' => Controls_Manager::HEADING,
				'label' => __('Title', 'bdevselement'),
				'separator' => 'before'
			]
		);

		$this->add_responsive_control(
			'heading_margin',
			[
				'label' => __('Margin', 'bdevselement'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .section-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'heading_padding',
			[
				'label' => __('Padding', 'bdevselement'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .section-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title',
				'selector' => '{{WRAPPER}} .section-title',
				//'scheme' => Typography::TYPOGRAPHY_1,
			]
		);

		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'title',
				'label' => __('Text Shadow', 'bdevselement'),
				'selector' => '{{WRAPPER}} .section-title',
			]
		);

		$this->add_control(
			'heading_color',
			[
				'label' => __('Text Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .section-title' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'blend_mode',
			[
				'label' => __('Blend Mode', 'bdevselement'),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'' => __('Normal', 'bdevselement'),
					'multiply' => 'Multiply',
					'screen' => 'Screen',
					'overlay' => 'Overlay',
					'darken' => 'Darken',
					'lighten' => 'Lighten',
					'color-dodge' => 'Color Dodge',
					'saturation' => 'Saturation',
					'color' => 'Color',
					'difference' => 'Difference',
					'exclusion' => 'Exclusion',
					'hue' => 'Hue',
					'luminosity' => 'Luminosity',
				],
				'selectors' => [
					'{{WRAPPER}} .section-title' => 'mix-blend-mode: {{VALUE}};',
				],
				'separator' => 'none',
			]
		);

		// subtitle
		$this->add_control(
			'_heading_subtitle',
			[
				'type' => Controls_Manager::HEADING,
				'label' => __('Sub Title', 'bdevselement'),
				'separator' => 'before'
			]
		);

		$this->add_responsive_control(
			'heading_subtitle_margin',
			[
				'label' => __('Margin', 'bdevselement'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .sub-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'heading_subtitle_padding',
			[
				'label' => __('Padding', 'bdevselement'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .sub-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'subtitle',
				'selector' => '{{WRAPPER}} .sub-title',
				//'scheme' => Typography::TYPOGRAPHY_2,
			]
		);

		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'subtitle',
				'label' => __('Text Shadow', 'bdevselement'),
				'selector' => '{{WRAPPER}} .sub-title',
			]
		);

		$this->add_control(
			'heading_subtitle_color',
			[
				'label' => __('Text Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .sub-title' => 'color: {{VALUE}};',
				],
			]
		);

		// content

		$this->add_control(
			'_heading_description',
			[
				'type' => Controls_Manager::HEADING,
				'label' => __('Content', 'bdevselement'),
				'separator' => 'before'
			]
		);

		$this->add_responsive_control(
			'heading_desc_margin',
			[
				'label' => __('Margin', 'bdevselement'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .section-heading p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'heading_desc_padding',
			[
				'label' => __('Padding', 'bdevselement'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .section-heading p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'desccription',
				'selector' => '{{WRAPPER}} .section-heading p',
				//'scheme' => Typography::TYPOGRAPHY_3,
			]
		);

		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'desccription',
				'label' => __('Text Shadow', 'bdevselement'),
				'selector' => '{{WRAPPER}} .section-heading p',
			]
		);

		$this->add_control(
			'heading_desc_color',
			[
				'label' => __('Text Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .section-heading p' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();
	}

	protected function render()
	{

		$settings = $this->get_settings_for_display();
		if (!empty($settings['bg_image']['id'])) {
			$bg_image = wp_get_attachment_image_url($settings['bg_image']['id'], 'full');
		}

		if (!empty($settings['bg_image_2']['id'])) {
			$bg_image_2 = wp_get_attachment_image_url($settings['bg_image_2']['id'], 'full');
		}
?>
		<?php if ($settings['design_style'] === 'style_5'):
			$this->add_inline_editing_attributes('title', 'basic');
			$this->add_render_attribute('title', 'class', 'theme__big--title white-color fw-700 mb-40');

			$this->add_inline_editing_attributes('button_text', 'none');
			$this->add_render_attribute('button_text', 'class', 'bdevs-btn-text');
			$this->add_render_attribute('button', 'class', 'btn btn--blue white-color aos-init aos-animate');
			$this->add_render_attribute('button', 'data-aos', 'fade-up');
			if (!empty($settings['button_link'])) {
				$this->add_link_attributes('button', $settings['button_link']);
			}
		?>

			<section class="consult consult__bg consult__bg--h5">
				<div class="container">
					<div class="row">
						<div class="col-sm-12">
							<div class="position-relative consult-box--ex">
								<img src="<?php echo get_template_directory_uri(); ?>/assets/images/shape/consult-shape1.png"
									alt="img"
									class="consult__shape consult__shape1">
								<img src="<?php echo get_template_directory_uri(); ?>/assets/images/shape/consult-shape2.png"
									alt="img"
									class="consult__shape consult__shape2">
								<div class="row align-items-center">
									<div class="col-xl-6 col-lg-7">
										<div class="theme">
											<?php if (!empty($settings['sub_title'])) : ?>
												<span class="theme__small--title theme__small--title-left fw-700 text-uppercase"><span></span>
													<?php echo bdevs_element_kses_basic($settings['sub_title']); ?>
												</span>
											<?php endif; ?>
											<?php if (!empty($settings['title'])) : ?>
												<h2 class="theme__big--title fw-700 mb-35">
													<?php echo bdevs_element_kses_basic($settings['title']); ?>
												</h2>
											<?php endif; ?>
											<div class="consult-button ">
												<!-- button one  -->
												<?php if ($settings['button_text'] && ((empty($settings['button_selected_icon']) || empty($settings['button_selected_icon']['value'])) && empty($settings['button_icon']))) :
													$this->add_render_attribute('button', 'class', 'bt-btn site-btn-border');
													printf(
														'<a %1$s>%2$s</a>',
														$this->get_render_attribute_string('button'),
														esc_html($settings['button_text'])
													);
												elseif (empty($settings['button_text']) && (!(empty($settings['button_selected_icon']) || empty($settings['button_selected_icon']['value'])) || !empty($settings['button_icon']))) : ?>
													<a <?php $this->print_render_attribute_string('button'); ?>><?php bdevs_element_render_icon($settings, 'button_icon', 'button_selected_icon'); ?></a>
													<?php elseif ($settings['button_text'] && (!(empty($settings['button_selected_icon']) || empty($settings['button_selected_icon']['value'])) || !empty($settings['button_icon']))) :
													if ($settings['button_icon_position'] === 'before') :
														$this->add_render_attribute('button', 'class', 'bt-btn site-btn-border bdevs-btn--icon-before');
														$button_text = sprintf('<span %1$s>%2$s</span>', $this->get_render_attribute_string('button_text'), esc_html($settings['button_text']));
													?>
														<a <?php $this->print_render_attribute_string('button'); ?>><?php bdevs_element_render_icon($settings, 'button_icon', 'button_selected_icon', ['class' => 'bdevs-btn-icon']); ?><?php echo $button_text; ?></a>
													<?php
													else :
														$this->add_render_attribute('button', 'class', 'bt-btn bdevs-btn--icon-after');
														$button_text = sprintf('<span %1$s>%2$s</span>', $this->get_render_attribute_string('button_text'), esc_html($settings['button_text']));
													?>
														<a <?php $this->print_render_attribute_string('button'); ?>><?php echo $button_text; ?><?php bdevs_element_render_icon($settings, 'button_icon', 'button_selected_icon', ['class' => 'bdevs-btn-icon']); ?></a>
												<?php
													endif;
												endif; ?>
											</div>
										</div>
									</div>
									<?php if (!empty($bg_image)): ?>
										<div class="col-xl-5 offset-xl-1 col-lg-5 d-none d-lg-block">
											<div class="consult__thumb">
												<img src="<?php print esc_url($bg_image); ?>" alt="img">
											</div>
										</div>
									<?php endif; ?>
								</div>
							</div>
						</div>
					</div>
				</div>
			</section>

		<?php elseif ($settings['design_style'] === 'style_4'):

			$this->add_inline_editing_attributes('title', 'basic');
			$this->add_render_attribute('title', 'class', 'theme__big--title white-color fw-700 mb-40');

			$this->add_inline_editing_attributes('button_text', 'none');
			$this->add_render_attribute('button_text', 'class', 'bdevs-btn-text');
			$this->add_render_attribute('button', 'class', 'btn btn--blue white-color aos-init aos-animate');
			$this->add_render_attribute('button', 'data-aos', 'fade-up');
			if (!empty($settings['button_link'])) {
				$this->add_link_attributes('button', $settings['button_link']);
			}
		?>
			<section class="consult">
				<div class="container">
					<div class="row">
						<div class="col-sm-12">
							<div class="consult__bg consult__bg--h5 pt-70 pb-55 position-relative">
								<img src="<?php echo get_template_directory_uri(); ?>/assets/images/shape/consult-shape1.png"
									alt="img" class="consult__shape consult__shape1">
								<img src="<?php echo get_template_directory_uri(); ?>/assets/images/shape/consult-shape2.png"
									alt="img" class="consult__shape consult__shape2">
								<div class="row align-items-center">
									<div class="col-lg-7 mb-30">
										<div class="theme">
											<?php if (!empty($settings['sub_title'])) : ?>
												<span class="theme__small--title theme__small--title-left fw-700 text-uppercase"><span></span>
													<?php echo bdevs_element_kses_basic($settings['sub_title']); ?>
												</span>
											<?php endif; ?>
											<?php if (!empty($settings['title'])) : ?>
												<h2 class="theme__big--title fw-700">
													<?php echo bdevs_element_kses_basic($settings['title']); ?>
												</h2>
											<?php endif; ?>
										</div>
									</div>
									<div class="col-lg-5 mb-30">
										<div class="consult-button text-right ">
											<!-- button one  -->
											<?php if ($settings['button_text'] && ((empty($settings['button_selected_icon']) || empty($settings['button_selected_icon']['value'])) && empty($settings['button_icon']))) :
												$this->add_render_attribute('button', 'class', 'bt-btn site-btn-border');
												printf(
													'<a %1$s>%2$s</a>',
													$this->get_render_attribute_string('button'),
													esc_html($settings['button_text'])
												);
											elseif (empty($settings['button_text']) && (!(empty($settings['button_selected_icon']) || empty($settings['button_selected_icon']['value'])) || !empty($settings['button_icon']))) : ?>
												<a <?php $this->print_render_attribute_string('button'); ?>><?php bdevs_element_render_icon($settings, 'button_icon', 'button_selected_icon'); ?></a>
												<?php elseif ($settings['button_text'] && (!(empty($settings['button_selected_icon']) || empty($settings['button_selected_icon']['value'])) || !empty($settings['button_icon']))) :
												if ($settings['button_icon_position'] === 'before') :
													$this->add_render_attribute('button', 'class', 'bt-btn site-btn-border bdevs-btn--icon-before');
													$button_text = sprintf('<span %1$s>%2$s</span>', $this->get_render_attribute_string('button_text'), esc_html($settings['button_text']));
												?>
													<a <?php $this->print_render_attribute_string('button'); ?>><?php bdevs_element_render_icon($settings, 'button_icon', 'button_selected_icon', ['class' => 'bdevs-btn-icon']); ?><?php echo $button_text; ?></a>
												<?php
												else :
													$this->add_render_attribute('button', 'class', 'bt-btn bdevs-btn--icon-after');
													$button_text = sprintf('<span %1$s>%2$s</span>', $this->get_render_attribute_string('button_text'), esc_html($settings['button_text']));
												?>
													<a <?php $this->print_render_attribute_string('button'); ?>><?php echo $button_text; ?><?php bdevs_element_render_icon($settings, 'button_icon', 'button_selected_icon', ['class' => 'bdevs-btn-icon']); ?></a>
											<?php
												endif;
											endif; ?>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</section>
		<?php elseif ($settings['design_style'] === 'style_3'):

			$this->add_inline_editing_attributes('title', 'basic');
			$this->add_render_attribute('title', 'class', 'theme__big--title white-color fw-700 mb-40');

			$this->add_inline_editing_attributes('button_text', 'none');
			$this->add_render_attribute('button_text', 'class', 'bdevs-btn-text');
			$this->add_render_attribute('button', 'class', 'btn btn--white theme-color');
			if (!empty($settings['button_link'])) {
				$this->add_link_attributes('button', $settings['button_link']);
			}
		?>

			<section class="consult">
				<div class="container">
					<div class="row">
						<div class="col-sm-12">
							<div class="consult__bg pt-70 pb-80"
								style="background-image: url(<?php echo esc_attr($bg_image); ?>)"
								data-overlay="theme" data-opacity="6">
								<div class="row">
									<div class="col-lg-8 offset-lg-2">
										<div class="theme text-center">
											<?php if (!empty($settings['sub_title'])) : ?>
												<span class="theme__small--title white-color fw-700 text-uppercase"><span
														class="white-line"></span><?php echo bdevs_element_kses_basic($settings['sub_title']); ?><span
														class="white-line"></span></span>
											<?php endif; ?>
											<?php if (!empty($settings['title'])) : ?>
												<h2 <?php $this->print_render_attribute_string('title'); ?>>
													<?php echo bdevs_element_kses_basic($settings['title']); ?>
												</h2>
											<?php endif; ?>
											<!-- button one  -->
											<?php if ($settings['button_text'] && ((empty($settings['button_selected_icon']) || empty($settings['button_selected_icon']['value'])) && empty($settings['button_icon']))) :
												$this->add_render_attribute('button', 'class', 'bt-btn site-btn-border');
												printf(
													'<a %1$s>%2$s</a>',
													$this->get_render_attribute_string('button'),
													esc_html($settings['button_text'])
												);
											elseif (empty($settings['button_text']) && (!(empty($settings['button_selected_icon']) || empty($settings['button_selected_icon']['value'])) || !empty($settings['button_icon']))) : ?>
												<a <?php $this->print_render_attribute_string('button'); ?>><?php bdevs_element_render_icon($settings, 'button_icon', 'button_selected_icon'); ?></a>
												<?php elseif ($settings['button_text'] && (!(empty($settings['button_selected_icon']) || empty($settings['button_selected_icon']['value'])) || !empty($settings['button_icon']))) :
												if ($settings['button_icon_position'] === 'before') :
													$this->add_render_attribute('button', 'class', 'bt-btn site-btn-border bdevs-btn--icon-before');
													$button_text = sprintf('<span %1$s>%2$s</span>', $this->get_render_attribute_string('button_text'), esc_html($settings['button_text']));
												?>
													<a <?php $this->print_render_attribute_string('button'); ?>><?php bdevs_element_render_icon($settings, 'button_icon', 'button_selected_icon', ['class' => 'bdevs-btn-icon']); ?><?php echo $button_text; ?></a>
												<?php
												else :
													$this->add_render_attribute('button', 'class', 'bt-btn bdevs-btn--icon-after');
													$button_text = sprintf('<span %1$s>%2$s</span>', $this->get_render_attribute_string('button_text'), esc_html($settings['button_text']));
												?>
													<a <?php $this->print_render_attribute_string('button'); ?>><?php echo $button_text; ?><?php bdevs_element_render_icon($settings, 'button_icon', 'button_selected_icon', ['class' => 'bdevs-btn-icon']); ?></a>
											<?php
												endif;
											endif; ?>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</section>

		<?php elseif ($settings['design_style'] === 'style_2'):

			$this->add_inline_editing_attributes('title', 'basic');
			$this->add_render_attribute('title', 'class', 'theme__big--title fw-700 mb-25');

			$this->add_inline_editing_attributes('button_text', 'none');
			$this->add_render_attribute('button_text', 'class', 'bdevs-btn-text');
			$this->add_render_attribute('button', 'class', 'btn btn--blue btn--icon white-color aos-init aos-animate');
			$this->add_render_attribute('button', 'data-aos', 'fade-up');
			if (!empty($settings['button_link'])) {
				$this->add_link_attributes('button', $settings['button_link']);
			}
		?>

			<section class="contacts--area position-relative grey-bg"
				style="background-image: url(<?php print esc_url($bg_image_2); ?>)">
				<div class="container">
					<div class="row">
						<div class="col-sm-12">
							<div class="row align-items-center">
								<?php if (!empty($bg_image)) : ?>
									<div class="col-lg-6 position-relative">
										<img class="contacts__help--bg"
											src="<?php echo get_template_directory_uri(); ?>/assets/images/shape/help-ma-bg.png"
											alt="shape">
										<div class="contacts__mcp contacts__mcp--h2 aos-init aos-animate"
											data-aos="fade-right">
											<img src="<?php echo esc_url($bg_image); ?>" alt="img" />
										</div>
									</div>
								<?php endif; ?>
								<div class="col-lg-6 pt-xs-50 pb-xs-50">
									<div class="theme text-right position-relative">
										<?php if (!empty($settings['sub_title'])) : ?>
											<span class="theme__small--title fw-700 text-uppercase text-right theme__small--title-right"><?php echo bdevs_element_kses_basic($settings['sub_title']); ?><span></span></span>
										<?php endif; ?>
										<?php if (!empty($settings['title'])) : ?>
											<h2 <?php $this->print_render_attribute_string('title'); ?>>
												<?php echo bdevs_element_kses_basic($settings['title']); ?>
											</h2>
										<?php endif; ?>
										<?php if (!empty($settings['description'])) : ?>
											<p class="mb-35 contacts__text--h2"><?php echo bdevs_element_kses_intermediate($settings['description']); ?></p>
										<?php endif; ?>

										<!-- button one  -->
										<?php if ($settings['button_text'] && ((empty($settings['button_selected_icon']) || empty($settings['button_selected_icon']['value'])) && empty($settings['button_icon']))) :
											$this->add_render_attribute('button', 'class', 'bt-btn site-btn-border');
											printf(
												'<a %1$s>%2$s</a>',
												$this->get_render_attribute_string('button'),
												esc_html($settings['button_text'])
											);
										elseif (empty($settings['button_text']) && (!(empty($settings['button_selected_icon']) || empty($settings['button_selected_icon']['value'])) || !empty($settings['button_icon']))) : ?>
											<a <?php $this->print_render_attribute_string('button'); ?>><?php bdevs_element_render_icon($settings, 'button_icon', 'button_selected_icon'); ?></a>
											<?php elseif ($settings['button_text'] && (!(empty($settings['button_selected_icon']) || empty($settings['button_selected_icon']['value'])) || !empty($settings['button_icon']))) :
											if ($settings['button_icon_position'] === 'before') :
												$this->add_render_attribute('button', 'class', 'bt-btn site-btn-border bdevs-btn--icon-before');
												$button_text = sprintf('<span %1$s>%2$s</span>', $this->get_render_attribute_string('button_text'), esc_html($settings['button_text']));
											?>
												<a <?php $this->print_render_attribute_string('button'); ?>><?php bdevs_element_render_icon($settings, 'button_icon', 'button_selected_icon', ['class' => 'bdevs-btn-icon']); ?><?php echo $button_text; ?></a>
											<?php
											else :
												$this->add_render_attribute('button', 'class', 'bt-btn bdevs-btn--icon-after');
												$button_text = sprintf('<span %1$s>%2$s</span>', $this->get_render_attribute_string('button_text'), esc_html($settings['button_text']));
											?>
												<a <?php $this->print_render_attribute_string('button'); ?>><?php echo $button_text; ?><?php bdevs_element_render_icon($settings, 'button_icon', 'button_selected_icon', ['class' => 'bdevs-btn-icon']); ?></a>
										<?php
											endif;
										endif; ?>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</section>

		<?php else:
			$this->add_inline_editing_attributes('button_text', 'none');
			$this->add_render_attribute('button_text', 'class', 'bdevs-btn-text');
			$this->add_render_attribute('button', 'class', 'btn btn--blue white-color aos-init aos-animate');
			$this->add_render_attribute('button', 'data-aos', 'fade-up');
			if (!empty($settings['button_link'])) {
				$this->add_link_attributes('button', $settings['button_link']);
			}
		?>

			<section class="contacts--area position-relative">
				<div class="container">
					<div class="row">
						<div class="col-sm-12">
							<div class="contacts__bg pt-10 pb-10"
								style="background-image: url(<?php print esc_url($bg_image_2); ?>)">
								<div class="row align-items-center">
									<?php if (!empty($bg_image)) : ?>
										<div class="col-lg-5">
											<div class="contacts__mcp aos-init aos-animate" data-aos="fade-right">
												<img src="<?php echo esc_url($bg_image); ?>" alt="img">
											</div>
										</div>
									<?php endif; ?>
									<div class="col-lg-7">
										<div class="theme text-right position-relative">

											<?php if (!empty($settings['sub_title'])) : ?>
												<span class="theme__small--title fw-700 text-uppercase text-right theme__small--title-right">
													<?php echo bdevs_element_kses_intermediate($settings['sub_title']); ?>
													<span></span>
												</span>
											<?php endif; ?>

											<?php if (!empty($settings['title'])) : ?>
												<h2 class="theme__big--title fw-700 mb-25">
													<?php echo bdevs_element_kses_basic($settings['title']); ?>
												</h2>
											<?php endif; ?>

											<!-- button one  -->
											<?php if ($settings['button_text'] && ((empty($settings['button_selected_icon']) || empty($settings['button_selected_icon']['value'])) && empty($settings['button_icon']))) :
												$this->add_render_attribute('button', 'class', 'bt-btn site-btn-border');
												printf(
													'<a %1$s>%2$s</a>',
													$this->get_render_attribute_string('button'),
													esc_html($settings['button_text'])
												);
											elseif (empty($settings['button_text']) && (!(empty($settings['button_selected_icon']) || empty($settings['button_selected_icon']['value'])) || !empty($settings['button_icon']))) : ?>
												<a <?php $this->print_render_attribute_string('button'); ?>><?php bdevs_element_render_icon($settings, 'button_icon', 'button_selected_icon'); ?></a>
												<?php elseif ($settings['button_text'] && (!(empty($settings['button_selected_icon']) || empty($settings['button_selected_icon']['value'])) || !empty($settings['button_icon']))) :
												if ($settings['button_icon_position'] === 'before') :
													$this->add_render_attribute('button', 'class', 'bt-btn site-btn-border bdevs-btn--icon-before');
													$button_text = sprintf('<span %1$s>%2$s</span>', $this->get_render_attribute_string('button_text'), esc_html($settings['button_text']));
												?>
													<a <?php $this->print_render_attribute_string('button'); ?>><?php bdevs_element_render_icon($settings, 'button_icon', 'button_selected_icon', ['class' => 'bdevs-btn-icon']); ?><?php echo $button_text; ?></a>
												<?php
												else :
													$this->add_render_attribute('button', 'class', 'bt-btn bdevs-btn--icon-after');
													$button_text = sprintf('<span %1$s>%2$s</span>', $this->get_render_attribute_string('button_text'), esc_html($settings['button_text']));
												?>
													<a <?php $this->print_render_attribute_string('button'); ?>><?php echo $button_text; ?><?php bdevs_element_render_icon($settings, 'button_icon', 'button_selected_icon', ['class' => 'bdevs-btn-icon']); ?></a>
											<?php
												endif;
											endif; ?>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</section>

		<?php endif; ?>

<?php }
}
