<?php

namespace BdevsElement\Widget;

use Elementor\Control_Media;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Typography;
use Elementor\Repeater;
use \Elementor\Core\Schemes\Typography;
use Elementor\Utils;

defined('ABSPATH') || die();

class CF7 extends BDevs_El_Widget
{

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Element widget name.
	 *
	 * @return string Widget name.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_name()
	{
		return 'cf7';
	}

	/**
	 * Get widget title.
	 *
	 * @return string Widget title.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_title()
	{
		return __('Contact Form 7', 'bdevselement');
	}

	public function get_custom_help_url()
	{
		return 'http://elementor.bdevs.net//widgets/contact-7-form/';
	}

	/**
	 * Get widget icon.
	 *
	 * @return string Widget icon.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_icon()
	{
		return 'eicon-shortcode';
	}

	public function get_keywords()
	{
		return ['form', 'contact', 'cf7', 'contact form', 'gravity', 'ninja'];
	}

	protected function register_content_controls()
	{

		$this->start_controls_section(
			'_section_design_title',
			[
				'label' => __('Design Style', 'bdevselement'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'design_style',
			[
				'label' => __('Design Style', 'bdevselement'),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'style_1' => __('Style 1', 'bdevselement'),
					'style_2' => __('Style 2', 'bdevselement'),
					'style_3' => __('Style 3', 'bdevselement'),
					'style_4' => __('Style 4', 'bdevselement'),
				],
				'default' => 'style_1',
				'frontend_available' => true,
				'style_transfer' => true,
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'_section_title',
			[
				'label' => __('Title & Desccription', 'bdevselement'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'title',
			[
				'label' => __('Title', 'bdevselement'),
				'type' => Controls_Manager::TEXT,
				'default' => 'Heading Title',
				'placeholder' => __('Heading Text', 'bdevselement'),
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->add_control(
			'sub_title',
			[
				'label' => __('Sub Title', 'bdevselement'),
				'type' => Controls_Manager::TEXT,
				'default' => 'Heading Sub Title',
				'placeholder' => __('Heading Sub Text', 'bdevselement'),
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->add_control(
			'desccription',
			[
				'label' => __('Desccription', 'bdevselement'),
				'type' => Controls_Manager::TEXTAREA,
				'placeholder' => __('Heading Desccription Text', 'bdevselement'),
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->add_control(
			'link',
			[
				'label' => __('Link', 'bdevselement'),
				'type' => Controls_Manager::URL,
				'separator' => 'before',
				'placeholder' => 'http://elementor.bdevs.net/',
				'condition' => [
					'design_style' => 'style_2'
				],
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->add_control(
			'title_tag',
			[
				'label' => __('Title HTML Tag', 'bdevselement'),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'h1' => [
						'title' => __('H1', 'bdevselement'),
						'icon' => 'eicon-editor-h1'
					],
					'h2' => [
						'title' => __('H2', 'bdevselement'),
						'icon' => 'eicon-editor-h2'
					],
					'h3' => [
						'title' => __('H3', 'bdevselement'),
						'icon' => 'eicon-editor-h3'
					],
					'h4' => [
						'title' => __('H4', 'bdevselement'),
						'icon' => 'eicon-editor-h4'
					],
					'h5' => [
						'title' => __('H5', 'bdevselement'),
						'icon' => 'eicon-editor-h5'
					],
					'h6' => [
						'title' => __('H6', 'bdevselement'),
						'icon' => 'eicon-editor-h6'
					]
				],
				'default' => 'h2',
				'toggle' => false,
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label' => __('Alignment', 'bdevselement'),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __('Left', 'bdevselement'),
						'icon' => 'fa fa-align-left',
					],
					'center' => [
						'title' => __('Center', 'bdevselement'),
						'icon' => 'fa fa-align-center',
					],
					'right' => [
						'title' => __('Right', 'bdevselement'),
						'icon' => 'fa fa-align-right',
					],
				],
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}}' => 'text-align: {{VALUE}};'
				]
			]
		);

		$this->end_controls_section();


		$this->start_controls_section(
			'section_map',
			[
				'label' => __('Map', 'elementor'),
			]
		);

		$default_address = __('London Eye, London, United Kingdom', 'elementor');
		$this->add_control(
			'address',
			[
				'label' => __('Address', 'elementor'),
				'type' => Controls_Manager::TEXT,
				'placeholder' => $default_address,
				'default' => $default_address,
				'label_block' => true,
			]
		);

		$this->add_control(
			'zoom',
			[
				'label' => __('Zoom Level', 'elementor'),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 10,
				],
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 20,
					],
				],
			]
		);


		$this->add_responsive_control(
			'height',
			[
				'label' => __('Height', 'elementor'),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 300,
				],
				'range' => [
					'px' => [
						'min' => 40,
						'max' => 1440,
					],
				],
				'selectors' => [
					'{{WRAPPER}} iframe' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'prevent_scroll',
			[
				'label' => __('Prevent Scroll', 'elementor'),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'selectors' => [
					'{{WRAPPER}} iframe' => 'pointer-events: none;',
				],
			]
		);

		$this->add_control(
			'view',
			[
				'label' => __('View', 'elementor'),
				'type' => Controls_Manager::HIDDEN,
				'default' => 'traditional',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'_section_cf7',
			[
				'label' => bdevs_element_is_cf7_activated() ? __('Contact Form 7', 'bdevselement') : __('Missing Notice', 'bdevselement'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		if (!bdevs_element_is_cf7_activated()) {
			$this->add_control(
				'_cf7_missing_notice',
				[
					'type' => Controls_Manager::RAW_HTML,
					'raw' => sprintf(
						__('Hello %2$s, looks like %1$s is missing in your site. Please click on the link below and install/activate %1$s. Make sure to refresh this page after installation or activation.', 'bdevselement'),
						'<a href="' . esc_url(admin_url('plugin-install.php?s=Contact+Form+7&tab=search&type=term'))
							. '" target="_blank" rel="noopener">Contact Form 7</a>',
						bdevs_element_get_current_user_display_name()
					),
					'content_classes' => 'elementor-panel-alert elementor-panel-alert-danger',
				]
			);

			$this->add_control(
				'_cf7_install',
				[
					'type' => Controls_Manager::RAW_HTML,
					'raw' => '<a href="' . esc_url(admin_url('plugin-install.php?s=Contact+Form+7&tab=search&type=term')) . '" target="_blank" rel="noopener">Click to install or activate Contact Form 7</a>',
				]
			);
			$this->end_controls_section();
			return;
		}

		$this->add_control(
			'form_id',
			[
				'label' => __('Select Your Form', 'bdevselement'),
				'type' => Controls_Manager::SELECT,
				'label_block' => true,
				'options' => ['' => __('', 'bdevselement')] + \bdevs_element_get_cf7_forms(),
			]
		);

		$this->add_control(
			'html_class',
			[
				'label' => __('HTML Class', 'bdevselement'),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'description' => __('Add CSS custom class to the form.', 'bdevselement'),
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'_section_features_list',
			[
				'label' => __('Contact List', 'bdevselement'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'type',
			[
				'label' => __('Media Type', 'bdevselement'),
				'type' => Controls_Manager::CHOOSE,
				'label_block' => false,
				'options' => [
					'icon' => [
						'title' => __('Icon', 'bdevselement'),
						'icon' => 'fa fa-smile-o',
					],
					'image' => [
						'title' => __('Image', 'bdevselement'),
						'icon' => 'fa fa-image',
					],
				],
				'default' => 'icon',
				'toggle' => false,
				'style_transfer' => true,
			]
		);

		$repeater->add_control(
			'image',
			[
				'label' => __('Image', 'bdevselement'),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'condition' => [
					'type' => 'image'
				],
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$repeater->add_group_control(
			Group_Control_Image_Size::get_type(),
			[
				'name' => 'thumbnail',
				'default' => 'medium_large',
				'separator' => 'none',
				'exclude' => [
					'full',
					'custom',
					'large',
					'shop_catalog',
					'shop_single',
					'shop_thumbnail'
				],
				'condition' => [
					'type' => 'image'
				]
			]
		);

		if (bdevs_element_is_elementor_version('<', '2.6.0')) {
			$repeater->add_control(
				'icon',
				[
					'label' => __('Icon', 'bdevselement'),
					'label_block' => true,
					'type' => Controls_Manager::ICON,
					'options' => bdevs_element_get_bdevs_element_icons(),
					'default' => 'fa fa-smile-o',
					'condition' => [
						'type' => 'icon'
					]
				]
			);
		} else {
			$repeater->add_control(
				'selected_icon',
				[
					'type' => Controls_Manager::ICONS,
					'fa4compatibility' => 'icon',
					'label_block' => true,
					'default' => [
						'value' => 'fas fa-smile-wink',
						'library' => 'fa-solid',
					],
					'condition' => [
						'type' => 'icon'
					]
				]
			);
		}

		if (bdevs_element_is_elementor_version('<', '2.6.0')) {
			$repeater->add_control(
				'icon2',
				[
					'label' => __('Icon', 'bdevselement'),
					'label_block' => true,
					'type' => Controls_Manager::ICON,
					'options' => bdevs_element_get_bdevs_element_icons(),
					'default' => 'fa fa-smile-o',
					'condition' => [
						'type' => 'icon'
					]
				]
			);
		} else {
			$repeater->add_control(
				'selected_icon2',
				[
					'type' => Controls_Manager::ICONS,
					'fa4compatibility' => 'icon',
					'label_block' => true,
					'default' => [
						'value' => 'fas fa-smile-wink',
						'library' => 'fa-solid',
					],
					'condition' => [
						'type' => 'icon'
					]
				]
			);
		}

		$repeater->add_control(
			'tab_title',
			[
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'label' => __('Title', 'bdevselement'),
				'default' => __('Title', 'bdevselement'),
				'placeholder' => __('Type title here', 'bdevselement'),
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$repeater->add_control(
			'tab_content',
			[
				'type' => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'show_label' => false,
				'placeholder' => __('Type content here', 'bdevselement'),
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->add_control(
			'slides',
			[
				'show_label' => false,
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '<# print(tab_title || "Carousel Item"); #>',
				'default' => [
					[
						'image' => [
							'url' => Utils::get_placeholder_image_src(),
						],
					],
					[
						'image' => [
							'url' => Utils::get_placeholder_image_src(),
						],
					],
				]
			]
		);

		$this->end_controls_section();
	}

	protected function register_style_controls()
	{
		$this->start_controls_section(
			'_section_fields_style',
			[
				'label' => __('Form Fields', 'bdevselement'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'field_width',
			[
				'label' => __('Width', 'bdevselement'),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'unit' => '%',
				],
				'tablet_default' => [
					'unit' => '%',
				],
				'mobile_default' => [
					'unit' => '%',
				],
				'size_units' => ['%', 'px'],
				'range' => [
					'%' => [
						'min' => 1,
						'max' => 100,
					],
					'px' => [
						'min' => 1,
						'max' => 500,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .wpcf7-form-control:not(.wpcf7-submit)' => 'width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .bdevs-cf7-form label' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'field_margin',
			[
				'label' => __('Spacing Bottom', 'bdevselement'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .wpcf7-form-control:not(.wpcf7-submit)' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'field_padding',
			[
				'label' => __('Padding', 'bdevselement'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .wpcf7-form-control:not(.wpcf7-submit)' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'field_border_radius',
			[
				'label' => __('Border Radius', 'bdevselement'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .wpcf7-form-control:not(.wpcf7-submit)' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'hr',
			[
				'type' => Controls_Manager::DIVIDER,
				'style' => 'thick',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'field_typography',
				'label' => __('Typography', 'bdevselement'),
				'selector' => '{{WRAPPER}} .wpcf7-form-control:not(.wpcf7-submit)',
				//'scheme' => Typography::TYPOGRAPHY_3
			]
		);

		$this->add_control(
			'field_color',
			[
				'label' => __('Text Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wpcf7-form-control:not(.wpcf7-submit)' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'field_placeholder_color',
			[
				'label' => __('Placeholder Text Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} ::-webkit-input-placeholder' => 'color: {{VALUE}};',
					'{{WRAPPER}} ::-moz-placeholder' => 'color: {{VALUE}};',
					'{{WRAPPER}} ::-ms-input-placeholder' => 'color: {{VALUE}};',
				],
			]
		);

		$this->start_controls_tabs('tabs_field_state');

		$this->start_controls_tab(
			'tab_field_normal',
			[
				'label' => __('Normal', 'bdevselement'),
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'field_border',
				'selector' => '{{WRAPPER}} .wpcf7-form-control:not(.wpcf7-submit)',
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'field_box_shadow',
				'selector' => '{{WRAPPER}} .wpcf7-form-control:not(.wpcf7-submit)',
			]
		);

		$this->add_control(
			'field_bg_color',
			[
				'label' => __('Background Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wpcf7-form-control:not(.wpcf7-submit)' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_field_focus',
			[
				'label' => __('Focus', 'bdevselement'),
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'field_focus_border',
				'selector' => '{{WRAPPER}} .wpcf7-form-control:not(.wpcf7-submit):focus',
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'field_focus_box_shadow',
				'exclude' => [
					'box_shadow_position',
				],
				'selector' => '{{WRAPPER}} .wpcf7-form-control:not(.wpcf7-submit):focus',
			]
		);

		$this->add_control(
			'field_focus_bg_color',
			[
				'label' => __('Background Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wpcf7-form-control:not(.wpcf7-submit):focus' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();

		$this->end_controls_section();


		$this->start_controls_section(
			'cf7-form-label',
			[
				'label' => __('Form Fields Label', 'bdevselement'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'label_margin',
			[
				'label' => __('Spacing Bottom', 'bdevselement'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .wpcf7-form-control:not(.wpcf7-submit)' => 'margin-top: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'hr3',
			[
				'type' => Controls_Manager::DIVIDER,
				'style' => 'thick',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'label_typography',
				'label' => __('Typography', 'bdevselement'),
				'selector' => '{{WRAPPER}} label',
				//'scheme' => Typography::TYPOGRAPHY_3
			]
		);

		$this->add_control(
			'label_color',
			[
				'label' => __('Text Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} label' => 'color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'submit',
			[
				'label' => __('Submit Button', 'bdevselement'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'submit_margin',
			[
				'label' => __('Margin', 'bdevselement'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .wpcf7-submit' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'submit_padding',
			[
				'label' => __('Padding', 'bdevselement'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .wpcf7-submit' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'submit_typography',
				'selector' => '{{WRAPPER}} .wpcf7-submit',
				//'scheme' => Typography::TYPOGRAPHY_4
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'submit_border',
				'selector' => '{{WRAPPER}} .wpcf7-submit',
			]
		);

		$this->add_control(
			'submit_border_radius',
			[
				'label' => __('Border Radius', 'bdevselement'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .wpcf7-submit' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'submit_box_shadow',
				'selector' => '{{WRAPPER}} .wpcf7-submit',
			]
		);

		$this->add_control(
			'hr4',
			[
				'type' => Controls_Manager::DIVIDER,
				'style' => 'thick',
			]
		);

		$this->start_controls_tabs('tabs_button_style');

		$this->start_controls_tab(
			'tab_button_normal',
			[
				'label' => __('Normal', 'bdevselement'),
			]
		);

		$this->add_control(
			'submit_color',
			[
				'label' => __('Text Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .wpcf7-submit' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'submit_bg_color',
			[
				'label' => __('Background Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wpcf7-submit' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_button_hover',
			[
				'label' => __('Hover', 'bdevselement'),
			]
		);

		$this->add_control(
			'submit_hover_color',
			[
				'label' => __('Text Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wpcf7-submit:hover, {{WRAPPER}} .wpcf7-submit:focus' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'submit_hover_bg_color',
			[
				'label' => __('Background Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wpcf7-submit:hover, {{WRAPPER}} .wpcf7-submit:focus' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'submit_hover_border_color',
			[
				'label' => __('Border Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wpcf7-submit:hover, {{WRAPPER}} .wpcf7-submit:focus' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();

		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();

		if (!bdevs_element_is_cf7_activated()) {
			return;
		}

		$this->add_render_attribute('title_2', 'class', 'theme__big--title white-color fw-700');
		$title = bdevs_element_kses_basic($settings['title']);


		if (empty($settings['address'])) {
			return;
		}

		if (0 === absint($settings['zoom']['size'])) {
			$settings['zoom']['size'] = 10;
		} ?>

		<?php if ($settings['design_style'] === 'style_4') : ?>
			<section class="contact-form-area">
				<div class="container">
					<div class="form-wrapper grey-bg">
						<div class="row align-items-center">
							<div class="col-sm-12 text-center mb-40">
								<div class="theme">
									<?php if (!empty($settings['sub_title'])) : ?>
										<h2 class="black-color mb-15"><?php echo bdevs_element_kses_intermediate($settings['sub_title']); ?></h2>
									<?php endif; ?>
									<?php if (!empty($settings['title'])) : ?>
										<h5 class="fw-500 primary-color"><?php echo bdevs_element_kses_intermediate($settings['title']); ?></h5>
									<?php endif; ?>
								</div>
							</div>
						</div>
						<div class="contact-form">
							<?php if (!empty($settings['form_id'])) {
								echo bdevs_element_do_shortcode('contact-form-7', [
									'id' => $settings['form_id'],
									'html_class' => 'bdevs-cf7-form ' . bdevs_element_sanitize_html_class_param($settings['html_class']),
								]);
							} ?>
						</div>
					</div>
				</div>
			</section>
		<?php elseif ($settings['design_style'] === 'style_3') : ?>
			<div class="contacts pt-130 pb-100">
				<div class="container">
					<div class="row">
						<?php foreach ($settings['slides'] as $id => $slide) : ?>
							<div class="col-lg-4 mb-30">
								<div class="contacts__feature">
									<?php if (!empty($slide['tab_title'])) : ?>
										<h3 class="white-color fw-500 mb-10">
											<?php echo bdevs_element_kses_basic($slide['tab_title']); ?>
										</h3>
									<?php endif; ?>
									<h4 class="white-color fw-400">
										<?php if (! empty($slide['icon']) || ! empty($slide['selected_icon']['value'])) : ?>
											<?php bdevs_element_render_icon($slide, 'icon', 'selected_icon'); ?>
										<?php endif; ?>
										<?php echo bdevs_element_kses_basic($slide['tab_content']); ?>
									</h4>
									<?php if (! empty($slide['icon2']) || ! empty($slide['selected_icon2']['value'])) : ?>
										<?php bdevs_element_render_icon($slide, 'icon2', 'selected_icon2', ['class' => 'contacts__feature--bg']); ?>
									<?php endif; ?>
								</div>
							</div>
						<?php endforeach; ?>
					</div>
					<div class="row pt-95">
						<div class="col-lg-6 offset-lg-3">
							<div class="theme text-center">
								<?php if (!empty($settings['sub_title'])) : ?>
									<span class="theme__small--title fw-700 text-uppercase white-color">
										<span class="white-line"></span>
										<?php echo bdevs_element_kses_intermediate($settings['sub_title']); ?>
										<span class="white-line"></span>
									</span>
								<?php endif; ?>
								<?php if (!empty($settings['title'])) : ?>
									<h2 class="theme__big--title fw-700 mb-75 white-color">
										<?php echo bdevs_element_kses_basic($settings['title']); ?>
									</h2>
								<?php endif; ?>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-sm-12">
							<div class="contacts__form">
								<?php if (!empty($settings['form_id'])) {
									echo bdevs_element_do_shortcode('contact-form-7', [
										'id' => $settings['form_id'],
										'html_class' => 'bdevs-cf7-form ' . bdevs_element_sanitize_html_class_param($settings['html_class']),
									]);
								} ?>
							</div>
						</div>
					</div>
				</div>
			</div>
		<?php elseif ($settings['design_style'] === 'style_2') : ?>
			<section class="contacts pb-100">
				<div class="container">
					<div class="row">
						<div class="col-lg-7 mb-30">
							<div class="map position-relative">
								<div class="neeha-custom-embed">
									<?php
									printf(
										'<iframe src="https://maps.google.com/maps?q=%s&amp;t=m&amp;z=%d&amp;output=embed&amp;iwloc=near"></iframe>',
										urlencode($settings['address']),
										absint($settings['zoom']['size'])
									);
									?>
								</div>
							</div>
						</div>
						<div class="col-lg-5 mb-30">
							<div class="contacts__bg--h4 theme-bg">
								<div class="row">
									<div class="col-sm-12">
										<div class="contacts__form">
											<?php if (!empty($settings['title'])): ?>
												<div class="theme">
													<h2 class="theme__big--title white-color fw-700">
														<?php echo bdevs_element_kses_basic($settings['title']); ?>
													</h2>
												</div>
											<?php endif; ?>
											<?php if (!empty($settings['form_id'])) {
												echo bdevs_element_do_shortcode('contact-form-7', [
													'id' => $settings['form_id'],
													'html_class' => 'bdevs-cf7-form ' . bdevs_element_sanitize_html_class_param($settings['html_class']),
												]);
											} ?>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</section>
		<?php elseif ($settings['design_style'] === 'style_1') : ?>
			<div class="contacts">
				<div class="contacts--bg position-relative pt-125 pb-100">
					<div class="container">
						<div class="row align-items-end justify-content-end">
							<div class="col-xl-6 col-lg-8 mb-70">
								<div class="theme">
									<?php if (!empty($settings['sub_title'])) : ?>
										<h4 class="sub-title"><?php echo bdevs_element_kses_intermediate($settings['sub_title']); ?></h4>
									<?php endif; ?>
									<?php printf(
										'<%1$s %2$s>%3$s</%1$s>',
										tag_escape($settings['title_tag']),
										$this->get_render_attribute_string('title_2'),
										$title
									); ?>
									<?php if (!empty($settings['desccription'])) : ?>
										<p><?php echo bdevs_element_kses_intermediate($settings['desccription']); ?></p>
									<?php endif; ?>
								</div>
							</div>
							<div class="col-xl-6 col-lg-4 mb-70 d-none d-md-block">
								<div class="theme text-right position-relative">
									<span class="add-btn"><i class="fal fa-plus"></i></span>
								</div>
							</div>
						</div>
						<div class="row">
							<div class="col-sm-12">
								<div class="contacts__form">
									<?php if (!empty($settings['form_id'])) {
										echo bdevs_element_do_shortcode('contact-form-7', [
											'id' => $settings['form_id'],
											'html_class' => 'bdevs-cf7-form ' . bdevs_element_sanitize_html_class_param($settings['html_class']),
										]);
									} ?>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		<?php endif; ?>
<?php
	}
}
