<?php

namespace BdevsElement\Widget;

use \Elementor\Scheme_Typography;
use \Elementor\Core\Schemes\Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Control_Media;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Typography;

defined('ABSPATH') || die();

class About extends BDevs_El_Widget
{

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Element widget name.
	 *
	 * @return string Widget name.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_name()
	{
		return 'about';
	}

	/**
	 * Get widget title.
	 *
	 * @return string Widget title.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_title()
	{
		return __('About', 'bdevselement');
	}

	/**
	 * Get widget icon.
	 *
	 * @return string Widget icon.
	 * @since 1.0.0
	 * @access public
	 *
	 */
	public function get_icon()
	{
		return 'eicon-single-post';
	}

	public function get_keywords()
	{
		return ['info', 'blurb', 'box', 'about', 'content'];
	}

	/**
	 * Register content related controls
	 */
	protected function register_content_controls()
	{

		$this->start_controls_section(
			'_section_design_title',
			[
				'label' => __('Design Style', 'bdevselement'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'design_style',
			[
				'label' => __('Design Style', 'bdevselement'),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'style_1' => __('style 1', 'bdevselement'),
					'style_2' => __('Style 2', 'bdevselement'),
					'style_3' => __('Style 3', 'bdevselement'),
					'style_4' => __('Style 4', 'bdevselement'),
					'style_5' => __('Style 5', 'bdevselement'),
					'style_6' => __('Style 6', 'bdevselement'),
					'style_7' => __('Style 7', 'bdevselement'),
					'style_8' => __('Style 8', 'bdevselement'),
					'style_9' => __('Style 9', 'bdevselement'),
					'style_10' => __('Style 10', 'bdevselement'),
				],
				'default' => 'style_1',
				'frontend_available' => true,
				'style_transfer' => true,
			]
		);

		$this->add_responsive_control(
			'padding_top',
			[
				'label' => __('Padding Top', 'bdevselement'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 5,
					]
				],
				'selectors' => [
					'{{WRAPPER}} .feature.feature-area' => 'padding-top: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .history-area' => 'padding-top: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'design_style' => ['style_7', 'style_8', 'style_9', 'style_10']
				]
			]
		);

		$this->add_responsive_control(
			'padding_bottom',
			[
				'label' => __('Padding Bottom', 'bdevselement'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 5,
					]
				],
				'selectors' => [
					'{{WRAPPER}} .feature.feature-area' => 'padding-bottom: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .history-area' => 'padding-bottom: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'design_style' => ['style_7', 'style_8', 'style_9', 'style_10']
				]
			]
		);

		$this->end_controls_section();


		$this->start_controls_section(
			'_section_title',
			[
				'label' => __('Title & Description', 'bdevselement'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'sub_title',
			[
				'label' => __('Sub Title', 'bdevselement'),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => __('bdevs Info Box Sub Title', 'bdevselement'),
				'placeholder' => __('Type Info Box Sub Title', 'bdevselement'),
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->add_control(
			'title',
			[
				'label' => __('Title', 'bdevselement'),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => __('bdevs Info Box Title', 'bdevselement'),
				'placeholder' => __('Type Info Box Title', 'bdevselement'),
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->add_control(
			'description',
			[
				'label' => __('Description', 'bdevselement'),
				'description' => bdevs_element_get_allowed_html_desc('intermediate'),
				'type' => Controls_Manager::TEXTAREA,
				'default' => __('bdevs info box description goes here', 'bdevselement'),
				'placeholder' => __('Type info box description', 'bdevselement'),
				'rows' => 5,
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'_section_about_image',
			[
				'label' => __('Image', 'bdevselement'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'bg_image',
			[
				'label' => __('Image', 'bdevselement'),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->add_control(
			'thumb_image',
			[
				'label' => __('Thumb Image', 'bdevselement'),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'condition' => [
					'design_style' => 'style_6'
				],
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->add_control(
			'video_url',
			[
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'show_label' => true,
				'label' => __('Video URL', 'bdevselement'),
				'default' => __('#', 'bdevselement'),
				'placeholder' => __('url here', 'bdevselement'),
				'condition' => [
					'design_style' => ['style_2', 'style_7', 'style_8']
				],
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->add_control(
			'extra_info_num',
			[
				'label' => __('Extra Info Num', 'bdevselement'),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __('35', 'bdevselement'),
				'condition' => [
					'design_style' => 'style_1'
				],
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->add_control(
			'extra_info_text',
			[
				'label' => __('Extra Info Text', 'bdevselement'),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __('year', 'bdevselement'),
				'condition' => [
					'design_style' => 'style_1'
				],
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'_section_features_list',
			[
				'label' => __('Features List', 'bdevselement'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'field_condition',
			[
				'label' => __('Field condition', 'bdevselement'),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'style_1' => __('Style 1', 'bdevselement'),
					'style_2' => __('Style 2', 'bdevselement'),
					'style_2_2' => __('Style 2.2', 'bdevselement'),
					'style_8' => __('Style 8', 'bdevselement'),
					'style_10' => __('Style 10', 'bdevselement'),
				],
				'default' => 'style_1',
				'frontend_available' => true,
				'style_transfer' => true,
			]
		);

		$repeater->add_control(
			'number',
			[
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'label' => __('Number', 'bdevselement'),
				'placeholder' => __('Type Number', 'bdevselement'),
				'condition' => [
					'field_condition' => ['style_8', 'style_10']
				],
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$repeater->add_control(
			'title',
			[
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'label' => __('Title', 'bdevselement'),
				'placeholder' => __('Type title here', 'bdevselement'),
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$repeater->add_control(
			'description',
			[
				'type' => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'label' => __('Description', 'bdevselement'),
				'placeholder' => __('Type sub title here', 'bdevselement'),
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$repeater->add_control(
			'image',
			[
				'label' => __('Image', 'bdevselement'),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'condition' => [
					'field_condition' => ['style_2', 'style_2_2']
				],
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$repeater->add_control(
			'selected_icon',
			[
				'type' => Controls_Manager::ICONS,
				'fa4compatibility' => 'icon',
				'label_block' => true,
				'condition' => [
					'field_condition' => 'style_1'
				],
				'default' => [
					'value' => 'fas fa-smile-wink',
					'library' => 'fa-solid',
				]
			]
		);

		$this->add_control(
			'slides',
			[
				'show_label' => false,
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '<# print(title || "Carousel Item"); #>',
			]
		);

		$this->end_controls_section();


		$this->start_controls_section(
			'_section_button',
			[
				'label' => __('Button', 'bdevselement'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'button_text',
			[
				'label' => __('Text', 'bdevselement'),
				'type' => Controls_Manager::TEXT,
				'default' => __('Button Text', 'bdevselement'),
				'placeholder' => __('Type button text here', 'bdevselement'),
				'label_block' => true,
				'dynamic' => [
					'active' => true,
				]
			]
		);

		$this->add_control(
			'button_link',
			[
				'label' => __('Link', 'bdevselement'),
				'type' => Controls_Manager::URL,
				'placeholder' => __('http://elementor.bdevs.net/', 'bdevselement'),
				'dynamic' => [
					'active' => true,
				]
			]
		);

		if (bdevs_element_is_elementor_version('<', '2.6.0')) {
			$this->add_control(
				'button_icon',
				[
					'label' => __('Icon', 'bdevselement'),
					'label_block' => true,
					'type' => Controls_Manager::ICON,
					'options' => bdevs_element_get_bdevs_element_icons(),
					'default' => 'fa fa-angle-right',
				]
			);

			$condition = ['button_icon!' => ''];
		} else {
			$this->add_control(
				'button_selected_icon',
				[
					'type' => Controls_Manager::ICONS,
					'fa4compatibility' => 'button_icon',
					'label_block' => true,
				]
			);
			$condition = ['button_selected_icon[value]!' => ''];
		}

		$this->add_control(
			'button_icon_position',
			[
				'label' => __('Icon Position', 'bdevselement'),
				'type' => Controls_Manager::CHOOSE,
				'label_block' => false,
				'options' => [
					'before' => [
						'title' => __('Before', 'bdevselement'),
						'icon' => 'eicon-h-align-left',
					],
					'after' => [
						'title' => __('After', 'bdevselement'),
						'icon' => 'eicon-h-align-right',
					],
				],
				'default' => 'after',
				'toggle' => false,
				'condition' => $condition,
				'style_transfer' => true,
			]
		);

		$this->add_control(
			'button_icon_spacing',
			[
				'label' => __('Icon Spacing', 'bdevselement'),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 10
				],
				'condition' => $condition,
				'selectors' => [
					'{{WRAPPER}} .btn--icon-before .btn-icon' => 'margin-right: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .btn--icon-after .btn-icon' => 'margin-left: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();
	}

	/**
	 * Register styles related controls
	 */
	protected function register_style_controls()
	{
		$this->start_controls_section(
			'_section_media_style',
			[
				'label' => __('Icon / Image', 'bdevselement'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'offset_toggle',
			[
				'label' => __('Offset', 'bdevselement'),
				'type' => Controls_Manager::POPOVER_TOGGLE,
				'label_off' => __('None', 'bdevselement'),
				'label_on' => __('Custom', 'bdevselement'),
				'return_value' => 'yes',
			]
		);

		$this->start_popover();

		$this->add_responsive_control(
			'media_offset_x',
			[
				'label' => __('Offset Left', 'bdevselement'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'condition' => [
					'offset_toggle' => 'yes'
				],
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
					],
				],
				'render_type' => 'ui',
			]
		);

		$this->add_responsive_control(
			'media_offset_y',
			[
				'label' => __('Offset Top', 'bdevselement'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'condition' => [
					'offset_toggle' => 'yes'
				],
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
					],
				],
				'selectors' => [
					// Media translate styles
					'(desktop){{WRAPPER}} .about-thumb-wrap img' => '-ms-transform: translate({{media_offset_x.SIZE || 0}}{{UNIT}}, {{media_offset_y.SIZE || 0}}{{UNIT}}); -webkit-transform: translate({{media_offset_x.SIZE || 0}}{{UNIT}}, {{media_offset_y.SIZE || 0}}{{UNIT}}); transform: translate({{media_offset_x.SIZE || 0}}{{UNIT}}, {{media_offset_y.SIZE || 0}}{{UNIT}});',
					'(tablet){{WRAPPER}} .about-thumb-wrap img' => '-ms-transform: translate({{media_offset_x_tablet.SIZE || 0}}{{UNIT}}, {{media_offset_y_tablet.SIZE || 0}}{{UNIT}}); -webkit-transform: translate({{media_offset_x_tablet.SIZE || 0}}{{UNIT}}, {{media_offset_y_tablet.SIZE || 0}}{{UNIT}}); transform: translate({{media_offset_x_tablet.SIZE || 0}}{{UNIT}}, {{media_offset_y_tablet.SIZE || 0}}{{UNIT}});',
					'(mobile){{WRAPPER}} .about-thumb-wrap img' => '-ms-transform: translate({{media_offset_x_mobile.SIZE || 0}}{{UNIT}}, {{media_offset_y_mobile.SIZE || 0}}{{UNIT}}); -webkit-transform: translate({{media_offset_x_mobile.SIZE || 0}}{{UNIT}}, {{media_offset_y_mobile.SIZE || 0}}{{UNIT}}); transform: translate({{media_offset_x_mobile.SIZE || 0}}{{UNIT}}, {{media_offset_y_mobile.SIZE || 0}}{{UNIT}});',
					// Body text styles
					'{{WRAPPER}} .about-thumb-wrap' => 'margin-top: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_popover();

		$this->add_responsive_control(
			'media_spacing',
			[
				'label' => __('Bottom Spacing', 'bdevselement'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'selectors' => [
					'{{WRAPPER}} .about-thumb-wrap' => 'margin-bottom: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);

		$this->add_responsive_control(
			'media_padding',
			[
				'label' => __('Padding', 'bdevselement'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'selectors' => [
					'{{WRAPPER}} .bdevs-infobox-figure--image img, {{WRAPPER}} .about-thumb-wrap i' => 'padding: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'media_border',
				'selector' => '{{WRAPPER}} .bdevs-infobox-figure--image img, {{WRAPPER}} .about-thumb-wrap i',
			]
		);

		$this->add_responsive_control(
			'media_border_radius',
			[
				'label' => __('Border Radius', 'bdevselement'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .about-thumb-wrap img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .about-thumb-wrap i' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'media_box_shadow',
				'exclude' => [
					'box_shadow_position',
				],
				'selector' => '{{WRAPPER}} .about-thumb-wrap img, {{WRAPPER}} .about-thumb-wrap i'
			]
		);

		$this->add_control(
			'icon_color',
			[
				'label' => __('Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .about-thumb-wrap i' => 'color: {{VALUE}}',
				],
				'condition' => [
					'type' => 'icon'
				]
			]
		);

		$this->add_control(
			'icon_bg_color',
			[
				'label' => __('Background Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .about-thumb-wrap i' => 'background-color: {{VALUE}};',
				],
				'condition' => [
					'type' => 'icon'
				]
			]
		);

		$this->add_control(
			'icon_bg_rotate',
			[
				'label' => __('Background Rotate', 'bdevselement'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['deg'],
				'default' => [
					'unit' => 'deg',
				],
				'range' => [
					'deg' => [
						'min' => 0,
						'max' => 360,
					],
				],
				'selectors' => [
					// Icon rotate styles
					'{{WRAPPER}} .about-thumb-wrap img i' => '-ms-transform: rotate(-{{SIZE}}{{UNIT}}); -webkit-transform: rotate(-{{SIZE}}{{UNIT}}); transform: rotate(-{{SIZE}}{{UNIT}});',
					// Icon box transform styles
					'(desktop){{WRAPPER}} .about-thumb-wrap i' => '-ms-transform: translate({{media_offset_x.SIZE || 0}}px, {{media_offset_y.SIZE || 0}}px) rotate({{SIZE}}deg); -webkit-transform: translate({{media_offset_x.SIZE || 0}}px, {{media_offset_y.SIZE || 0}}px) rotate({{SIZE}}deg); transform: translate({{media_offset_x.SIZE || 0}}px, {{media_offset_y.SIZE || 0}}px) rotate({{SIZE}}deg);',
					'(tablet){{WRAPPER}} .about-thumb-wrap i' => '-ms-transform: translate({{media_offset_x_tablet.SIZE || 0}}px, {{media_offset_y_tablet.SIZE || 0}}px) rotate({{SIZE}}deg); -webkit-transform: translate({{media_offset_x_tablet.SIZE || 0}}px, {{media_offset_y_tablet.SIZE || 0}}px) rotate({{SIZE}}deg); transform: translate({{media_offset_x_tablet.SIZE || 0}}px, {{media_offset_y_tablet.SIZE || 0}}px) rotate({{SIZE}}deg);',
					'(mobile){{WRAPPER}} .about-thumb-wrap i' => '-ms-transform: translate({{media_offset_x_mobile.SIZE || 0}}px, {{media_offset_y_mobile.SIZE || 0}}px) rotate({{SIZE}}deg); -webkit-transform: translate({{media_offset_x_mobile.SIZE || 0}}px, {{media_offset_y_mobile.SIZE || 0}}px) rotate({{SIZE}}deg); transform: translate({{media_offset_x_mobile.SIZE || 0}}px, {{media_offset_y_mobile.SIZE || 0}}px) rotate({{SIZE}}deg);',
				],
			]
		);

		$this->end_controls_section();

		// profile style
		$this->start_controls_section(
			'_section_profile_style',
			[
				'label' => __('Profile', 'bdevselement'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'profile_magin',
			[
				'label' => __('Margin', 'bdevselement'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .thumb' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'profile_h_color',
			[
				'label' => __('Title Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .name' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'profile_desig_color',
			[
				'label' => __('Title Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .designation' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();

		// Title & Description style
		$this->start_controls_section(
			'_section_title_style',
			[
				'label' => __('Title & Description', 'bdevselement'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'content_padding',
			[
				'label' => __('Content Box Padding', 'bdevselement'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .about-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'title_heading',
			[
				'type' => Controls_Manager::HEADING,
				'label' => __('Title', 'bdevselement'),
				'separator' => 'before'
			]
		);

		$this->add_responsive_control(
			'title_spacing',
			[
				'label' => __('Bottom Spacing', 'bdevselement'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'selectors' => [
					'{{WRAPPER}} .section-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' => __('Text Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .section-title' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __('Typography', 'bdevselement'),
				'selector' => '{{WRAPPER}} .section-title',
				//'scheme' => Typography::TYPOGRAPHY_2
			]
		);

		$this->add_control(
			'description_heading',
			[
				'type' => Controls_Manager::HEADING,
				'label' => __('Description', 'bdevselement'),
				'separator' => 'before'
			]
		);

		$this->add_responsive_control(
			'description_spacing',
			[
				'label' => __('Bottom Spacing', 'bdevselement'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'selectors' => [
					'{{WRAPPER}} .section-heading p' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'description_color',
			[
				'label' => __('Text Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .section-heading p' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'description_typography',
				'label' => __('Typography', 'bdevselement'),
				'selector' => '{{WRAPPER}} .section-heading p',
				//'scheme' => Typography::TYPOGRAPHY_3,
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'_section_style_button',
			[
				'label' => __('List Item', 'bdevselement'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'icon_size',
			[
				'label' => __('Size', 'bdevselement'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range' => [
					'px' => [
						'min' => 10,
						'max' => 300,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .about-list .single-item .icon' => 'font-size: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'type' => 'icon'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'btn_typography',
				'selector' => '{{WRAPPER}} .about-list .single-item span',
				//'scheme' => Typography::TYPOGRAPHY_4,
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'button_border',
				'selector' => '{{WRAPPER}} .about-list .single-item .icon',
			]
		);

		$this->add_control(
			'button_border_radius',
			[
				'label' => __('Border Radius', 'bdevselement'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .single-item .icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'button_box_shadow',
				'selector' => '{{WRAPPER}} .about-list .single-item .icon',
			]
		);

		$this->add_control(
			'hr',
			[
				'type' => Controls_Manager::DIVIDER,
				'style' => 'thick',
			]
		);

		$this->start_controls_tabs('_tabs_button');

		$this->start_controls_tab(
			'_tab_button_normal',
			[
				'label' => __('Normal', 'bdevselement'),
			]
		);

		$this->add_control(
			'link_color',
			[
				'label' => __('Text Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .single-item .icon' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'border_color',
			[
				'label' => __('Border Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .single-item .icon' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'button_bg_color',
			[
				'label' => __('Background Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single-item .icon' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'button_icon_translate',
			[
				'label' => __('Icon Translate X', 'bdevselement'),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => -100,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .single-item .icon' => '-webkit-transform: translateX(calc(-1 * {{SIZE}}{{UNIT}})); transform: translateX(calc(-1 * {{SIZE}}{{UNIT}}));',
					'{{WRAPPER}} .single-item .icon' => '-webkit-transform: translateX({{SIZE}}{{UNIT}}); transform: translateX({{SIZE}}{{UNIT}});',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'_tab_button_hover',
			[
				'label' => __('Hover', 'bdevselement'),
			]
		);

		$this->add_control(
			'link_hover_color',
			[
				'label' => __('Text Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single-item:hover .icon, {{WRAPPER}} .single-item:focus .icon' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'border_hover_color',
			[
				'label' => __('Border Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .single-item:hover .icon' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'button_hover_bg_color',
			[
				'label' => __('Background Color', 'bdevselement'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single-item:hover .icon, {{WRAPPER}} .single-item:focus .icon' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'button_hover_icon_translate',
			[
				'label' => __('Icon Translate X', 'bdevselement'),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 0
				],
				'range' => [
					'px' => [
						'min' => -100,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .single-item:hover .icon' => '-webkit-transform: translateX(calc(-1 * {{SIZE}}{{UNIT}})); transform: translateX(calc(-1 * {{SIZE}}{{UNIT}}));',
					'{{WRAPPER}} .single-item:hover .icon' => '-webkit-transform: translateX({{SIZE}}{{UNIT}}); transform: translateX({{SIZE}}{{UNIT}});',
				],
			]
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();

		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();

?>

		<?php if ($settings['design_style'] === 'style_10'):
			$this->add_inline_editing_attributes('button_text', 'none');
			$this->add_render_attribute('button_text', 'class', 'bdevs-btn-text');
			$this->add_render_attribute('button', 'class', 'btn btn--blue btn--icon white-color aos-init aos-animate');
			$this->add_render_attribute('button', 'data-aos', 'fade-up');
			$this->add_link_attributes('button', $settings['button_link']);
		?>

			<section class="feature feature-area skills grey-bg pt-125 pb-60 fix">
				<div class="container">
					<div class="row align-items-center">
						<div class="col-lg-8 offset-lg-2 text-center">
							<div class="theme">
								<?php if (!empty($settings['sub_title'])) : ?>
									<span class="theme__small--title fw-700 text-uppercase"><span></span>
										<?php echo bdevs_element_kses_intermediate($settings['sub_title']); ?>
										<span></span></span>
								<?php endif; ?>
								<?php if (!empty($settings['title'])) : ?>
									<h2 class="theme__big--title fw-700 mb-70">
										<?php print bdevs_element_kses_basic($settings['title']); ?>
									</h2>
								<?php endif; ?>
							</div>
						</div>
						<div class="col-sm-12 mb-30">
							<div class="skills__content">
								<div class="row justify-content-between">
									<?php foreach ($settings['slides'] as $slide) : ?>
										<div class="col-lg-5">
											<div class="single-skill position-relative mb-40">
												<?php if (!empty($slide['title'])) : ?>
													<div class="bar-title">
														<h5 class="fw-600">
															<?php print bdevs_element_kses_basic($slide['title']); ?>
														</h5>
													</div>
												<?php endif; ?>
												<?php if (!empty($slide['number'])) : ?>
													<div class="progress-border progress-border-2">
														<div class="progress">
															<div class="progress-bar wow slideInLeft" data-wow-duration="1s"
																data-wow-delay=".6s" role="progressbar"
																style="width: <?php print $slide['number']; ?>%;"
																aria-valuenow="<?php print $slide['number']; ?>"
																aria-valuemin="0" aria-valuemax="100">
																<span><?php print $slide['number']; ?>%</span>
															</div>
														</div>
													</div>
												<?php endif; ?>
											</div>
										</div>
									<?php endforeach; ?>
								</div>
							</div>
						</div>
					</div>
				</div>
			</section>

		<?php elseif ($settings['design_style'] === 'style_9'):

			$this->add_inline_editing_attributes('button_text', 'none');
			$this->add_render_attribute('button_text', 'class', 'bdevs-btn-text');
			$this->add_render_attribute('button', 'class', 'btn btn--blue btn--icon white-color aos-init aos-animate');
			$this->add_render_attribute('button', 'data-aos', 'fade-up');
			$this->add_link_attributes('button', $settings['button_link']);
		?>

			<section class="feature feature-area fix">
				<div class="container">
					<div class="row">
						<div class="col-lg-5 col-md-8 mb-30">
							<div class="feature__content--ex theme">
								<?php if (!empty($settings['sub_title'])) : ?>
									<span class="theme__small--title theme__small--title-left fw-700 text-uppercase"><span></span>
										<?php echo bdevs_element_kses_intermediate($settings['sub_title']); ?>
									</span>
								<?php endif; ?>
								<?php if (!empty($settings['title'])) : ?>
									<h2 class="theme-color fw-700 mb-20">
										<?php print bdevs_element_kses_basic($settings['title']); ?>
									</h2>
								<?php endif; ?>
								<?php if (!empty($settings['description'])) : ?>
									<p class="mb-30"><?php echo bdevs_element_kses_intermediate($settings['description']); ?></p>
								<?php endif; ?>

								<?php if ($settings['button_text'] && ((empty($settings['button_selected_icon']) || empty($settings['button_selected_icon']['value'])) && empty($settings['button_icon']))) :
									$this->add_render_attribute('button', 'class', 'site-btn transparent');
									printf(
										'<a %1$s>%2$s</a>',
										$this->get_render_attribute_string('button'),
										esc_html($settings['button_text'])
									);
								elseif (empty($settings['button_text']) && (!(empty($settings['button_selected_icon']) || empty($settings['button_selected_icon']['value'])) || !empty($settings['button_icon']))) : ?>
									<a <?php $this->print_render_attribute_string('button'); ?>><?php bdevs_element_render_icon($settings, 'button_icon', 'button_selected_icon'); ?></a>
									<?php elseif ($settings['button_text'] && (!(empty($settings['button_selected_icon']) || empty($settings['button_selected_icon']['value'])) || !empty($settings['button_icon']))) :
									if ($settings['button_icon_position'] === 'before') :
										$this->add_render_attribute('button', 'class', 'site-btn transparent btn--icon-before');
										$button_text = sprintf('<span %1$s>%2$s</span>', $this->get_render_attribute_string('button_text'), esc_html($settings['button_text']));
									?>
										<a <?php $this->print_render_attribute_string('button'); ?>><?php bdevs_element_render_icon($settings, 'button_icon', 'button_selected_icon', ['class' => 'btn-icon']); ?><?php echo $button_text; ?></a>
									<?php
									else :
										$this->add_render_attribute('button', 'class', 'btn--icon-after');
										$button_text = sprintf('<span %1$s>%2$s</span>', $this->get_render_attribute_string('button_text'), esc_html($settings['button_text']));
									?>
										<a <?php $this->print_render_attribute_string('button'); ?>><?php echo $button_text; ?><?php bdevs_element_render_icon($settings, 'button_icon', 'button_selected_icon', ['class' => 'btn-icon']); ?></a>
								<?php
									endif;
								endif; ?>
							</div>
						</div>
						<div class="col-lg-6 offset-lg-1 mb-30">
							<div class="feature__content--ex feature__content--ex-3 theme">
								<?php foreach ($settings['slides'] as $slide) : ?>
									<div class="feature__list d-flex">
										<?php if (!empty($slide['selected_icon']['value'])): ?>
											<div class="feature__list--icon">
												<?php \Elementor\Icons_Manager::render_icon($slide['selected_icon']); ?>
											</div>
										<?php endif; ?>
										<div class="feature__list--content">
											<?php if (!empty($slide['title'])) : ?>
												<h4 class="fw-700 mb-10">
													<?php print bdevs_element_kses_basic($slide['title']); ?>
												</h4>
											<?php endif; ?>
											<?php if (!empty($slide['description'])) : ?>
												<p><?php echo bdevs_element_kses_intermediate($slide['description']); ?></p>
											<?php endif; ?>
										</div>
									</div>
								<?php endforeach; ?>
							</div>
						</div>
					</div>
				</div>
			</section>

		<?php elseif ($settings['design_style'] === 'style_8'):

			if (!empty($settings['bg_image']['id'])) {
				$bg_image = wp_get_attachment_image_url($settings['bg_image']['id'], 'full');
			}

			$this->add_inline_editing_attributes('button_text', 'none');
			$this->add_render_attribute('button_text', 'class', 'bdevs-btn-text');
			$this->add_render_attribute('button', 'class', 'read-more');
			$this->add_link_attributes('button', $settings['button_link']);
		?>

			<section class="feature pb-100 pt-130 position-relative">
				<div class="history__left--thumb history__left--thumb-3 d-none d-xl-block"
					style="background-image: url(<?php print $bg_image; ?>)">
					<?php if (!empty($settings['video_url'])) : ?>
						<a class="popup-video" href="<?php print esc_url($settings['video_url']); ?>"><i
								class="fas fa-play"></i></a>
					<?php endif; ?>
				</div>
				<div class="container-fluid">
					<div class="row align-items-center">
						<div class="col-xl-4 offset-xl-7 col-lg-8 offset-lg-2 mb-30">
							<div class="best-feature--right">
								<div class="theme">
									<?php if (!empty($settings['sub_title'])) : ?>
										<span class="theme__small--title theme__small--title-left fw-700 text-uppercase"><span></span>
											<?php echo bdevs_element_kses_intermediate($settings['sub_title']); ?>
										</span>
									<?php endif; ?>
									<?php if (!empty($settings['title'])) : ?>
										<h2 class="theme-color fw-700 mb-30">
											<?php print bdevs_element_kses_basic($settings['title']); ?>
										</h2>
									<?php endif; ?>
									<?php if (!empty($settings['description'])) : ?>
										<p class="mb-40 pr-15">
											<?php print bdevs_element_kses_basic($settings['description']); ?>
										</p>
									<?php endif; ?>
								</div>

								<?php foreach ($settings['slides'] as $slide) : ?>
									<div class="skill-wrapper mb-40 d-flex align-items-center">
										<div class="skill-circle">
											<?php if (!empty($slide['number'])) : ?>
												<div class="progress-circular">
													<input type="text" class="knob" value="0"
														data-rel="<?php print $slide['number']; ?>" data-linecap="round"
														data-width="109" data-bgcolor="#e8e8eb" data-fgcolor="#221f3c"
														data-thickness=".15" data-readonly="true" disabled>
												</div>
											<?php endif; ?>
										</div>
										<div class="skill-circle-text">
											<?php if (!empty($slide['title'])) : ?>
												<h3>
													<?php print bdevs_element_kses_basic($slide['title']); ?>
												</h3>
											<?php endif; ?>
											<?php if (!empty($slide['description'])) : ?>
												<p><?php echo bdevs_element_kses_intermediate($slide['description']); ?></p>
											<?php endif; ?>
										</div>
									</div>
								<?php endforeach; ?>
							</div>
						</div>
					</div>
				</div>
			</section>

		<?php elseif ($settings['design_style'] === 'style_7'):

			if (!empty($settings['bg_image']['id'])) {
				$bg_image = wp_get_attachment_image_url($settings['bg_image']['id'], 'full');
			}

			$this->add_inline_editing_attributes('button_text', 'none');
			$this->add_render_attribute('button_text', 'class', 'bdevs-btn-text');
			$this->add_render_attribute('button', 'class', 'read-more');
			$this->add_link_attributes('button', $settings['button_link']);
		?>
			<section class="history-area grey-bg position-relative fix">
				<div class="history__left--thumb history__right--thumb d-none d-xl-block"
					style="background-image: url(<?php print $bg_image; ?>)">
					<?php if (!empty($settings['video_url'])) : ?>
						<a class="popup-video" href="<?php print esc_url($settings['video_url']); ?>"><i
								class="fas fa-play"></i></a>
					<?php endif; ?>
				</div>
				<div class="container-fluid">
					<div class="row">
						<div class="col-xl-4 offset-xl-1 col-lg-12 mb-30">
							<div class="feature__content--ex feature__content--ex-2 theme">
								<?php if (!empty($settings['sub_title'])) : ?>
									<span class="theme__small--title theme__small--title-left fw-700 text-uppercase"><span></span>
										<?php echo bdevs_element_kses_intermediate($settings['sub_title']); ?>
									</span>
								<?php endif; ?>
								<?php if (!empty($settings['title'])) : ?>
									<h2 class="theme-color fw-700 mb-30">
										<?php print bdevs_element_kses_basic($settings['title']); ?>
									</h2>
								<?php endif; ?>
								<?php if (!empty($settings['slides'])): ?>
									<div class="row">
										<?php foreach ($settings['slides'] as $slide) : ?>
											<div class="feature__list d-flex col-xl-12 col-lg-4 col-md-6">
												<?php if (!empty($slide['selected_icon']['value'])): ?>
													<div class="feature__list--icon">
														<?php \Elementor\Icons_Manager::render_icon($slide['selected_icon']); ?>
													</div>
												<?php endif; ?>
												<div class="feature__list--content">
													<?php if (!empty($slide['title'])) : ?>
														<h5 class="fw-700 mb-10">
															<?php print bdevs_element_kses_basic($slide['title']); ?>
														</h5>
													<?php endif; ?>
													<?php if (!empty($slide['description'])) : ?>
														<p><?php echo bdevs_element_kses_intermediate($slide['description']); ?></p>
													<?php endif; ?>
												</div>
											</div>
										<?php endforeach; ?>
									</div><?php endif; ?>
							</div>
						</div>
					</div>
				</div>
			</section>
		<?php elseif ($settings['design_style'] === 'style_6'):
			if (!empty($settings['bg_image']['id'])) {
				$bg_image = wp_get_attachment_image_url($settings['bg_image']['id'], 'full');
			}

			if (!empty($settings['thumb_image']['id'])) {
				$thumb_image = wp_get_attachment_image_url($settings['thumb_image']['id'], 'full');
			}

			$this->add_inline_editing_attributes('button_text', 'none');
			$this->add_render_attribute('button_text', 'class', 'bdevs-btn-text');
			$this->add_render_attribute('button', 'class', 'read-more');
			$this->add_link_attributes('button', $settings['button_link']);
		?>
			<section class="feature feature-area pt-125 pb-100 fix">
				<div class="container">
					<div class="row">
						<div class="col-lg-5 mb-30">
							<div class="about-ex theme">
								<?php if (!empty($settings['sub_title'])) : ?>
									<span class="theme__small--title theme__small--title-left fw-700 text-uppercase"><span></span>
										<?php echo bdevs_element_kses_intermediate($settings['sub_title']); ?>
									</span>
								<?php endif; ?>

								<?php if (!empty($settings['title'])) : ?>
									<h2 class="theme-color fw-700 mb-30">
										<?php print bdevs_element_kses_basic($settings['title']); ?>
									</h2>
								<?php endif; ?>
								<?php if (!empty($settings['description'])) : ?>
									<p class="mb-20">
										<?php echo bdevs_element_kses_intermediate($settings['description']); ?>
									</p>
								<?php endif; ?>

								<?php if ($settings['button_text'] && ((empty($settings['button_selected_icon']) || empty($settings['button_selected_icon']['value'])) && empty($settings['button_icon']))) :
									$this->add_render_attribute('button', 'class', 'site-btn transparent');
									printf(
										'<a %1$s>%2$s</a>',
										$this->get_render_attribute_string('button'),
										esc_html($settings['button_text'])
									);
								elseif (empty($settings['button_text']) && (!(empty($settings['button_selected_icon']) || empty($settings['button_selected_icon']['value'])) || !empty($settings['button_icon']))) : ?>
									<a <?php $this->print_render_attribute_string('button'); ?>><?php bdevs_element_render_icon($settings, 'button_icon', 'button_selected_icon'); ?></a>
									<?php elseif ($settings['button_text'] && (!(empty($settings['button_selected_icon']) || empty($settings['button_selected_icon']['value'])) || !empty($settings['button_icon']))) :
									if ($settings['button_icon_position'] === 'before') :
										$this->add_render_attribute('button', 'class', 'site-btn transparent btn--icon-before');
										$button_text = sprintf('<span %1$s>%2$s</span>', $this->get_render_attribute_string('button_text'), esc_html($settings['button_text']));
									?>
										<a <?php $this->print_render_attribute_string('button'); ?>><?php bdevs_element_render_icon($settings, 'button_icon', 'button_selected_icon', ['class' => 'btn-icon']); ?><?php echo $button_text; ?></a>
									<?php
									else :
										$this->add_render_attribute('button', 'class', 'btn--icon-after');
										$button_text = sprintf('<span %1$s>%2$s</span>', $this->get_render_attribute_string('button_text'), esc_html($settings['button_text']));
									?>
										<a <?php $this->print_render_attribute_string('button'); ?>><?php echo $button_text; ?><?php bdevs_element_render_icon($settings, 'button_icon', 'button_selected_icon', ['class' => 'btn-icon']); ?></a>
								<?php
									endif;
								endif; ?>
							</div>
						</div>
						<div class="col-lg-7 mb-30">
							<div class="about-img position-relative">
								<img src="<?php print esc_url($bg_image); ?>" alt="img">
								<div class="about-img--2 d-none d-md-block">
									<img src="<?php print esc_url($thumb_image); ?>" alt="img">
								</div>
							</div>
						</div>
					</div>
				</div>
			</section>
		<?php elseif ($settings['design_style'] === 'style_5'):
			// bg_image

			if (!empty($settings['bg_image']['id'])) {
				$bg_image = wp_get_attachment_image_url($settings['bg_image']['id'], 'full');
			}

			$this->add_inline_editing_attributes('button_text', 'none');
			$this->add_render_attribute('button_text', 'class', 'bdevs-btn-text');
			$this->add_render_attribute('button', 'class', 'btn btn--blue white-color aos-init aos-animate');
			$this->add_render_attribute('button', 'data-aos', 'fade-up');
			$this->add_link_attributes('button', $settings['button_link']);
		?>

			<section class="about grey-bg pb-80 fix">
				<div class="container pt-130">
					<div class="row ">
						<div class="col-lg-5">
							<div class="theme">
								<?php if (!empty($settings['sub_title'])) : ?>
									<span class="theme__small--title fw-700 text-uppercase theme__small--title-left"><span></span>
										<?php echo bdevs_element_kses_intermediate($settings['sub_title']); ?>
									</span>
								<?php endif; ?>
								<?php if (!empty($settings['title'])) : ?>
									<h2 class="theme__big--title fw-700 mb-30">
										<?php print bdevs_element_kses_basic($settings['title']); ?>
									</h2>
								<?php endif; ?>
							</div>
							<div class="about-tabs">
								<ul class="nav nav-tabs" id="myTab" role="tablist">
									<?php
									$count = 1;
									foreach ($settings['slides'] as $slide) :
										$selected = "false";
										$active = "";
										if ($count == 1) {
											$selected = "true";
											$active = "active";
										}
									?>
										<?php if (!empty($slide['title'])) : ?>
											<li class="nav-item">
												<a class="nav-link <?php echo $active ?>" id="h-tabs-<?php echo $count; ?>"
													data-toggle="tab" href="#h-tab-<?php echo $count; ?>" role="tab"
													aria-controls="h-tab-<?php echo $count; ?>"
													aria-selected="<?php echo $selected ?>">
													<?php if (!empty($slide['icon']) || !empty($slide['selected_icon']['value'])) : ?>
														<?php bdevs_element_render_icon($slide, 'icon', 'selected_icon'); ?>
														<?php endif; ?><?php print bdevs_element_kses_basic($slide['title']); ?>
												</a>
											</li>
										<?php endif; ?>
									<?php
										$count++;
									endforeach;
									?>
								</ul>
								<div class="tab-content" id="myTabContent">
									<?php
									$count = 1;
									foreach ($settings['slides'] as $slide) :
										$active = "";
										if ($count == 1) {
											$active = "show active";
										}

										if (!empty($slide['image']['id'])) {
											$image = wp_get_attachment_image_url($slide['image']['id'], 'full');
										}
									?>
										<?php if (!empty($slide['title'])) : ?>
											<div class="tab-pane fade <?php echo $active ?>" id="h-tab-<?php echo $count; ?>"
												role="tabpanel"
												aria-labelledby="h-tabs-<?php echo $count; ?>">
												<?php if (!empty($slide['description'])): ?>
													<div class="content">
														<?php print wp_kses_post($slide['description']); ?>
													</div>
												<?php endif; ?>
											</div>
										<?php endif; ?>
									<?php
										$count++;
									endforeach; ?>
								</div>
							</div>
						</div>
						<div class="col-lg-6 offset-lg-1">
							<div class="about-thumb position-relative">
								<?php if (!empty($settings['description'])) : ?>
									<span>
										<?php print bdevs_element_kses_basic($settings['description']); ?>
									</span>
								<?php endif; ?>
								<img src="<?php print esc_url($bg_image); ?>" alt="img">
								<div class="about__shape--h5">
									<img src="<?php echo get_template_directory_uri(); ?>/assets/images/shape/about-circle-shape.png"
										alt="img">
								</div>
							</div>
						</div>
					</div>
				</div>
			</section>

		<?php elseif ($settings['design_style'] === 'style_4'):

			$this->add_inline_editing_attributes('button_text', 'none');
			$this->add_render_attribute('button_text', 'class', 'bdevs-btn-text');
			$this->add_render_attribute('button', 'class', 'btn btn--blue white-color aos-init aos-animate');
			$this->add_render_attribute('button', 'data-aos', 'fade-up');
			$this->add_link_attributes('button', $settings['button_link']);

			if (!empty($settings['bg_image']['id'])) {
				$bg_image = wp_get_attachment_image_url($settings['bg_image']['id'], 'full');
			}
		?>

			<section class="history-area position-relative pt-30 pb-100 fix">
				<div class="container">
					<div class="row align-items-center">
						<div class="col-lg-5 mb-30">
							<div class="theme">
								<?php if (!empty($settings['sub_title'])) : ?>
									<span class="theme__small--title theme__small--title-left fw-700 text-uppercase"><span></span>
										<?php echo bdevs_element_kses_intermediate($settings['sub_title']); ?>
									</span>
								<?php endif; ?>

								<?php if (!empty($settings['title'])) : ?>
									<h2 class="theme__big--title fw-700 mb-25">
										<?php print bdevs_element_kses_basic($settings['title']); ?>
									</h2>
								<?php endif; ?>
								<?php if (!empty($settings['description'])) : ?>
									<p class="mb-40">
										<?php echo bdevs_element_kses_intermediate($settings['description']); ?>
									</p>
								<?php endif; ?>

								<?php if ($settings['button_text'] && ((empty($settings['button_selected_icon']) || empty($settings['button_selected_icon']['value'])) && empty($settings['button_icon']))) :
									$this->add_render_attribute('button', 'class', 'site-btn transparent');
									printf(
										'<a %1$s>%2$s</a>',
										$this->get_render_attribute_string('button'),
										esc_html($settings['button_text'])
									);
								elseif (empty($settings['button_text']) && (!(empty($settings['button_selected_icon']) || empty($settings['button_selected_icon']['value'])) || !empty($settings['button_icon']))) : ?>
									<a <?php $this->print_render_attribute_string('button'); ?>><?php bdevs_element_render_icon($settings, 'button_icon', 'button_selected_icon'); ?></a>
									<?php elseif ($settings['button_text'] && (!(empty($settings['button_selected_icon']) || empty($settings['button_selected_icon']['value'])) || !empty($settings['button_icon']))) :
									if ($settings['button_icon_position'] === 'before') :
										$this->add_render_attribute('button', 'class', 'site-btn transparent btn--icon-before');
										$button_text = sprintf('<span %1$s>%2$s</span>', $this->get_render_attribute_string('button_text'), esc_html($settings['button_text']));
									?>
										<a <?php $this->print_render_attribute_string('button'); ?>><?php bdevs_element_render_icon($settings, 'button_icon', 'button_selected_icon', ['class' => 'btn-icon']); ?><?php echo $button_text; ?></a>
									<?php
									else :
										$this->add_render_attribute('button', 'class', 'btn--icon-after');
										$button_text = sprintf('<span %1$s>%2$s</span>', $this->get_render_attribute_string('button_text'), esc_html($settings['button_text']));
									?>
										<a <?php $this->print_render_attribute_string('button'); ?>><?php echo $button_text; ?><?php bdevs_element_render_icon($settings, 'button_icon', 'button_selected_icon', ['class' => 'btn-icon']); ?></a>
								<?php
									endif;
								endif; ?>
							</div>
						</div>
						<div class="col-xl-6 offset-xl-1 col-lg-7 mb-30">
							<div class="row no-gutters justify-content-between history__row">
								<?php
								$count = 1;
								foreach ($settings['slides'] as $slide) :
									$statistics_class = "statistics__block--h3--one";
									if ($count == 2) {
										$statistics_class = "statistics__block--h3--two";
									} elseif ($count == 3) {
										$statistics_class = "statistics__block--h3--three";
									} elseif ($count == 4) {
										$statistics_class = "statistics__block--h3--four";
									}
								?>
									<div class="col-lg-6 col-md-6 text-center">
										<div class="statistics__block statistics__block--h2 statistics__block--h3 <?php echo esc_attr($statistics_class); ?>">
											<?php if (!empty($slide['selected_icon']['value'])) : ?>
												<span class="fw-600 theme-color">
													<?php \Elementor\Icons_Manager::render_icon($slide['selected_icon'], ['aria-hidden' => 'true', 'class' => 'btn-icon theme-color d-block']); ?>
												</span>
											<?php endif; ?>

											<?php if (!empty($slide['title'])) : ?>
												<p class="counter">
													<?php print bdevs_element_kses_basic($slide['title']); ?>
												</p>
											<?php endif; ?>

											<?php if (!empty($slide['description'])) : ?>
												<h5 class="mb-10 primary-color">
													<?php echo bdevs_element_kses_intermediate($slide['description']); ?>
												</h5>
											<?php endif; ?>
										</div>
									</div>
								<?php $count++;
								endforeach; ?>
							</div>
						</div>
					</div>
				</div>
			</section>

		<?php elseif ($settings['design_style'] === 'style_3'):

			$this->add_inline_editing_attributes('button_text', 'none');
			$this->add_render_attribute('button_text', 'class', 'bdevs-btn-text');
			$this->add_render_attribute('button', 'class', 'btn btn--icon btn--white theme-color');
			$this->add_link_attributes('button', $settings['button_link']);

			if (!empty($settings['bg_image']['id'])) {
				$bg_image = wp_get_attachment_image_url($settings['bg_image']['id'], 'full');
			}
		?>

			<section class="wwa">
				<div class="container">
					<div class="row align-items-center">
						<div class="col-lg-6 mb-30">
							<?php if (!empty($bg_image)) : ?>
								<div class="wwa__thumb">
									<img src="<?php print esc_url($bg_image); ?>" alt="about" />
								</div>
							<?php endif; ?>
						</div>
						<div class="col-lg-6 mb-30">
							<div class="theme">
								<?php if (!empty($settings['sub_title'])) : ?>
									<span class="theme__small--title theme__small--title-left fw-700 text-uppercase white-color"><span
											class="white-line"></span><?php echo bdevs_element_kses_intermediate($settings['sub_title']); ?></span>
								<?php endif; ?>

								<?php if (!empty($settings['title'])) : ?>
									<h2 class="theme__big--title white-color fw-700 mb-30">
										<?php print bdevs_element_kses_basic($settings['title']); ?>
									</h2>
								<?php endif; ?>
							</div>
							<div class="wwa__content">
								<?php if (!empty($settings['description'])) : ?>
									<?php echo wp_kses_post($settings['description']); ?>
								<?php endif; ?>

								<ul>
									<?php foreach ($settings['slides'] as $slide) : ?>
										<?php if (!empty($slide['title'])) : ?>
											<li><?php print bdevs_element_kses_basic($slide['title']); ?>
												<?php if ($slide['description']) : ?>
													<p><?php echo bdevs_element_kses_intermediate($slide['description']); ?></p>
												<?php endif; ?>
											</li>
										<?php endif; ?>
									<?php endforeach; ?>
								</ul>

								<?php if ($settings['button_text'] && ((empty($settings['button_selected_icon']) || empty($settings['button_selected_icon']['value'])) && empty($settings['button_icon']))) :
									$this->add_render_attribute('button', 'class', 'site-btn transparent');
									printf(
										'<a %1$s>%2$s</a>',
										$this->get_render_attribute_string('button'),
										esc_html($settings['button_text'])
									);
								elseif (empty($settings['button_text']) && (!(empty($settings['button_selected_icon']) || empty($settings['button_selected_icon']['value'])) || !empty($settings['button_icon']))) : ?>
									<a <?php $this->print_render_attribute_string('button'); ?>><?php bdevs_element_render_icon($settings, 'button_icon', 'button_selected_icon'); ?></a>
									<?php elseif ($settings['button_text'] && (!(empty($settings['button_selected_icon']) || empty($settings['button_selected_icon']['value'])) || !empty($settings['button_icon']))) :
									if ($settings['button_icon_position'] === 'before') :
										$this->add_render_attribute('button', 'class', 'site-btn transparent btn--icon-before');
										$button_text = sprintf('<span %1$s>%2$s</span>', $this->get_render_attribute_string('button_text'), esc_html($settings['button_text']));
									?>
										<a <?php $this->print_render_attribute_string('button'); ?>><?php bdevs_element_render_icon($settings, 'button_icon', 'button_selected_icon', ['class' => 'btn-icon']); ?><?php echo $button_text; ?></a>
									<?php
									else :
										$this->add_render_attribute('button', 'class', 'btn--icon-after');
										$button_text = sprintf('<span %1$s>%2$s</span>', $this->get_render_attribute_string('button_text'), esc_html($settings['button_text']));
									?>
										<a <?php $this->print_render_attribute_string('button'); ?>><?php echo $button_text; ?><?php bdevs_element_render_icon($settings, 'button_icon', 'button_selected_icon', ['class' => 'btn-icon']); ?></a>
								<?php
									endif;
								endif; ?>
							</div>
						</div>
					</div>
				</div>
			</section>

		<?php elseif ($settings['design_style'] === 'style_2'):
			if (!empty($settings['bg_image']['id'])) {
				$bg_image = wp_get_attachment_image_url($settings['bg_image']['id'], 'full');
			}

			$this->add_inline_editing_attributes('button_text', 'none');
			$this->add_render_attribute('button_text', 'class', 'bdevs-btn-text');
			$this->add_render_attribute('button', 'class', 'btn btn--blue white-color aos-init aos-animate');
			$this->add_render_attribute('button', 'data-aos', 'fade-up');
			$this->add_link_attributes('button', $settings['button_link']);
		?>
			<section class="history-area theme-bg position-relative pt-125 pb-100 fix">
				<div class="history__left--thumb d-none d-lg-block"
					style="background-image: url(<?php print esc_url($bg_image); ?>)">
					<?php if (!empty($settings['video_url'])): ?>
						<a class="popup-video" href="<?php echo esc_url($settings['video_url']) ?>">
							<i class="fas fa-play"></i>
						</a>
					<?php endif; ?>
				</div>
				<img class="history__shape"
					src="<?php echo get_template_directory_uri(); ?>/assets/images/shape/histroy-shape-right.png"
					alt="img">
				<div class="container">
					<div class="row">
						<div class="col-xl-5 offset-xl-7 col-lg-6 offset-lg-6 mb-30 history__right">
							<div class="theme">
								<?php if (!empty($settings['sub_title'])) : ?>
									<span class="theme__small--title theme__small--title-left fw-700 text-uppercase white-color">
										<span class="white-line"></span>
										<?php echo bdevs_element_kses_intermediate($settings['sub_title']); ?>
									</span>
								<?php endif; ?>
								<?php if (!empty($settings['title'])) : ?>
									<h2 class="theme__big--title white-color fw-700 mb-40">
										<?php print bdevs_element_kses_basic($settings['title']); ?>
									</h2>
								<?php endif; ?>
							</div>
							<?php if (!empty($settings['description'])) : ?>
								<div class="history__content">
									<p><?php echo bdevs_element_kses_intermediate($settings['description']); ?></p>
								</div>
							<?php endif; ?>

							<div class="history__tabs">
								<ul class="nav nav-tabs" id="myTab" role="tablist">
									<?php
									$count = 1;
									foreach ($settings['slides'] as $slide) :
										$selected = "false";
										$active = "";
										if ($count == 1) {
											$selected = "true";
											$active = "active";
										}
									?>
										<?php if (!empty($slide['title'])) : ?>
											<li class="nav-item">
												<a class="nav-link <?php echo $active ?>" id="h-tabs-<?php echo $count; ?>"
													data-toggle="tab" href="#h-tab-<?php echo $count; ?>" role="tab"
													aria-controls="h-tab-<?php echo $count; ?>"
													aria-selected="<?php echo $selected ?>">
													<?php print bdevs_element_kses_basic($slide['title']); ?>
												</a>
											</li>
										<?php endif; ?>
									<?php
										$count++;
									endforeach;
									?>
								</ul>
								<div class="tab-content" id="myTabContent">
									<?php
									$count = 1;
									foreach ($settings['slides'] as $slide) :
										$active = "";
										if ($count == 1) {
											$active = "show active";
										}

										if (!empty($slide['image']['id'])) {
											$image = wp_get_attachment_image_url($slide['image']['id'], 'full');
										}
									?>
										<?php if ($slide['title']) : ?>
											<div class="tab-pane fade <?php echo $active ?>" id="h-tab-<?php echo $count; ?>"
												role="tabpanel"
												aria-labelledby="h-tabs-<?php echo $count; ?>">
												<div class="history__what-do d-flex align-items-center flex-wrap flex-md-nowrap">
													<?php if (!empty($slide['description']) && $slide['field_condition'] == 'style_2_2'): ?>
														<div class="content">
															<?php print bdevs_element_kses_basic($slide['description']); ?>
														</div>
													<?php endif; ?>

													<?php if (!empty($image)): ?>
														<div class="img mr-30">
															<img src="<?php print esc_url($image); ?>" alt="img">
														</div>
													<?php endif; ?>

													<?php if (!empty($slide['description']) && $slide['field_condition'] == 'style_2'): ?>
														<div class="content">
															<?php print bdevs_element_kses_basic($slide['description']); ?>
														</div>
													<?php endif; ?>
												</div>
											</div>
										<?php endif; ?>
									<?php
										$count++;
									endforeach; ?>
								</div>
							</div>
						</div>
					</div>
				</div>
			</section>

		<?php else:

			if (!empty($settings['bg_image']['id'])) {
				$bg_image = wp_get_attachment_image_url($settings['bg_image']['id'], 'full');
			}

			$this->add_inline_editing_attributes('button_text', 'none');
			$this->add_render_attribute('button_text', 'class', 'bdevs-btn-text');
			$this->add_render_attribute('button', 'class', 'btn btn--blue white-color aos-init aos-animate');
			$this->add_render_attribute('button', 'data-aos', 'fade-up');
			$this->add_link_attributes('button', $settings['button_link']);
		?>

			<section class="feature feature-area fix">
				<div class="container">
					<div class="row">
						<div class="col-lg-6 position-relative mb-30">
							<?php if (!empty($bg_image)) : ?>
								<div class="feature__img position-relative">
									<div class="feature__img--dot-shape">
										<img class="aos-init"
											src="<?php echo get_template_directory_uri(); ?>/assets/images/shape/feature-dot-shape.png"
											alt="img">
									</div>
									<img class="feature-img js-tilt aos-init "
										src="<?php print esc_url($bg_image); ?>" alt="Features Image">
									<?php if (!empty($settings['extra_info_num'])) : ?>
										<div class="feature__img--caption text-center aos-init aos-animate "
											data-aos="fade-left">
											<div class="feature__img--caption--shadow js-tilt">
												<?php if (!empty($settings['extra_info_num'])) : ?>
													<span class="fw-700 theme-color">
														<?php echo bdevs_element_kses_intermediate($settings['extra_info_num']); ?>
													</span>
												<?php endif; ?>
												<?php if (!empty($settings['extra_info_text'])) : ?>
													<p class="fw-700 theme-color">
														<?php echo bdevs_element_kses_intermediate($settings['extra_info_text']); ?>
													</p>
												<?php endif; ?>
											</div>
										</div>
									<?php endif; ?>
								</div>
							<?php endif; ?>
						</div>
						<div class="col-lg-6 mb-30">
							<div class="feature__content">
								<?php if (!empty($settings['sub_title'])) : ?>
									<span class="fw-700 text-uppercase"><span></span>
										<?php echo bdevs_element_kses_intermediate($settings['sub_title']); ?>
									</span>
								<?php endif; ?>
								<?php if (!empty($settings['title'])) : ?>
									<h2 class="theme-color fw-700 mb-30">
										<?php print bdevs_element_kses_basic($settings['title']); ?>
									</h2>
								<?php endif; ?>
								<?php if (!empty($settings['description'])) : ?>
									<p><?php echo bdevs_element_kses_intermediate($settings['description']); ?></p>
								<?php endif; ?>

								<?php foreach ($settings['slides'] as $slide) : ?>
									<div class="feature__list d-flex">
										<?php if (!empty($slide['selected_icon']['value'])): ?>
											<div class="feature__list--icon">
												<?php \Elementor\Icons_Manager::render_icon($slide['selected_icon'], ['aria-hidden' => 'true', 'class' => 'btn-icon']); ?>
											</div>
										<?php endif; ?>
										<div class="feature__list--content">
											<?php if (!empty($slide['title'])) : ?>
												<h5 class="fw-700 mb-10">
													<?php print bdevs_element_kses_basic($slide['title']); ?>
												</h5>
											<?php endif; ?>
											<?php if (!empty($slide['description'])) : ?>
												<p><?php echo bdevs_element_kses_intermediate($slide['description']); ?></p>
											<?php endif; ?>
										</div>
									</div>
								<?php endforeach; ?>

								<div class="feature__list--button">
									<?php if ($settings['button_text'] && ((empty($settings['button_selected_icon']) || empty($settings['button_selected_icon']['value'])) && empty($settings['button_icon']))) :
										$this->add_render_attribute('button', 'class', 'site-btn transparent');
										printf(
											'<a %1$s>%2$s</a>',
											$this->get_render_attribute_string('button'),
											esc_html($settings['button_text'])
										);
									elseif (empty($settings['button_text']) && (!(empty($settings['button_selected_icon']) || empty($settings['button_selected_icon']['value'])) || !empty($settings['button_icon']))) : ?>
										<a <?php $this->print_render_attribute_string('button'); ?>><?php bdevs_element_render_icon($settings, 'button_icon', 'button_selected_icon'); ?></a>
										<?php elseif ($settings['button_text'] && (!(empty($settings['button_selected_icon']) || empty($settings['button_selected_icon']['value'])) || !empty($settings['button_icon']))) :
										if ($settings['button_icon_position'] === 'before') :
											$this->add_render_attribute('button', 'class', 'site-btn transparent btn--icon-before');
											$button_text = sprintf('<span %1$s>%2$s</span>', $this->get_render_attribute_string('button_text'), esc_html($settings['button_text']));
										?>
											<a <?php $this->print_render_attribute_string('button'); ?>><?php bdevs_element_render_icon($settings, 'button_icon', 'button_selected_icon', ['class' => 'btn-icon']); ?><?php echo $button_text; ?></a>
										<?php
										else :
											$this->add_render_attribute('button', 'class', 'btn--icon-after');
											$button_text = sprintf('<span %1$s>%2$s</span>', $this->get_render_attribute_string('button_text'), esc_html($settings['button_text']));
										?>
											<a <?php $this->print_render_attribute_string('button'); ?>><?php echo $button_text; ?><?php bdevs_element_render_icon($settings, 'button_icon', 'button_selected_icon', ['class' => 'btn-icon']); ?></a>
									<?php
										endif;
									endif; ?>
								</div>
							</div>
						</div>
					</div>
				</div>
			</section>
		<?php endif; ?>

<?php
	}
}
